/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderAsyncClient;
import software.amazon.awssdk.services.cognitoidentityprovider.internal.UserAgentUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolDescriptionType;

public class ListUserPoolsPublisher
implements SdkPublisher<ListUserPoolsResponse> {
    private final CognitoIdentityProviderAsyncClient client;
    private final ListUserPoolsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUserPoolsPublisher(CognitoIdentityProviderAsyncClient client, ListUserPoolsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUserPoolsPublisher(CognitoIdentityProviderAsyncClient client, ListUserPoolsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUserPoolsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUserPoolsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UserPoolDescriptionType> userPools() {
        Function<ListUserPoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.userPools() != null) {
                return response.userPools().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUserPoolsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUserPoolsResponseFetcher
    implements AsyncPageFetcher<ListUserPoolsResponse> {
        private ListUserPoolsResponseFetcher() {
        }

        public boolean hasNextPage(ListUserPoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUserPoolsResponse> nextPage(ListUserPoolsResponse previousPage) {
            if (previousPage == null) {
                return ListUserPoolsPublisher.this.client.listUserPools(ListUserPoolsPublisher.this.firstRequest);
            }
            return ListUserPoolsPublisher.this.client.listUserPools((ListUserPoolsRequest)((Object)ListUserPoolsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

