/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OAuthFlowType {
    CODE("code"),
    IMPLICIT("implicit"),
    CLIENT_CREDENTIALS("client_credentials"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OAuthFlowType> VALUE_MAP;
    private final String value;

    private OAuthFlowType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OAuthFlowType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OAuthFlowType> knownValues() {
        EnumSet<OAuthFlowType> knownValues = EnumSet.allOf(OAuthFlowType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OAuthFlowType.class, OAuthFlowType::toString);
    }
}

