/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompleteWebAuthnRegistrationRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, CompleteWebAuthnRegistrationRequest> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessToken").getter(CompleteWebAuthnRegistrationRequest.getter(CompleteWebAuthnRegistrationRequest::accessToken)).setter(CompleteWebAuthnRegistrationRequest.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()}).build();
    private static final SdkField<Document> CREDENTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("Credential").getter(CompleteWebAuthnRegistrationRequest.getter(CompleteWebAuthnRegistrationRequest::credential)).setter(CompleteWebAuthnRegistrationRequest.setter(Builder::credential)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credential").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, CREDENTIAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CompleteWebAuthnRegistrationRequest.memberNameToFieldInitializer();
    private final String accessToken;
    private final Document credential;

    private CompleteWebAuthnRegistrationRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.credential = builder.credential;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final Document credential() {
        return this.credential;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.credential());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteWebAuthnRegistrationRequest)) {
            return false;
        }
        CompleteWebAuthnRegistrationRequest other = (CompleteWebAuthnRegistrationRequest)((Object)obj);
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.credential(), other.credential());
    }

    public final String toString() {
        return ToString.builder((String)"CompleteWebAuthnRegistrationRequest").add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Credential", (Object)this.credential()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "Credential": {
                return Optional.ofNullable(clazz.cast(this.credential()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccessToken", ACCESS_TOKEN_FIELD);
        map.put("Credential", CREDENTIAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompleteWebAuthnRegistrationRequest, T> g) {
        return obj -> g.apply((CompleteWebAuthnRegistrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String accessToken;
        private Document credential;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteWebAuthnRegistrationRequest model) {
            super(model);
            this.accessToken(model.accessToken);
            this.credential(model.credential);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final Document getCredential() {
            return this.credential;
        }

        public final void setCredential(Document credential) {
            this.credential = credential;
        }

        @Override
        public final Builder credential(Document credential) {
            this.credential = credential;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CompleteWebAuthnRegistrationRequest build() {
            return new CompleteWebAuthnRegistrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CompleteWebAuthnRegistrationRequest> {
        public Builder accessToken(String var1);

        public Builder credential(Document var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

