/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobsListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUserImportJobsResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, ListUserImportJobsResponse> {
    private static final SdkField<List<UserImportJobType>> USER_IMPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserImportJobs").getter(ListUserImportJobsResponse.getter(ListUserImportJobsResponse::userImportJobs)).setter(ListUserImportJobsResponse.setter(Builder::userImportJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserImportJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserImportJobType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaginationToken").getter(ListUserImportJobsResponse.getter(ListUserImportJobsResponse::paginationToken)).setter(ListUserImportJobsResponse.setter(Builder::paginationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_IMPORT_JOBS_FIELD, PAGINATION_TOKEN_FIELD));
    private final List<UserImportJobType> userImportJobs;
    private final String paginationToken;

    private ListUserImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.userImportJobs = builder.userImportJobs;
        this.paginationToken = builder.paginationToken;
    }

    public final boolean hasUserImportJobs() {
        return this.userImportJobs != null && !(this.userImportJobs instanceof SdkAutoConstructList);
    }

    public final List<UserImportJobType> userImportJobs() {
        return this.userImportJobs;
    }

    public final String paginationToken() {
        return this.paginationToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserImportJobs() ? this.userImportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserImportJobsResponse)) {
            return false;
        }
        ListUserImportJobsResponse other = (ListUserImportJobsResponse)((Object)obj);
        return this.hasUserImportJobs() == other.hasUserImportJobs() && Objects.equals(this.userImportJobs(), other.userImportJobs()) && Objects.equals(this.paginationToken(), other.paginationToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListUserImportJobsResponse").add("UserImportJobs", this.hasUserImportJobs() ? this.userImportJobs() : null).add("PaginationToken", (Object)this.paginationToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserImportJobs": {
                return Optional.ofNullable(clazz.cast(this.userImportJobs()));
            }
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUserImportJobsResponse, T> g) {
        return obj -> g.apply((ListUserImportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private List<UserImportJobType> userImportJobs = DefaultSdkAutoConstructList.getInstance();
        private String paginationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserImportJobsResponse model) {
            super(model);
            this.userImportJobs(model.userImportJobs);
            this.paginationToken(model.paginationToken);
        }

        public final List<UserImportJobType.Builder> getUserImportJobs() {
            List<UserImportJobType.Builder> result = UserImportJobsListTypeCopier.copyToBuilder(this.userImportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder userImportJobs(Collection<UserImportJobType> userImportJobs) {
            this.userImportJobs = UserImportJobsListTypeCopier.copy(userImportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userImportJobs(UserImportJobType ... userImportJobs) {
            this.userImportJobs(Arrays.asList(userImportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userImportJobs(Consumer<UserImportJobType.Builder> ... userImportJobs) {
            this.userImportJobs(Stream.of(userImportJobs).map(c -> (UserImportJobType)((UserImportJobType.Builder)UserImportJobType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserImportJobs(Collection<UserImportJobType.BuilderImpl> userImportJobs) {
            this.userImportJobs = UserImportJobsListTypeCopier.copyFromBuilder(userImportJobs);
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public ListUserImportJobsResponse build() {
            return new ListUserImportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUserImportJobsResponse> {
        public Builder userImportJobs(Collection<UserImportJobType> var1);

        public Builder userImportJobs(UserImportJobType ... var1);

        public Builder userImportJobs(Consumer<UserImportJobType.Builder> ... var1);

        public Builder paginationToken(String var1);
    }
}

