/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cognitoidentity.endpoints.CognitoIdentityEndpointParams;
import software.amazon.awssdk.services.cognitoidentity.endpoints.CognitoIdentityEndpointProvider;
import software.amazon.awssdk.services.cognitoidentity.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.cognitoidentity.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.cognitoidentity.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultCognitoIdentityEndpointProvider
implements CognitoIdentityEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(CognitoIdentityEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultCognitoIdentityEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(CognitoIdentityEndpointParams params, LocalState locals) {
        RuleResult result = DefaultCognitoIdentityEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultCognitoIdentityEndpointProvider.endpointRule5(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultCognitoIdentityEndpointProvider.endpointRule25(params, locals);
    }

    private static RuleResult endpointRule1(CognitoIdentityEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultCognitoIdentityEndpointProvider.endpointRule2(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultCognitoIdentityEndpointProvider.endpointRule3(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCognitoIdentityEndpointProvider.endpointRule4(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(CognitoIdentityEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(CognitoIdentityEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(CognitoIdentityEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule5(CognitoIdentityEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultCognitoIdentityEndpointProvider.endpointRule6(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(CognitoIdentityEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultCognitoIdentityEndpointProvider.endpointRule7(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultCognitoIdentityEndpointProvider.endpointRule15(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultCognitoIdentityEndpointProvider.endpointRule19(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCognitoIdentityEndpointProvider.endpointRule24(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(CognitoIdentityEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultCognitoIdentityEndpointProvider.endpointRule8(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCognitoIdentityEndpointProvider.endpointRule14(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(CognitoIdentityEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS() && locals.partitionResult().supportsDualStack()) {
            RuleResult result = DefaultCognitoIdentityEndpointProvider.endpointRule9(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultCognitoIdentityEndpointProvider.endpointRule10(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultCognitoIdentityEndpointProvider.endpointRule11(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultCognitoIdentityEndpointProvider.endpointRule12(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCognitoIdentityEndpointProvider.endpointRule13(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(CognitoIdentityEndpointParams params, LocalState locals) {
        if ("us-east-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity-fips.us-east-1.amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(CognitoIdentityEndpointParams params, LocalState locals) {
        if ("us-east-2".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity-fips.us-east-2.amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(CognitoIdentityEndpointParams params, LocalState locals) {
        if ("us-west-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity-fips.us-west-1.amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(CognitoIdentityEndpointParams params, LocalState locals) {
        if ("us-west-2".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity-fips.us-west-2.amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(CognitoIdentityEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule14(CognitoIdentityEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static RuleResult endpointRule15(CognitoIdentityEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultCognitoIdentityEndpointProvider.endpointRule16(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCognitoIdentityEndpointProvider.endpointRule18(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(CognitoIdentityEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            return DefaultCognitoIdentityEndpointProvider.endpointRule17(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(CognitoIdentityEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule18(CognitoIdentityEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule19(CognitoIdentityEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultCognitoIdentityEndpointProvider.endpointRule20(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCognitoIdentityEndpointProvider.endpointRule23(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(CognitoIdentityEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            RuleResult result = DefaultCognitoIdentityEndpointProvider.endpointRule21(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCognitoIdentityEndpointProvider.endpointRule22(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(CognitoIdentityEndpointParams params, LocalState locals) {
        if ("aws".equals(locals.partitionResult().name())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity." + locals.region() + ".amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule22(CognitoIdentityEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule23(CognitoIdentityEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule24(CognitoIdentityEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule25(CognitoIdentityEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

