/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the <code>GetCredentialsForIdentity</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCredentialsForIdentityRequest extends CognitoIdentityRequest implements
        ToCopyableBuilder<GetCredentialsForIdentityRequest.Builder, GetCredentialsForIdentityRequest> {
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityId").getter(getter(GetCredentialsForIdentityRequest::identityId))
            .setter(setter(Builder::identityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()).build();

    private static final SdkField<Map<String, String>> LOGINS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Logins")
            .getter(getter(GetCredentialsForIdentityRequest::logins))
            .setter(setter(Builder::logins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logins").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CUSTOM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomRoleArn").getter(getter(GetCredentialsForIdentityRequest::customRoleArn))
            .setter(setter(Builder::customRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_ID_FIELD,
            LOGINS_FIELD, CUSTOM_ROLE_ARN_FIELD));

    private final String identityId;

    private final Map<String, String> logins;

    private final String customRoleArn;

    private GetCredentialsForIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.logins = builder.logins;
        this.customRoleArn = builder.customRoleArn;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public final String identityId() {
        return identityId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Logins property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogins() {
        return logins != null && !(logins instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of optional name-value pairs that map provider names to provider tokens. The name-value pair will follow
     * the syntax "provider_name": "provider_user_identifier".
     * </p>
     * <p>
     * Logins should not be specified when trying to get credentials for an unauthenticated identity.
     * </p>
     * <p>
     * The Logins parameter is required when using identities associated with external identity providers such as
     * Facebook. For examples of <code>Logins</code> maps, see the code examples in the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html">External
     * Identity Providers</a> section of the Amazon Cognito Developer Guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogins} method.
     * </p>
     * 
     * @return A set of optional name-value pairs that map provider names to provider tokens. The name-value pair will
     *         follow the syntax "provider_name": "provider_user_identifier".</p>
     *         <p>
     *         Logins should not be specified when trying to get credentials for an unauthenticated identity.
     *         </p>
     *         <p>
     *         The Logins parameter is required when using identities associated with external identity providers such
     *         as Facebook. For examples of <code>Logins</code> maps, see the code examples in the <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html"
     *         >External Identity Providers</a> section of the Amazon Cognito Developer Guide.
     */
    public final Map<String, String> logins() {
        return logins;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were received in the token from the
     * identity provider. For example, a SAML-based identity provider. This parameter is optional for identity providers
     * that do not support role customization.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were received in the token
     *         from the identity provider. For example, a SAML-based identity provider. This parameter is optional for
     *         identity providers that do not support role customization.
     */
    public final String customRoleArn() {
        return customRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogins() ? logins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCredentialsForIdentityRequest)) {
            return false;
        }
        GetCredentialsForIdentityRequest other = (GetCredentialsForIdentityRequest) obj;
        return Objects.equals(identityId(), other.identityId()) && hasLogins() == other.hasLogins()
                && Objects.equals(logins(), other.logins()) && Objects.equals(customRoleArn(), other.customRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCredentialsForIdentityRequest").add("IdentityId", identityId())
                .add("Logins", hasLogins() ? logins() : null).add("CustomRoleArn", customRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityId":
            return Optional.ofNullable(clazz.cast(identityId()));
        case "Logins":
            return Optional.ofNullable(clazz.cast(logins()));
        case "CustomRoleArn":
            return Optional.ofNullable(clazz.cast(customRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCredentialsForIdentityRequest, T> g) {
        return obj -> g.apply((GetCredentialsForIdentityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCredentialsForIdentityRequest> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * A set of optional name-value pairs that map provider names to provider tokens. The name-value pair will
         * follow the syntax "provider_name": "provider_user_identifier".
         * </p>
         * <p>
         * Logins should not be specified when trying to get credentials for an unauthenticated identity.
         * </p>
         * <p>
         * The Logins parameter is required when using identities associated with external identity providers such as
         * Facebook. For examples of <code>Logins</code> maps, see the code examples in the <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html">External
         * Identity Providers</a> section of the Amazon Cognito Developer Guide.
         * </p>
         * 
         * @param logins
         *        A set of optional name-value pairs that map provider names to provider tokens. The name-value pair
         *        will follow the syntax "provider_name": "provider_user_identifier".</p>
         *        <p>
         *        Logins should not be specified when trying to get credentials for an unauthenticated identity.
         *        </p>
         *        <p>
         *        The Logins parameter is required when using identities associated with external identity providers
         *        such as Facebook. For examples of <code>Logins</code> maps, see the code examples in the <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html"
         *        >External Identity Providers</a> section of the Amazon Cognito Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(Map<String, String> logins);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were received in the token from
         * the identity provider. For example, a SAML-based identity provider. This parameter is optional for identity
         * providers that do not support role customization.
         * </p>
         * 
         * @param customRoleArn
         *        The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were received in the
         *        token from the identity provider. For example, a SAML-based identity provider. This parameter is
         *        optional for identity providers that do not support role customization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRoleArn(String customRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityRequest.BuilderImpl implements Builder {
        private String identityId;

        private Map<String, String> logins = DefaultSdkAutoConstructMap.getInstance();

        private String customRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCredentialsForIdentityRequest model) {
            super(model);
            identityId(model.identityId);
            logins(model.logins);
            customRoleArn(model.customRoleArn);
        }

        public final String getIdentityId() {
            return identityId;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        @Override
        @Transient
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final Map<String, String> getLogins() {
            if (logins instanceof SdkAutoConstructMap) {
                return null;
            }
            return logins;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        @Override
        @Transient
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final String getCustomRoleArn() {
            return customRoleArn;
        }

        public final void setCustomRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
        }

        @Override
        @Transient
        public final Builder customRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCredentialsForIdentityRequest build() {
            return new GetCredentialsForIdentityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
