/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codestarconnections.model.CodeStarConnectionsResponse;
import software.amazon.awssdk.services.codestarconnections.model.SyncBlocker;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSyncBlockerResponse
extends CodeStarConnectionsResponse
implements ToCopyableBuilder<Builder, UpdateSyncBlockerResponse> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(UpdateSyncBlockerResponse.getter(UpdateSyncBlockerResponse::resourceName)).setter(UpdateSyncBlockerResponse.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()}).build();
    private static final SdkField<String> PARENT_RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentResourceName").getter(UpdateSyncBlockerResponse.getter(UpdateSyncBlockerResponse::parentResourceName)).setter(UpdateSyncBlockerResponse.setter(Builder::parentResourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentResourceName").build()}).build();
    private static final SdkField<SyncBlocker> SYNC_BLOCKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SyncBlocker").getter(UpdateSyncBlockerResponse.getter(UpdateSyncBlockerResponse::syncBlocker)).setter(UpdateSyncBlockerResponse.setter(Builder::syncBlocker)).constructor(SyncBlocker::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncBlocker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD, PARENT_RESOURCE_NAME_FIELD, SYNC_BLOCKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSyncBlockerResponse.memberNameToFieldInitializer();
    private final String resourceName;
    private final String parentResourceName;
    private final SyncBlocker syncBlocker;

    private UpdateSyncBlockerResponse(BuilderImpl builder) {
        super(builder);
        this.resourceName = builder.resourceName;
        this.parentResourceName = builder.parentResourceName;
        this.syncBlocker = builder.syncBlocker;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final String parentResourceName() {
        return this.parentResourceName;
    }

    public final SyncBlocker syncBlocker() {
        return this.syncBlocker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncBlocker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSyncBlockerResponse)) {
            return false;
        }
        UpdateSyncBlockerResponse other = (UpdateSyncBlockerResponse)((Object)obj);
        return Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.parentResourceName(), other.parentResourceName()) && Objects.equals(this.syncBlocker(), other.syncBlocker());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSyncBlockerResponse").add("ResourceName", (Object)this.resourceName()).add("ParentResourceName", (Object)this.parentResourceName()).add("SyncBlocker", (Object)this.syncBlocker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "ParentResourceName": {
                return Optional.ofNullable(clazz.cast(this.parentResourceName()));
            }
            case "SyncBlocker": {
                return Optional.ofNullable(clazz.cast(this.syncBlocker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("ParentResourceName", PARENT_RESOURCE_NAME_FIELD);
        map.put("SyncBlocker", SYNC_BLOCKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSyncBlockerResponse, T> g) {
        return obj -> g.apply((UpdateSyncBlockerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeStarConnectionsResponse.BuilderImpl
    implements Builder {
        private String resourceName;
        private String parentResourceName;
        private SyncBlocker syncBlocker;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSyncBlockerResponse model) {
            super(model);
            this.resourceName(model.resourceName);
            this.parentResourceName(model.parentResourceName);
            this.syncBlocker(model.syncBlocker);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getParentResourceName() {
            return this.parentResourceName;
        }

        public final void setParentResourceName(String parentResourceName) {
            this.parentResourceName = parentResourceName;
        }

        @Override
        public final Builder parentResourceName(String parentResourceName) {
            this.parentResourceName = parentResourceName;
            return this;
        }

        public final SyncBlocker.Builder getSyncBlocker() {
            return this.syncBlocker != null ? this.syncBlocker.toBuilder() : null;
        }

        public final void setSyncBlocker(SyncBlocker.BuilderImpl syncBlocker) {
            this.syncBlocker = syncBlocker != null ? syncBlocker.build() : null;
        }

        @Override
        public final Builder syncBlocker(SyncBlocker syncBlocker) {
            this.syncBlocker = syncBlocker;
            return this;
        }

        @Override
        public UpdateSyncBlockerResponse build() {
            return new UpdateSyncBlockerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeStarConnectionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSyncBlockerResponse> {
        public Builder resourceName(String var1);

        public Builder parentResourceName(String var1);

        public Builder syncBlocker(SyncBlocker var1);

        default public Builder syncBlocker(Consumer<SyncBlocker.Builder> syncBlocker) {
            return this.syncBlocker((SyncBlocker)((SyncBlocker.Builder)SyncBlocker.builder().applyMutation(syncBlocker)).build());
        }
    }
}

