/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.GitTagPatternListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GitTagFilterCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GitTagFilterCriteria> {
    private static final SdkField<List<String>> INCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("includes").getter(GitTagFilterCriteria.getter(GitTagFilterCriteria::includes)).setter(GitTagFilterCriteria.setter(Builder::includes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("excludes").getter(GitTagFilterCriteria.getter(GitTagFilterCriteria::excludes)).setter(GitTagFilterCriteria.setter(Builder::excludes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDES_FIELD, EXCLUDES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GitTagFilterCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> includes;
    private final List<String> excludes;

    private GitTagFilterCriteria(BuilderImpl builder) {
        this.includes = builder.includes;
        this.excludes = builder.excludes;
    }

    public final boolean hasIncludes() {
        return this.includes != null && !(this.includes instanceof SdkAutoConstructList);
    }

    public final List<String> includes() {
        return this.includes;
    }

    public final boolean hasExcludes() {
        return this.excludes != null && !(this.excludes instanceof SdkAutoConstructList);
    }

    public final List<String> excludes() {
        return this.excludes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludes() ? this.includes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludes() ? this.excludes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitTagFilterCriteria)) {
            return false;
        }
        GitTagFilterCriteria other = (GitTagFilterCriteria)obj;
        return this.hasIncludes() == other.hasIncludes() && Objects.equals(this.includes(), other.includes()) && this.hasExcludes() == other.hasExcludes() && Objects.equals(this.excludes(), other.excludes());
    }

    public final String toString() {
        return ToString.builder((String)"GitTagFilterCriteria").add("Includes", this.hasIncludes() ? this.includes() : null).add("Excludes", this.hasExcludes() ? this.excludes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "includes": {
                return Optional.ofNullable(clazz.cast(this.includes()));
            }
            case "excludes": {
                return Optional.ofNullable(clazz.cast(this.excludes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("includes", INCLUDES_FIELD);
        map.put("excludes", EXCLUDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GitTagFilterCriteria, T> g) {
        return obj -> g.apply((GitTagFilterCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> includes = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GitTagFilterCriteria model) {
            this.includes(model.includes);
            this.excludes(model.excludes);
        }

        public final Collection<String> getIncludes() {
            if (this.includes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includes;
        }

        public final void setIncludes(Collection<String> includes) {
            this.includes = GitTagPatternListCopier.copy(includes);
        }

        @Override
        public final Builder includes(Collection<String> includes) {
            this.includes = GitTagPatternListCopier.copy(includes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(String ... includes) {
            this.includes(Arrays.asList(includes));
            return this;
        }

        public final Collection<String> getExcludes() {
            if (this.excludes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludes;
        }

        public final void setExcludes(Collection<String> excludes) {
            this.excludes = GitTagPatternListCopier.copy(excludes);
        }

        @Override
        public final Builder excludes(Collection<String> excludes) {
            this.excludes = GitTagPatternListCopier.copy(excludes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(String ... excludes) {
            this.excludes(Arrays.asList(excludes));
            return this;
        }

        public GitTagFilterCriteria build() {
            return new GitTagFilterCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GitTagFilterCriteria> {
        public Builder includes(Collection<String> var1);

        public Builder includes(String ... var1);

        public Builder excludes(Collection<String> var1);

        public Builder excludes(String ... var1);
    }
}

