/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codepipeline.CodePipelineClient;
import software.amazon.awssdk.services.codepipeline.internal.UserAgentUtils;
import software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.RuleExecutionDetail;

public class ListRuleExecutionsIterable
implements SdkIterable<ListRuleExecutionsResponse> {
    private final CodePipelineClient client;
    private final ListRuleExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRuleExecutionsIterable(CodePipelineClient client, ListRuleExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRuleExecutionsResponseFetcher();
    }

    public Iterator<ListRuleExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RuleExecutionDetail> ruleExecutionDetails() {
        Function<ListRuleExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ruleExecutionDetails() != null) {
                return response.ruleExecutionDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRuleExecutionsResponseFetcher
    implements SyncPageFetcher<ListRuleExecutionsResponse> {
        private ListRuleExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListRuleExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRuleExecutionsResponse nextPage(ListRuleExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListRuleExecutionsIterable.this.client.listRuleExecutions(ListRuleExecutionsIterable.this.firstRequest);
            }
            return ListRuleExecutionsIterable.this.client.listRuleExecutions((ListRuleExecutionsRequest)((Object)ListRuleExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

