/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.PollingAccountListCopier;
import software.amazon.awssdk.services.codepipeline.model.PollingServicePrincipalListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobWorkerExecutorConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobWorkerExecutorConfiguration> {
    private static final SdkField<List<String>> POLLING_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pollingAccounts").getter(JobWorkerExecutorConfiguration.getter(JobWorkerExecutorConfiguration::pollingAccounts)).setter(JobWorkerExecutorConfiguration.setter(Builder::pollingAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pollingAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> POLLING_SERVICE_PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pollingServicePrincipals").getter(JobWorkerExecutorConfiguration.getter(JobWorkerExecutorConfiguration::pollingServicePrincipals)).setter(JobWorkerExecutorConfiguration.setter(Builder::pollingServicePrincipals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pollingServicePrincipals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLLING_ACCOUNTS_FIELD, POLLING_SERVICE_PRINCIPALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobWorkerExecutorConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> pollingAccounts;
    private final List<String> pollingServicePrincipals;

    private JobWorkerExecutorConfiguration(BuilderImpl builder) {
        this.pollingAccounts = builder.pollingAccounts;
        this.pollingServicePrincipals = builder.pollingServicePrincipals;
    }

    public final boolean hasPollingAccounts() {
        return this.pollingAccounts != null && !(this.pollingAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> pollingAccounts() {
        return this.pollingAccounts;
    }

    public final boolean hasPollingServicePrincipals() {
        return this.pollingServicePrincipals != null && !(this.pollingServicePrincipals instanceof SdkAutoConstructList);
    }

    public final List<String> pollingServicePrincipals() {
        return this.pollingServicePrincipals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPollingAccounts() ? this.pollingAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPollingServicePrincipals() ? this.pollingServicePrincipals() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobWorkerExecutorConfiguration)) {
            return false;
        }
        JobWorkerExecutorConfiguration other = (JobWorkerExecutorConfiguration)obj;
        return this.hasPollingAccounts() == other.hasPollingAccounts() && Objects.equals(this.pollingAccounts(), other.pollingAccounts()) && this.hasPollingServicePrincipals() == other.hasPollingServicePrincipals() && Objects.equals(this.pollingServicePrincipals(), other.pollingServicePrincipals());
    }

    public final String toString() {
        return ToString.builder((String)"JobWorkerExecutorConfiguration").add("PollingAccounts", this.hasPollingAccounts() ? this.pollingAccounts() : null).add("PollingServicePrincipals", this.hasPollingServicePrincipals() ? this.pollingServicePrincipals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pollingAccounts": {
                return Optional.ofNullable(clazz.cast(this.pollingAccounts()));
            }
            case "pollingServicePrincipals": {
                return Optional.ofNullable(clazz.cast(this.pollingServicePrincipals()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("pollingAccounts", POLLING_ACCOUNTS_FIELD);
        map.put("pollingServicePrincipals", POLLING_SERVICE_PRINCIPALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobWorkerExecutorConfiguration, T> g) {
        return obj -> g.apply((JobWorkerExecutorConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> pollingAccounts = DefaultSdkAutoConstructList.getInstance();
        private List<String> pollingServicePrincipals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobWorkerExecutorConfiguration model) {
            this.pollingAccounts(model.pollingAccounts);
            this.pollingServicePrincipals(model.pollingServicePrincipals);
        }

        public final Collection<String> getPollingAccounts() {
            if (this.pollingAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pollingAccounts;
        }

        public final void setPollingAccounts(Collection<String> pollingAccounts) {
            this.pollingAccounts = PollingAccountListCopier.copy(pollingAccounts);
        }

        @Override
        public final Builder pollingAccounts(Collection<String> pollingAccounts) {
            this.pollingAccounts = PollingAccountListCopier.copy(pollingAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pollingAccounts(String ... pollingAccounts) {
            this.pollingAccounts(Arrays.asList(pollingAccounts));
            return this;
        }

        public final Collection<String> getPollingServicePrincipals() {
            if (this.pollingServicePrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pollingServicePrincipals;
        }

        public final void setPollingServicePrincipals(Collection<String> pollingServicePrincipals) {
            this.pollingServicePrincipals = PollingServicePrincipalListCopier.copy(pollingServicePrincipals);
        }

        @Override
        public final Builder pollingServicePrincipals(Collection<String> pollingServicePrincipals) {
            this.pollingServicePrincipals = PollingServicePrincipalListCopier.copy(pollingServicePrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pollingServicePrincipals(String ... pollingServicePrincipals) {
            this.pollingServicePrincipals(Arrays.asList(pollingServicePrincipals));
            return this;
        }

        public JobWorkerExecutorConfiguration build() {
            return new JobWorkerExecutorConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobWorkerExecutorConfiguration> {
        public Builder pollingAccounts(Collection<String> var1);

        public Builder pollingAccounts(String ... var1);

        public Builder pollingServicePrincipals(Collection<String> var1);

        public Builder pollingServicePrincipals(String ... var1);
    }
}

