/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsError;
import software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsErrorsCopier;
import software.amazon.awssdk.services.codegurusecurity.model.CodeGuruSecurityResponse;
import software.amazon.awssdk.services.codegurusecurity.model.Finding;
import software.amazon.awssdk.services.codegurusecurity.model.FindingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetFindingsResponse
extends CodeGuruSecurityResponse
implements ToCopyableBuilder<Builder, BatchGetFindingsResponse> {
    private static final SdkField<List<Finding>> FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findings").getter(BatchGetFindingsResponse.getter(BatchGetFindingsResponse::findings)).setter(BatchGetFindingsResponse.setter(Builder::findings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Finding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetFindingsError>> FAILED_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedFindings").getter(BatchGetFindingsResponse.getter(BatchGetFindingsResponse::failedFindings)).setter(BatchGetFindingsResponse.setter(Builder::failedFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetFindingsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDINGS_FIELD, FAILED_FINDINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetFindingsResponse.memberNameToFieldInitializer();
    private final List<Finding> findings;
    private final List<BatchGetFindingsError> failedFindings;

    private BatchGetFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.findings = builder.findings;
        this.failedFindings = builder.failedFindings;
    }

    public final boolean hasFindings() {
        return this.findings != null && !(this.findings instanceof SdkAutoConstructList);
    }

    public final List<Finding> findings() {
        return this.findings;
    }

    public final boolean hasFailedFindings() {
        return this.failedFindings != null && !(this.failedFindings instanceof SdkAutoConstructList);
    }

    public final List<BatchGetFindingsError> failedFindings() {
        return this.failedFindings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindings() ? this.findings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedFindings() ? this.failedFindings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFindingsResponse)) {
            return false;
        }
        BatchGetFindingsResponse other = (BatchGetFindingsResponse)((Object)obj);
        return this.hasFindings() == other.hasFindings() && Objects.equals(this.findings(), other.findings()) && this.hasFailedFindings() == other.hasFailedFindings() && Objects.equals(this.failedFindings(), other.failedFindings());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetFindingsResponse").add("Findings", this.hasFindings() ? this.findings() : null).add("FailedFindings", this.hasFailedFindings() ? this.failedFindings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findings": {
                return Optional.ofNullable(clazz.cast(this.findings()));
            }
            case "failedFindings": {
                return Optional.ofNullable(clazz.cast(this.failedFindings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("findings", FINDINGS_FIELD);
        map.put("failedFindings", FAILED_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFindingsResponse, T> g) {
        return obj -> g.apply((BatchGetFindingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruSecurityResponse.BuilderImpl
    implements Builder {
        private List<Finding> findings = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetFindingsError> failedFindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFindingsResponse model) {
            super(model);
            this.findings(model.findings);
            this.failedFindings(model.failedFindings);
        }

        public final List<Finding.Builder> getFindings() {
            List<Finding.Builder> result = FindingsCopier.copyToBuilder(this.findings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindings(Collection<Finding.BuilderImpl> findings) {
            this.findings = FindingsCopier.copyFromBuilder(findings);
        }

        @Override
        public final Builder findings(Collection<Finding> findings) {
            this.findings = FindingsCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Finding ... findings) {
            this.findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Consumer<Finding.Builder> ... findings) {
            this.findings(Stream.of(findings).map(c -> (Finding)((Finding.Builder)Finding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetFindingsError.Builder> getFailedFindings() {
            List<BatchGetFindingsError.Builder> result = BatchGetFindingsErrorsCopier.copyToBuilder(this.failedFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedFindings(Collection<BatchGetFindingsError.BuilderImpl> failedFindings) {
            this.failedFindings = BatchGetFindingsErrorsCopier.copyFromBuilder(failedFindings);
        }

        @Override
        public final Builder failedFindings(Collection<BatchGetFindingsError> failedFindings) {
            this.failedFindings = BatchGetFindingsErrorsCopier.copy(failedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedFindings(BatchGetFindingsError ... failedFindings) {
            this.failedFindings(Arrays.asList(failedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedFindings(Consumer<BatchGetFindingsError.Builder> ... failedFindings) {
            this.failedFindings(Stream.of(failedFindings).map(c -> (BatchGetFindingsError)((BatchGetFindingsError.Builder)BatchGetFindingsError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetFindingsResponse build() {
            return new BatchGetFindingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeGuruSecurityResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetFindingsResponse> {
        public Builder findings(Collection<Finding> var1);

        public Builder findings(Finding ... var1);

        public Builder findings(Consumer<Finding.Builder> ... var1);

        public Builder failedFindings(Collection<BatchGetFindingsError> var1);

        public Builder failedFindings(BatchGetFindingsError ... var1);

        public Builder failedFindings(Consumer<BatchGetFindingsError.Builder> ... var1);
    }
}

