/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.auth.signer.EventStreamAws4Signer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.codegen.model.config.customization.S3ArnableFieldConfig;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.service.HostPrefixProcessor;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.utils.HostnameValidator;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;

public final class ClientClassUtils {
    private ClientClassUtils() {
    }

    static MethodSpec consumerBuilderVariant(MethodSpec spec, String javadoc) {
        Validate.validState((spec.parameters.size() > 0 ? 1 : 0) != 0, (String)"A first parameter is required to generate a consumer-builder method.", (Object[])new Object[0]);
        Validate.validState((boolean)(((ParameterSpec)spec.parameters.get((int)0)).type instanceof ClassName), (String)"The first parameter must be a class.", (Object[])new Object[0]);
        ParameterSpec firstParameter = (ParameterSpec)spec.parameters.get(0);
        ClassName firstParameterClass = (ClassName)firstParameter.type;
        ParameterizedTypeName consumer = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{firstParameterClass.nestedClass("Builder")});
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)spec.name).returns(spec.returnType).addExceptions((Iterable)spec.exceptions).addAnnotations((Iterable)spec.annotations).addJavadoc(javadoc, new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addTypeVariables((Iterable)spec.typeVariables).addParameter(ParameterSpec.builder((TypeName)consumer, (String)firstParameter.name, (Modifier[])new Modifier[0]).build());
        StringBuilder methodBody = new StringBuilder("return $L($T.builder().applyMutation($L).build()");
        for (int i = 1; i < spec.parameters.size(); ++i) {
            ParameterSpec parameter = (ParameterSpec)spec.parameters.get(i);
            methodBody.append(", ").append(parameter.name);
            result.addParameter(parameter);
        }
        methodBody.append(")");
        result.addStatement(methodBody.toString(), new Object[]{spec.name, firstParameterClass, firstParameter.name});
        return result.build();
    }

    static MethodSpec applySignerOverrideMethod(PoetExtension poetExtensions, IntermediateModel model) {
        String signerOverrideVariable = "signerOverride";
        TypeVariableName typeVariableName = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{poetExtensions.getModelClass(model.getSdkRequestBaseClassName())});
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{ClassName.get(AwsRequestOverrideConfiguration.Builder.class)});
        CodeBlock codeBlock = CodeBlock.builder().beginControlFlow("if (request.overrideConfiguration().flatMap(c -> c.signer()).isPresent())", new Object[0]).addStatement("return request", new Object[0]).endControlFlow().addStatement("$T $L = b -> b.signer(signer).build()", new Object[]{parameterizedTypeName, signerOverrideVariable}).addStatement("$1T overrideConfiguration =\n            request.overrideConfiguration().map(c -> c.toBuilder().applyMutation($2L).build())\n            .orElse((AwsRequestOverrideConfiguration.builder().applyMutation($2L).build()))", new Object[]{AwsRequestOverrideConfiguration.class, signerOverrideVariable}).addStatement("return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build()", new Object[0]).build();
        return MethodSpec.methodBuilder((String)"applySignerOverride").addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)typeVariableName, "request", new Modifier[0]).addParameter(Signer.class, "signer", new Modifier[0]).addTypeVariable(typeVariableName).addCode(codeBlock).returns((TypeName)typeVariableName).build();
    }

    static CodeBlock callApplySignerOverrideMethod(OperationModel opModel) {
        CodeBlock.Builder code = CodeBlock.builder();
        ShapeModel inputShape = opModel.getInputShape();
        if (inputShape.getRequestSignerClassFqcn() != null) {
            code.addStatement("$1L = applySignerOverride($1L, $2T.create())", new Object[]{opModel.getInput().getVariableName(), PoetUtils.classNameFromFqcn(inputShape.getRequestSignerClassFqcn())});
        } else if (opModel.hasEventStreamInput()) {
            code.addStatement("$1L = applySignerOverride($1L, $2T.create())", new Object[]{opModel.getInput().getVariableName(), EventStreamAws4Signer.class});
        }
        return code.build();
    }

    static CodeBlock addEndpointTraitCode(OperationModel opModel) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (opModel.getEndpointTrait() != null && !StringUtils.isEmpty((CharSequence)opModel.getEndpointTrait().getHostPrefix())) {
            String hostPrefix = opModel.getEndpointTrait().getHostPrefix();
            HostPrefixProcessor processor = new HostPrefixProcessor(hostPrefix);
            builder.addStatement("String hostPrefix = $S", new Object[]{hostPrefix});
            if (processor.c2jNames().isEmpty()) {
                builder.addStatement("String resolvedHostExpression = $S", new Object[]{processor.hostWithStringSpecifier()});
            } else {
                processor.c2jNames().forEach(name -> builder.addStatement("$T.validateHostnameCompliant($L, $S, $S)", new Object[]{HostnameValidator.class, ClientClassUtils.inputShapeMemberGetter(opModel, name), name, opModel.getInput().getVariableName()}));
                builder.addStatement("String resolvedHostExpression = String.format($S, $L)", new Object[]{processor.hostWithStringSpecifier(), processor.c2jNames().stream().map(n -> ClientClassUtils.inputShapeMemberGetter(opModel, n)).collect(Collectors.joining(","))});
            }
        }
        return builder.build();
    }

    static Optional<CodeBlock> addS3ArnableFieldCode(OperationModel opModel, IntermediateModel model) {
        CodeBlock.Builder builder = CodeBlock.builder();
        Map<String, S3ArnableFieldConfig> s3ArnableFields = model.getCustomizationConfig().getS3ArnableFields();
        if (s3ArnableFields != null && s3ArnableFields.containsKey(opModel.getInputShape().getShapeName())) {
            String arnVariableName;
            String variableName;
            MemberModel memberModel;
            S3ArnableFieldConfig s3ArnableField = s3ArnableFields.get(opModel.getInputShape().getShapeName());
            String fieldName = s3ArnableField.getField();
            MemberModel arnableMember = opModel.getInputShape().tryFindMemberModelByC2jName(fieldName, true);
            ClassName arnResourceFqcn = PoetUtils.classNameFromFqcn(s3ArnableField.getArnResourceFqcn());
            builder.addStatement("String $N = $N.$N()", new Object[]{fieldName, opModel.getInput().getVariableName(), arnableMember.getFluentGetterMethodName()});
            builder.addStatement("$T arn = null", new Object[]{Arn.class});
            builder.beginControlFlow("if ($N != null && $N.startsWith(\"arn:\"))", new Object[]{fieldName, fieldName}).addStatement("arn = $T.fromString($N)", new Object[]{Arn.class, fieldName}).addStatement("$T s3Resource = $T.getInstance().convertArn(arn)", new Object[]{PoetUtils.classNameFromFqcn(s3ArnableField.getBaseArnResourceFqcn()), PoetUtils.classNameFromFqcn(s3ArnableField.getArnConverterFqcn())}).beginControlFlow("if (!(s3Resource instanceof $T))", new Object[]{arnResourceFqcn}).addStatement("throw new $T(String.format(\"Unsupported ARN type: %s\", s3Resource.type()))", new Object[]{IllegalArgumentException.class}).endControlFlow().addStatement("$T resource = ($T) s3Resource", new Object[]{arnResourceFqcn, arnResourceFqcn});
            Map<String, String> otherFieldsToPopulate = s3ArnableField.getOtherFieldsToPopulate();
            for (Map.Entry<String, String> entry : otherFieldsToPopulate.entrySet()) {
                memberModel = opModel.getInputShape().tryFindMemberModelByC2jName(entry.getKey(), true);
                variableName = memberModel.getVariable().getVariableName();
                arnVariableName = variableName + "InArn";
                builder.addStatement("String $N = $N.$N()", new Object[]{variableName, opModel.getInput().getVariableName(), memberModel.getFluentGetterMethodName()});
                builder.addStatement("String $N = resource.$N", new Object[]{arnVariableName, entry.getValue()});
                builder.beginControlFlow("if ($N != null && !$N.equals($N))", new Object[]{variableName, variableName, arnVariableName}).addStatement("throw new $T(String.format(\"%s field provided from the request (%s) is different from the one in the ARN (%s)\", $S, $N, $N))", new Object[]{IllegalArgumentException.class, variableName, variableName, arnVariableName}).endControlFlow();
            }
            builder.add("$N = $N.toBuilder().$N(resource.$N())", new Object[]{opModel.getInput().getVariableName(), opModel.getInput().getVariableName(), arnableMember.getFluentSetterMethodName(), s3ArnableField.getArnResourceSubstitutionGetter()});
            for (Map.Entry<String, String> entry : otherFieldsToPopulate.entrySet()) {
                memberModel = opModel.getInputShape().tryFindMemberModelByC2jName(entry.getKey(), true);
                variableName = memberModel.getVariable().getVariableName();
                arnVariableName = variableName + "InArn";
                builder.add(".$N($N)", new Object[]{memberModel.getFluentSetterMethodName(), arnVariableName});
            }
            return Optional.of(builder.addStatement(".build()", new Object[0]).endControlFlow().build());
        }
        return Optional.empty();
    }

    private static String inputShapeMemberGetter(OperationModel opModel, String c2jName) {
        return opModel.getInput().getVariableName() + "." + opModel.getInputShape().getMemberByC2jName(c2jName).getFluentGetterMethodName() + "()";
    }

    public static MethodSpec updateRetryStrategyClientConfigurationMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"updateRetryStrategyClientConfiguration").addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(SdkClientConfiguration.Builder.class, "configuration", new Modifier[0]);
        builder.addStatement("$T builder = configuration.asOverrideConfigurationBuilder()", new Object[]{ClientOverrideConfiguration.Builder.class});
        builder.addStatement("$T retryMode = builder.retryMode()", new Object[]{RetryMode.class});
        builder.beginControlFlow("if (retryMode != null)", new Object[0]).addStatement("configuration.option($T.RETRY_STRATEGY, $T.forRetryMode(retryMode))", new Object[]{SdkClientOption.class, AwsRetryStrategy.class});
        builder.nextControlFlow("else", new Object[0]);
        builder.addStatement("$T<$T<?, ?>> configurator = builder.retryStrategyConfigurator()", new Object[]{Consumer.class, RetryStrategy.Builder.class});
        builder.beginControlFlow("if (configurator != null)", new Object[0]).addStatement("$T<?, ?>  defaultBuilder = $T.defaultRetryStrategy().toBuilder()", new Object[]{RetryStrategy.Builder.class, AwsRetryStrategy.class}).addStatement("configurator.accept(defaultBuilder)", new Object[0]).addStatement("configuration.option($T.RETRY_STRATEGY, defaultBuilder.build())", new Object[]{SdkClientOption.class});
        builder.nextControlFlow("else", new Object[0]);
        builder.addStatement("$T retryStrategy = builder.retryStrategy()", new Object[]{RetryStrategy.class});
        builder.beginControlFlow("if (retryStrategy != null)", new Object[0]).addStatement("configuration.option($T.RETRY_STRATEGY, retryStrategy)", new Object[]{SdkClientOption.class}).endControlFlow();
        builder.endControlFlow();
        builder.endControlFlow();
        builder.addStatement("configuration.option($T.CONFIGURED_RETRY_MODE, null)", new Object[]{SdkClientOption.class});
        builder.addStatement("configuration.option($T.CONFIGURED_RETRY_STRATEGY, null)", new Object[]{SdkClientOption.class});
        builder.addStatement("configuration.option($T.CONFIGURED_RETRY_CONFIGURATOR, null)", new Object[]{SdkClientOption.class});
        return builder.build();
    }
}

