/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.PoetGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.model.service.PaginatorDefinition;
import software.amazon.awssdk.codegen.poet.paginators.AsyncResponseClassSpec;
import software.amazon.awssdk.codegen.poet.paginators.SyncResponseClassSpec;
import software.amazon.awssdk.codegen.poet.paginators.customizations.SameTokenAsyncResponseClassSpec;
import software.amazon.awssdk.codegen.poet.paginators.customizations.SameTokenSyncResponseClassSpec;
import software.amazon.awssdk.utils.FunctionalUtils;

public class PaginatorsGeneratorTasks
extends BaseGeneratorTasks {
    private static final String SAME_TOKEN_CUSTOMIZATION = "LastPageHasPreviousToken";
    private final String paginatorsClassDir;
    private final Map<String, String> customization;

    public PaginatorsGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.paginatorsClassDir = dependencies.getPathProvider().getPaginatorsDirectory();
        this.customization = dependencies.getModel().getCustomizationConfig().getPaginationCustomization();
    }

    @Override
    protected boolean hasTasks() {
        return this.model.hasPaginators();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        return this.model.getPaginators().entrySet().stream().filter(entry -> ((PaginatorDefinition)entry.getValue()).isValid()).flatMap(FunctionalUtils.safeFunction(this::createSyncAndAsyncTasks)).collect(Collectors.toList());
    }

    private Stream<GeneratorTask> createSyncAndAsyncTasks(Map.Entry<String, PaginatorDefinition> entry) throws IOException {
        if (!this.shouldGenerateSyncPaginators()) {
            return Stream.of(this.createAsyncTask(entry));
        }
        return Stream.of(this.createSyncTask(entry), this.createAsyncTask(entry));
    }

    private GeneratorTask createSyncTask(Map.Entry<String, PaginatorDefinition> entry) {
        SyncResponseClassSpec classSpec = new SyncResponseClassSpec(this.model, entry.getKey(), entry.getValue());
        if (this.customization != null && this.customization.containsKey(entry.getKey()) && SAME_TOKEN_CUSTOMIZATION.equals(this.customization.get(entry.getKey()))) {
            classSpec = new SameTokenSyncResponseClassSpec(this.model, entry.getKey(), entry.getValue());
        }
        return new PoetGeneratorTask(this.paginatorsClassDir, this.model.getFileHeader(), classSpec);
    }

    private GeneratorTask createAsyncTask(Map.Entry<String, PaginatorDefinition> entry) {
        AsyncResponseClassSpec classSpec = new AsyncResponseClassSpec(this.model, entry.getKey(), entry.getValue());
        if (this.customization != null && this.customization.containsKey(entry.getKey()) && SAME_TOKEN_CUSTOMIZATION.equals(this.customization.get(entry.getKey()))) {
            classSpec = new SameTokenAsyncResponseClassSpec(this.model, entry.getKey(), entry.getValue());
        }
        return new PoetGeneratorTask(this.paginatorsClassDir, this.model.getFileHeader(), classSpec);
    }

    private boolean shouldGenerateSyncPaginators() {
        return !this.model.getCustomizationConfig().isSkipSyncClientGeneration();
    }
}

