/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.List;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.poet.rules2.BooleanNotExpression;
import software.amazon.awssdk.codegen.poet.rules2.FunctionCallExpression;
import software.amazon.awssdk.codegen.poet.rules2.IndexedAccessExpression;
import software.amazon.awssdk.codegen.poet.rules2.LetExpression;
import software.amazon.awssdk.codegen.poet.rules2.LiteralBooleanExpression;
import software.amazon.awssdk.codegen.poet.rules2.LiteralIntegerExpression;
import software.amazon.awssdk.codegen.poet.rules2.MemberAccessExpression;
import software.amazon.awssdk.codegen.poet.rules2.MethodCallExpression;
import software.amazon.awssdk.codegen.poet.rules2.RewriteRuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.codegen.poet.rules2.SymbolTable;
import software.amazon.awssdk.codegen.poet.rules2.VariableReferenceExpression;
import software.amazon.awssdk.utils.internal.CodegenNamingUtils;

public final class PrepareForCodegenVisitor
extends RewriteRuleExpressionVisitor {
    private final SymbolTable symbolTable;
    private final SymbolTable.Builder renames;

    public PrepareForCodegenVisitor(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        this.renames = SymbolTable.builder();
    }

    public SymbolTable symbolTable() {
        String regionParamName = this.symbolTable.regionParamName();
        if (regionParamName != null) {
            this.renames.regionParamName(this.javaName(regionParamName));
        }
        return this.renames.build();
    }

    @Override
    public RuleExpression visitBooleanNotExpression(BooleanNotExpression e) {
        FunctionCallExpression functionCall;
        RuleExpression arg = (e = (BooleanNotExpression)super.visitBooleanNotExpression(e)).expression();
        if (arg instanceof FunctionCallExpression && "isSet".equals((functionCall = (FunctionCallExpression)arg).name())) {
            return functionCall.toBuilder().name("isNotSet").build();
        }
        return e;
    }

    @Override
    public RuleExpression visitFunctionCallExpression(FunctionCallExpression e) {
        String fn;
        e = (FunctionCallExpression)super.visitFunctionCallExpression(e);
        switch (fn = e.name()) {
            case "booleanEquals": {
                return this.simplifyBooleanEquals(e);
            }
            case "stringEquals": {
                return this.simplifyStringEquals(e);
            }
            case "not": {
                return this.simplifyNotExpression(e);
            }
        }
        return e;
    }

    @Override
    public RuleExpression visitVariableReferenceExpression(VariableReferenceExpression e) {
        String name = e.variableName();
        if (this.symbolTable.isLocal(name)) {
            RuleType type = this.symbolTable.localType(name);
            String newName = this.javaName(name);
            this.renames.putLocal(newName, type);
            return MemberAccessExpression.builder().type(e.type()).source(VariableReferenceExpression.builder().variableName("locals").build()).name(newName).build();
        }
        if (this.symbolTable.isParam(name)) {
            RuleType type = this.symbolTable.paramType(name);
            String newName = this.javaName(name);
            this.renames.putParam(newName, type);
            return MemberAccessExpression.builder().type(e.type()).source(VariableReferenceExpression.builder().variableName("params").build()).name(newName).build();
        }
        return e;
    }

    @Override
    public RuleExpression visitIndexedAccessExpression(IndexedAccessExpression e) {
        e = (IndexedAccessExpression)super.visitIndexedAccessExpression(e);
        return FunctionCallExpression.builder().name("listAccess").type(e.type()).addArgument(e.source()).addArgument(new LiteralIntegerExpression(e.index())).build();
    }

    @Override
    public RuleExpression visitLetExpression(LetExpression e) {
        LetExpression.Builder builder = LetExpression.builder();
        e.bindings().forEach((k, v) -> {
            String newName = this.javaName((String)k);
            RuleExpression value = v.accept(this);
            builder.putBinding(newName, value);
            this.renames.putLocal(newName, value.type());
        });
        return builder.build();
    }

    private RuleExpression simplifyBooleanEquals(FunctionCallExpression e) {
        List<RuleExpression> args = e.arguments();
        RuleExpression left = args.get(0).accept(this);
        RuleExpression right = args.get(1).accept(this);
        if (left.kind() == RuleExpression.RuleExpressionKind.BOOLEAN_VALUE) {
            LiteralBooleanExpression leftAsBoolean = (LiteralBooleanExpression)left;
            if (leftAsBoolean.value()) {
                return right;
            }
            return BooleanNotExpression.builder().expression(right).build();
        }
        if (right.kind() == RuleExpression.RuleExpressionKind.BOOLEAN_VALUE) {
            LiteralBooleanExpression rightAsBoolean = (LiteralBooleanExpression)right;
            if (rightAsBoolean.value()) {
                return left;
            }
            return BooleanNotExpression.builder().expression(left).build();
        }
        return MethodCallExpression.builder().name("equals").source(left).addArgument(right).build();
    }

    private RuleExpression simplifyStringEquals(FunctionCallExpression e) {
        List<RuleExpression> args = e.arguments();
        RuleExpression left = args.get(0).accept(this);
        RuleExpression right = args.get(1).accept(this);
        if (right.kind() == RuleExpression.RuleExpressionKind.STRING_VALUE) {
            return MethodCallExpression.builder().name("equals").source(right).addArgument(left).build();
        }
        if (left.kind() == RuleExpression.RuleExpressionKind.STRING_VALUE) {
            return MethodCallExpression.builder().name("equals").source(left).addArgument(right).build();
        }
        return e;
    }

    private RuleExpression simplifyNotExpression(FunctionCallExpression e) {
        FunctionCallExpression inner;
        RuleExpression arg = e.arguments().get(0);
        if (arg instanceof FunctionCallExpression && "isSet".equals((inner = (FunctionCallExpression)arg).name())) {
            return inner.toBuilder().name("isNotSet").build();
        }
        return e;
    }

    private String javaName(String name) {
        return Utils.unCapitalize(CodegenNamingUtils.pascalCase((String)name));
    }
}

