/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.builder;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.codegen.model.config.customization.MultipartCustomization;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

public class AsyncClientBuilderInterface
implements ClassSpec {
    private static final Logger log = Logger.loggerFor(AsyncClientBuilderInterface.class);
    private final ClassName builderInterfaceName;
    private final ClassName clientInterfaceName;
    private final ClassName baseBuilderInterfaceName;
    private final IntermediateModel model;

    public AsyncClientBuilderInterface(IntermediateModel model) {
        String basePackage = model.getMetadata().getFullClientPackageName();
        this.clientInterfaceName = ClassName.get((String)basePackage, (String)model.getMetadata().getAsyncInterface(), (String[])new String[0]);
        this.builderInterfaceName = ClassName.get((String)basePackage, (String)model.getMetadata().getAsyncBuilderInterface(), (String[])new String[0]);
        this.baseBuilderInterfaceName = ClassName.get((String)basePackage, (String)model.getMetadata().getBaseBuilderInterface(), (String[])new String[0]);
        this.model = model;
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createInterfaceBuilder(this.builderInterfaceName).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(AwsAsyncClientBuilder.class), (TypeName[])new TypeName[]{this.builderInterfaceName, this.clientInterfaceName})).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)this.baseBuilderInterfaceName, (TypeName[])new TypeName[]{this.builderInterfaceName, this.clientInterfaceName})).addJavadoc(this.getJavadoc());
        MultipartCustomization multipartCustomization = this.model.getCustomizationConfig().getMultipartCustomization();
        if (multipartCustomization != null) {
            this.includeMultipartMethod(builder, multipartCustomization);
        }
        return builder.build();
    }

    private void includeMultipartMethod(TypeSpec.Builder builder, MultipartCustomization multipartCustomization) {
        log.debug(() -> String.format("Adding multipart config methods to builder interface for service '%s'", this.model.getMetadata().getServiceId()));
        builder.addMethod(MethodSpec.methodBuilder((String)"multipartEnabled").addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).returns((TypeName)this.builderInterfaceName).addParameter(Boolean.class, "enabled", new Modifier[0]).addCode("throw new $T();", new Object[]{UnsupportedOperationException.class}).addJavadoc(CodeBlock.of((String)multipartCustomization.getMultipartEnableMethodDoc(), (Object[])new Object[0])).build());
        String multiPartConfigMethodName = "multipartConfiguration";
        String multipartConfigClass = (String)Validate.notNull((Object)multipartCustomization.getMultipartConfigurationClass(), (String)"'multipartConfigurationClass' must be defined", (Object[])new Object[0]);
        ClassName mulitpartConfigClassName = PoetUtils.classNameFromFqcn(multipartConfigClass);
        builder.addMethod(MethodSpec.methodBuilder((String)multiPartConfigMethodName).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).returns((TypeName)this.builderInterfaceName).addParameter(ParameterSpec.builder((TypeName)mulitpartConfigClassName, (String)"multipartConfiguration", (Modifier[])new Modifier[0]).build()).addCode("throw new $T();", new Object[]{UnsupportedOperationException.class}).addJavadoc(CodeBlock.of((String)multipartCustomization.getMultipartConfigMethodDoc(), (Object[])new Object[0])).build());
        ClassName mulitpartConfigBuilderClassName = PoetUtils.classNameFromFqcn(multipartConfigClass + ".Builder");
        ParameterizedTypeName consumerBuilderType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{mulitpartConfigBuilderClassName});
        builder.addMethod(MethodSpec.methodBuilder((String)multiPartConfigMethodName).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).returns((TypeName)this.builderInterfaceName).addParameter(ParameterSpec.builder((TypeName)consumerBuilderType, (String)"multipartConfiguration", (Modifier[])new Modifier[0]).build()).addStatement("$T builder = $T.builder()", new Object[]{mulitpartConfigBuilderClassName, mulitpartConfigClassName}).addStatement("multipartConfiguration.accept(builder)", new Object[0]).addStatement("return multipartConfiguration(builder.build())", new Object[0]).addJavadoc(CodeBlock.of((String)multipartCustomization.getMultipartConfigMethodDoc(), (Object[])new Object[0])).build());
    }

    @Override
    public ClassName className() {
        return this.builderInterfaceName;
    }

    private CodeBlock getJavadoc() {
        return CodeBlock.of((String)"A builder for creating an instance of {@link $1T}. This can be created with the static {@link $1T#builder()} method.", (Object[])new Object[]{this.clientInterfaceName});
    }
}

