/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeCodegenKnowledgeIndex;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeCodegenMetadata;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeCodegenMetadataExt;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;

public class ModelBasedAuthSchemeProviderSpec
implements ClassSpec {
    private final AuthSchemeSpecUtils authSchemeSpecUtils;
    private final AuthSchemeCodegenKnowledgeIndex knowledgeIndex;

    public ModelBasedAuthSchemeProviderSpec(IntermediateModel intermediateModel) {
        this.authSchemeSpecUtils = new AuthSchemeSpecUtils(intermediateModel);
        this.knowledgeIndex = AuthSchemeCodegenKnowledgeIndex.of(intermediateModel);
    }

    @Override
    public ClassName className() {
        if (this.authSchemeSpecUtils.useEndpointBasedAuthProvider()) {
            return this.authSchemeSpecUtils.modeledAuthSchemeProviderName();
        }
        return this.authSchemeSpecUtils.defaultAuthSchemeProviderName();
    }

    @Override
    public TypeSpec poetSpec() {
        return PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(SdkInternalApi.class).addSuperinterface((TypeName)this.authSchemeSpecUtils.providerInterfaceName()).addMethod(this.constructor()).addField(this.defaultInstance()).addMethod(this.createMethod()).addMethod(this.resolveAuthSchemeMethod()).build();
    }

    private FieldSpec defaultInstance() {
        return FieldSpec.builder((TypeName)this.className(), (String)"DEFAULT", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{this.className()}).build();
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    private MethodSpec createMethod() {
        return MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.className()).addStatement("return DEFAULT", new Object[0]).build();
    }

    private MethodSpec resolveAuthSchemeMethod() {
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)"resolveAuthScheme").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(this.authSchemeSpecUtils.resolverReturnType()).addParameter((TypeName)this.authSchemeSpecUtils.parametersInterfaceName(), "params", new Modifier[0]);
        spec.addStatement("$T options = new $T<>()", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{AuthSchemeOption.class}), TypeName.get(ArrayList.class)});
        if (this.knowledgeIndex.hasPerOperationAuthSchemesOverrides()) {
            spec.beginControlFlow("switch(params.operation())", new Object[0]);
            this.knowledgeIndex.forEachOperationsOverridesGroup((ops, schemes) -> this.addCasesForOperations(spec, (List<String>)ops, (List<AuthSchemeCodegenMetadata>)schemes));
            this.addCasesForOperations(spec, Collections.emptyList(), this.knowledgeIndex.serviceDefaultAuthSchemes());
            spec.endControlFlow();
        } else {
            List<AuthSchemeCodegenMetadata> types = this.knowledgeIndex.serviceDefaultAuthSchemes();
            for (AuthSchemeCodegenMetadata authType : types) {
                this.addAuthTypeProperties(spec, authType);
            }
        }
        return spec.addStatement("return $T.unmodifiableList(options)", new Object[]{Collections.class}).build();
    }

    private void addCasesForOperations(MethodSpec.Builder spec, List<String> operations, List<AuthSchemeCodegenMetadata> schemes) {
        if (operations.isEmpty()) {
            spec.addCode("default:\n", new Object[0]);
        } else {
            for (String name : operations) {
                spec.addCode("case $S\n:", new Object[]{name});
            }
        }
        for (AuthSchemeCodegenMetadata metadata : schemes) {
            this.addAuthTypeProperties(spec, metadata);
        }
        spec.addStatement("break", new Object[0]);
    }

    private void addAuthTypeProperties(MethodSpec.Builder spec, AuthSchemeCodegenMetadata metadata) {
        spec.addCode("options.add(", new Object[0]);
        spec.addCode(AuthSchemeCodegenMetadataExt.codegenNewAuthOption(metadata, this.authSchemeSpecUtils));
        spec.addCode(".build()", new Object[0]);
        spec.addCode(");\n", new Object[0]);
    }
}

