/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import com.squareup.javapoet.CodeBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeCodegenMetadata;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthTypeToSigV4Default;
import software.amazon.awssdk.codegen.poet.auth.scheme.SigV4SignerDefaults;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4AuthScheme;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.scheme.BearerAuthScheme;
import software.amazon.awssdk.http.auth.scheme.NoAuthAuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;

public final class AuthSchemeCodegenMetadataExt {
    static final AuthSchemeCodegenMetadata SIGV4 = AuthSchemeCodegenMetadata.builder().schemeId("aws.auth#sigv4").authSchemeClass(AwsV4AuthScheme.class).addProperty(AuthSchemeCodegenMetadata.SignerPropertyValueProvider.builder().containingClass(AwsV4HttpSigner.class).fieldName("SERVICE_SIGNING_NAME").valueEmitter((spec, utils) -> spec.add("$S", new Object[]{utils.signingName()})).build()).addProperty(AuthSchemeCodegenMetadata.SignerPropertyValueProvider.builder().containingClass(AwsV4HttpSigner.class).fieldName("REGION_NAME").valueEmitter((spec, utils) -> spec.add("$L", new Object[]{"params.region().id()"})).build()).build();
    static final AuthSchemeCodegenMetadata BEARER = AuthSchemeCodegenMetadata.builder().schemeId("smithy.api#httpBearerAuth").authSchemeClass(BearerAuthScheme.class).build();
    static final AuthSchemeCodegenMetadata NO_AUTH = AuthSchemeCodegenMetadata.builder().schemeId("smithy.api#noAuth").authSchemeClass(NoAuthAuthScheme.class).build();

    private AuthSchemeCodegenMetadataExt() {
    }

    public static AuthSchemeCodegenMetadata fromAuthType(AuthType type) {
        switch (type) {
            case BEARER: {
                return BEARER;
            }
            case NONE: {
                return NO_AUTH;
            }
        }
        String authTypeName = type.value();
        SigV4SignerDefaults defaults = AuthTypeToSigV4Default.authTypeToDefaults().get(authTypeName);
        if (defaults == null) {
            throw new IllegalArgumentException("Unknown auth type: " + (Object)((Object)type));
        }
        return AuthSchemeCodegenMetadataExt.fromConstants(defaults);
    }

    public static AuthSchemeCodegenMetadata fromConstants(SigV4SignerDefaults constants) {
        AuthSchemeCodegenMetadata.Builder builder = SIGV4.toBuilder();
        for (AuthSchemeCodegenMetadata.SignerPropertyValueProvider property : AuthSchemeCodegenMetadataExt.propertiesFromConstants(constants)) {
            builder.addProperty(property);
        }
        return builder.build();
    }

    public static CodeBlock codegenNewAuthOption(AuthSchemeCodegenMetadata metadata, AuthSchemeSpecUtils authSchemeSpecUtils) {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add("$T.builder().schemeId($S)", new Object[]{AuthSchemeOption.class, metadata.schemeId()});
        builder.add(AuthSchemeCodegenMetadataExt.codegenSignerProperties(authSchemeSpecUtils, metadata.properties()));
        return builder.build();
    }

    public static CodeBlock codegenSignerProperties(AuthSchemeSpecUtils authSchemeSpecUtils, List<AuthSchemeCodegenMetadata.SignerPropertyValueProvider> properties) {
        CodeBlock.Builder builder = CodeBlock.builder();
        for (AuthSchemeCodegenMetadata.SignerPropertyValueProvider property : properties) {
            builder.add("\n.putSignerProperty($T.$N, ", new Object[]{property.containingClass(), property.fieldName()});
            property.emitValue(builder, authSchemeSpecUtils);
            builder.add(")", new Object[0]);
        }
        return builder.build();
    }

    public static CodeBlock codegenSignerPropertiesIfAbsent(AuthSchemeSpecUtils authSchemeSpecUtils, List<AuthSchemeCodegenMetadata.SignerPropertyValueProvider> properties) {
        CodeBlock.Builder builder = CodeBlock.builder();
        for (AuthSchemeCodegenMetadata.SignerPropertyValueProvider property : properties) {
            builder.add("\n.putSignerPropertyIfAbsent($T.$N, ", new Object[]{property.containingClass(), property.fieldName()});
            property.emitValue(builder, authSchemeSpecUtils);
            builder.add(")", new Object[0]);
        }
        return builder.build();
    }

    private static List<AuthSchemeCodegenMetadata.SignerPropertyValueProvider> propertiesFromConstants(SigV4SignerDefaults constants) {
        ArrayList<AuthSchemeCodegenMetadata.SignerPropertyValueProvider> properties = new ArrayList<AuthSchemeCodegenMetadata.SignerPropertyValueProvider>();
        if (constants.payloadSigningEnabled() != null) {
            properties.add(AuthSchemeCodegenMetadataExt.from("PAYLOAD_SIGNING_ENABLED", constants::payloadSigningEnabled));
        }
        if (constants.doubleUrlEncode() != null) {
            properties.add(AuthSchemeCodegenMetadataExt.from("DOUBLE_URL_ENCODE", constants::doubleUrlEncode));
        }
        if (constants.normalizePath() != null) {
            properties.add(AuthSchemeCodegenMetadataExt.from("NORMALIZE_PATH", constants::normalizePath));
        }
        if (constants.chunkEncodingEnabled() != null) {
            properties.add(AuthSchemeCodegenMetadataExt.from("CHUNK_ENCODING_ENABLED", constants::chunkEncodingEnabled));
        }
        return properties;
    }

    private static AuthSchemeCodegenMetadata.SignerPropertyValueProvider from(String name, Supplier<Object> valueSupplier) {
        return AuthSchemeCodegenMetadata.SignerPropertyValueProvider.builder().containingClass(AwsV4HttpSigner.class).fieldName(name).constantValueSupplier(valueSupplier).build();
    }
}

