/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.naming.NamingStrategy;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.eventstream.EventTypeEnumSpec;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.internal.CodegenNamingUtils;

public final class EventStreamSpecHelper {
    private final ShapeModel eventStream;
    private final IntermediateModel intermediateModel;
    private final PoetExtension poetExtensions;

    public EventStreamSpecHelper(ShapeModel eventStream, IntermediateModel intermediateModel) {
        this.eventStream = eventStream;
        this.intermediateModel = intermediateModel;
        this.poetExtensions = new PoetExtension(intermediateModel);
    }

    public String visitMethodName(MemberModel event) {
        if (this.useLegacyGenerationScheme(event)) {
            return "visit";
        }
        return "visit" + CodegenNamingUtils.pascalCase((String)event.getName());
    }

    public String eventPackageName() {
        return this.intermediateModel.getMetadata().getFullModelPackageName() + "." + this.eventStream.getShapeName().toLowerCase(Locale.ENGLISH);
    }

    public boolean useLegacyGenerationScheme(MemberModel event) {
        Map<String, List<String>> useLegacyEventGenerationScheme = this.intermediateModel.getCustomizationConfig().getUseLegacyEventGenerationScheme();
        List<String> targetEvents = useLegacyEventGenerationScheme.get(this.eventStream.getC2jName());
        if (targetEvents == null) {
            return false;
        }
        return targetEvents.stream().anyMatch(e -> e.equals(event.getC2jName()));
    }

    public ClassName eventClassName(MemberModel eventModel) {
        if (this.useLegacyGenerationScheme(eventModel)) {
            return this.poetExtensions.getModelClass(eventModel.getShape().getShapeName());
        }
        String simpleName = "Default" + this.intermediateModel.getNamingStrategy().getShapeClassName(eventModel.getName());
        return ClassName.get((String)this.eventPackageName(), (String)simpleName, (String[])new String[0]);
    }

    public ClassName eventTypeEnumClassName() {
        return this.poetExtensions.getModelClass(this.eventStream.getShapeName()).nestedClass("EventType");
    }

    public TypeSpec eventTypeEnumSpec() {
        return new EventTypeEnumSpec("", this.intermediateModel, this.eventStream).poetSpec().toBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
    }

    public String eventTypeEnumValue(MemberModel eventModel) {
        NamingStrategy namingStrategy = this.intermediateModel.getNamingStrategy();
        return namingStrategy.getEnumValueName(eventModel.getName());
    }

    public String eventBuilderMethodName(MemberModel eventModel) {
        return String.format("%sBuilder", StringUtils.uncapitalize((String)eventModel.getName()));
    }

    public String eventConsumerName(MemberModel eventModel) {
        if (this.useLegacyGenerationScheme(eventModel)) {
            return "on" + eventModel.getShape().getShapeName();
        }
        return "on" + eventModel.getName();
    }
}

