/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.customization.processors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.service.Operation;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.utils.StringUtils;

public class S3RemoveBucketFromUriProcessor
implements CodegenCustomizationProcessor {
    private static final Logger log = LoggerFactory.getLogger(S3RemoveBucketFromUriProcessor.class);

    @Override
    public void preprocess(ServiceModel serviceModel) {
        if (!this.isS3(serviceModel)) {
            return;
        }
        log.info("Preprocessing S3 model to remove {Bucket} from request URIs");
        serviceModel.getOperations().forEach(this::removeBucketFromUriIfNecessary);
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
    }

    private boolean isS3(ServiceModel serviceModel) {
        return "S3".equals(serviceModel.getMetadata().getServiceId());
    }

    private void removeBucketFromUriIfNecessary(String opName, Operation operation) {
        String requestUri = operation.getHttp().getRequestUri();
        String newUri = StringUtils.replaceOnce((String)requestUri, (String)"/{Bucket}", (String)"");
        log.info("{}: replacing existing request URI '{}' with '{}", new Object[]{opName, requestUri, newUri});
        operation.getHttp().setRequestUri(newUri);
    }
}

