/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Lazy;
import software.amazon.awssdk.utils.Validate;

public class DefaultPartitionDataProviderSpec
implements ClassSpec {
    private final IntermediateModel model;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;
    private final ClassName partitionsClass;

    public DefaultPartitionDataProviderSpec(IntermediateModel model) {
        this.model = model;
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(model);
        this.partitionsClass = this.endpointRulesSpecUtils.rulesRuntimeClassName("Partitions");
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(SdkInternalApi.class).addSuperinterface((TypeName)this.endpointRulesSpecUtils.rulesRuntimeClassName("PartitionDataProvider"));
        builder.addField(this.partitionDataField());
        builder.addField(this.partitionsLazyField());
        builder.addMethod(this.loadPartitionsMethod());
        builder.addMethod(this.doLoadPartitionsMethod());
        return builder.build();
    }

    @Override
    public ClassName className() {
        return this.endpointRulesSpecUtils.rulesRuntimeClassName("DefaultPartitionDataProvider");
    }

    private MethodSpec loadPartitionsMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"loadPartitions").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.partitionsClass);
        builder.addStatement("return PARTITIONS.getValue()", new Object[0]);
        return builder.build();
    }

    private FieldSpec partitionDataField() {
        FieldSpec.Builder builder = FieldSpec.builder(String.class, (String)"DEFAULT_PARTITION_DATA", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
        builder.initializer("$S", new Object[]{this.readPartitionsJson()});
        return builder.build();
    }

    private FieldSpec partitionsLazyField() {
        ParameterizedTypeName lazyType = ParameterizedTypeName.get((ClassName)ClassName.get(Lazy.class), (TypeName[])new TypeName[]{this.partitionsClass});
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)lazyType, (String)"PARTITIONS", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
        CodeBlock init = CodeBlock.builder().addStatement("new $T<>($T::doLoadPartitions)", new Object[]{Lazy.class, this.className()}).build();
        builder.initializer(init);
        return builder.build();
    }

    private MethodSpec doLoadPartitionsMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"doLoadPartitions").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns((TypeName)this.partitionsClass);
        builder.addStatement("return $T.fromNode($T.parser().parse(DEFAULT_PARTITION_DATA))", new Object[]{this.partitionsClass, JsonNode.class});
        return builder.build();
    }

    private String readPartitionsJson() {
        String jsonPath = this.endpointRulesSpecUtils.rulesEngineResourceFiles().stream().filter(e -> e.endsWith("partitions.json.resource")).findFirst().orElseThrow(() -> new RuntimeException("Could not find partitions.json.resource"));
        return this.loadResourceAsString("/" + jsonPath);
    }

    private String loadResourceAsString(String path) {
        try {
            return IoUtils.toUtf8String((InputStream)this.loadResource(path));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private InputStream loadResource(String name) {
        InputStream resourceAsStream = DefaultPartitionDataProviderSpec.class.getResourceAsStream(name);
        Validate.notNull((Object)resourceAsStream, (String)"Failed to load resource from %s", (Object[])new Object[]{name});
        return resourceAsStream;
    }
}

