/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.docs;

import software.amazon.awssdk.codegen.docs.DocConfiguration;
import software.amazon.awssdk.codegen.docs.DocumentationBuilder;
import software.amazon.awssdk.codegen.docs.OperationDocProvider;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.utils.PaginatorUtils;
import software.amazon.awssdk.core.sync.ResponseTransformer;

class SyncOperationDocProvider
extends OperationDocProvider {
    private static final String DEFAULT_RETURN = "Result of the %s operation returned by the service.";
    private static final String REQUEST_BODY_DOCS = "The content to send to the service. A {@link RequestBody} can be created using one of several factory methods for various sources of data. For example, to create a request body from a file you can do the following. <pre>{@code RequestBody.fromFile(new File(\"myfile.txt\"))}</pre>See documentation in {@link RequestBody} for additional details and which sources of data are supported. ";
    private static final String STREAM_RESPONSE_HANDLER_DOCS = "Functional interface for processing the streamed response content. The unmarshalled %s and an InputStream to the response content are provided as parameters to the callback. The callback may return a transformed type which will be the return value of this method. See {@link " + ResponseTransformer.class.getName() + "} for details on implementing this interface and for links to pre-canned implementations for common scenarios like downloading to a file. ";

    SyncOperationDocProvider(IntermediateModel model, OperationModel opModel, DocConfiguration configuration) {
        super(model, opModel, configuration);
    }

    @Override
    protected String getDefaultServiceDocs() {
        return String.format("Invokes the %s operation.", this.opModel.getOperationName());
    }

    @Override
    protected String getInterfaceName() {
        return this.model.getMetadata().getSyncInterface();
    }

    @Override
    protected void applyReturns(DocumentationBuilder docBuilder) {
        if (this.opModel.hasStreamingOutput()) {
            docBuilder.returns("The transformed result of the ResponseTransformer.");
        } else {
            docBuilder.returns(DEFAULT_RETURN, this.opModel.getOperationName());
        }
    }

    @Override
    protected void applyParams(DocumentationBuilder docBuilder) {
        this.emitRequestParm(docBuilder);
        if (this.opModel.hasStreamingInput()) {
            docBuilder.param("requestBody", REQUEST_BODY_DOCS + this.getStreamingInputDocs());
        }
        if (this.opModel.hasStreamingOutput()) {
            docBuilder.param("responseTransformer", STREAM_RESPONSE_HANDLER_DOCS + this.getStreamingOutputDocs(), this.opModel.getOutputShape().getShapeName(), this.getStreamingOutputDocs());
        }
    }

    @Override
    protected void applyThrows(DocumentationBuilder docBuilder) {
        docBuilder.syncThrows(this.getThrows());
    }

    static class SyncPaginatedNoArg
    extends SyncPaginated {
        SyncPaginatedNoArg(IntermediateModel model, OperationModel opModel, DocConfiguration configuration) {
            super(model, opModel, configuration);
        }

        @Override
        protected void applyParams(DocumentationBuilder docBuilder) {
            docBuilder.see("#%s(%s)", PaginatorUtils.getPaginatedMethodName(this.opModel.getMethodName()), this.opModel.getInput().getVariableType());
        }
    }

    static class SyncPaginated
    extends SyncOperationDocProvider {
        SyncPaginated(IntermediateModel model, OperationModel opModel, DocConfiguration configuration) {
            super(model, opModel, configuration);
        }

        @Override
        protected String appendToDescription() {
            return this.paginationDocs.getDocsForSyncOperation();
        }

        @Override
        protected void applyReturns(DocumentationBuilder docBuilder) {
            docBuilder.returns("A custom iterable that can be used to iterate through all the response pages.");
        }
    }

    static class SyncNoArg
    extends SyncOperationDocProvider {
        SyncNoArg(IntermediateModel model, OperationModel opModel, DocConfiguration configuration) {
            super(model, opModel, configuration);
        }

        @Override
        protected void applyParams(DocumentationBuilder docBuilder) {
            docBuilder.see("#%s(%s)", this.opModel.getMethodName(), this.opModel.getInput().getVariableType());
        }
    }

    static class SyncBytes
    extends SyncOperationDocProvider {
        SyncBytes(IntermediateModel model, OperationModel opModel, DocConfiguration configuration) {
            super(model, opModel, configuration);
        }

        @Override
        protected void applyReturns(DocumentationBuilder docBuilder) {
            docBuilder.returns("A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in convenient in-memory representations like a byte buffer or string. The unmarshalled response object can be obtained via {@link ResponseBytes#response()}. " + this.getStreamingOutputDocs());
            docBuilder.see("#getObject(%s, ResponseTransformer)", this.opModel.getMethodName(), this.opModel.getInput().getVariableType());
        }

        @Override
        protected void applyParams(DocumentationBuilder docBuilder) {
            this.emitRequestParm(docBuilder);
        }
    }

    static class SyncInputStream
    extends SyncOperationDocProvider {
        SyncInputStream(IntermediateModel model, OperationModel opModel, DocConfiguration configuration) {
            super(model, opModel, configuration);
        }

        @Override
        protected void applyReturns(DocumentationBuilder docBuilder) {
            docBuilder.returns("A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior and exhausting connections in the connection pool. The unmarshalled response object can be obtained via {@link ResponseInputStream#response()}. " + this.getStreamingOutputDocs());
            docBuilder.see("#getObject(%s, ResponseTransformer)", this.opModel.getMethodName(), this.opModel.getInput().getVariableType());
        }

        @Override
        protected void applyParams(DocumentationBuilder docBuilder) {
            this.emitRequestParm(docBuilder);
        }
    }

    static class SyncFile
    extends SyncOperationDocProvider {
        SyncFile(IntermediateModel model, OperationModel opModel, DocConfiguration configuration) {
            super(model, opModel, configuration);
        }

        @Override
        protected void applyParams(DocumentationBuilder docBuilder) {
            this.emitRequestParm(docBuilder);
            if (this.opModel.hasStreamingInput()) {
                docBuilder.param("sourcePath", "{@link Path} to file containing data to send to the service. File will be read entirely and may be read multiple times in the event of a retry. If the file does not exist or the current user does not have access to read it then an exception will be thrown. " + this.getStreamingInputDocs()).see("#%s(%s, RequestBody)", this.opModel.getMethodName(), this.opModel.getInput().getVariableType());
            }
            if (this.opModel.hasStreamingOutput()) {
                docBuilder.param("destinationPath", "{@link Path} to file that response contents will be written to. The file must not exist or this method will throw an exception. If the file is not writable by the current user then an exception will be thrown. " + this.getStreamingOutputDocs()).see("#%s(%s, ResponseTransformer)", this.opModel.getMethodName(), this.opModel.getInput().getVariableType());
            }
        }
    }
}

