/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.waiters;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.waiters.BaseWaiterInterfaceSpec;
import software.amazon.awssdk.core.waiters.WaiterResponse;

public final class WaiterInterfaceSpec
extends BaseWaiterInterfaceSpec {
    private final IntermediateModel model;
    private final PoetExtension poetExtensions;
    private final ClassName className;
    private final String modelPackage;

    public WaiterInterfaceSpec(IntermediateModel model) {
        super(model);
        this.modelPackage = model.getMetadata().getFullModelPackageName();
        this.model = model;
        this.poetExtensions = new PoetExtension(model);
        this.className = this.poetExtensions.getSyncWaiterInterface();
    }

    @Override
    protected ClassName waiterImplName() {
        return this.poetExtensions.getSyncWaiterClass();
    }

    @Override
    protected ClassName clientClassName() {
        return this.poetExtensions.getClientClass(this.model.getMetadata().getSyncInterface());
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    @Override
    protected ParameterizedTypeName getWaiterResponseType(OperationModel opModel) {
        ClassName pojoResponse = ClassName.get((String)this.modelPackage, (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
        return ParameterizedTypeName.get((ClassName)ClassName.get(WaiterResponse.class), (TypeName[])new TypeName[]{pojoResponse});
    }
}

