/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.WildcardTypeName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.model.service.XmlNamespace;
import software.amazon.awssdk.codegen.naming.NamingStrategy;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.XmlAttributeTrait;
import software.amazon.awssdk.core.traits.XmlAttributesTrait;
import software.amazon.awssdk.utils.Pair;

class ShapeModelSpec {
    private final ShapeModel shapeModel;
    private final TypeProvider typeProvider;
    private final PoetExtension poetExtensions;
    private final NamingStrategy namingStrategy;
    private final CustomizationConfig customizationConfig;
    private final IntermediateModel model;

    ShapeModelSpec(ShapeModel shapeModel, TypeProvider typeProvider, PoetExtension poetExtensions, IntermediateModel model) {
        this.shapeModel = shapeModel;
        this.typeProvider = typeProvider;
        this.poetExtensions = poetExtensions;
        this.namingStrategy = model.getNamingStrategy();
        this.customizationConfig = model.getCustomizationConfig();
        this.model = model;
    }

    ClassName className() {
        return this.poetExtensions.getModelClass(this.shapeModel.getShapeName());
    }

    public List<FieldSpec> fields() {
        return this.fields(Modifier.PRIVATE, Modifier.FINAL);
    }

    public List<FieldSpec> fields(Modifier ... modifiers) {
        return this.shapeModel.getNonStreamingMembers().stream().filter(m -> m.getShape() == null || m.getShape().getShapeType() != ShapeType.Exception).map(m -> this.typeProvider.asField((MemberModel)m, modifiers)).collect(Collectors.toList());
    }

    public Iterable<FieldSpec> staticFields(Modifier ... modifiers) {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        this.shapeModel.getNonStreamingMembers().stream().filter(m -> m.getShape() == null || m.getShape().getShapeType() != ShapeType.Exception).forEach(m -> {
            FieldSpec field = this.typeProvider.asField((MemberModel)m, modifiers);
            ClassName sdkFieldType = ClassName.get(SdkField.class);
            fields.add(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)sdkFieldType, (TypeName[])new TypeName[]{field.type}), (String)this.namingStrategy.getSdkFieldFieldName((MemberModel)m), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(this.sdkFieldInitializer((MemberModel)m)).build());
        });
        ParameterizedTypeName sdkFieldType = ParameterizedTypeName.get((ClassName)ClassName.get(SdkField.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)ClassName.get(Object.class))});
        fields.add(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{sdkFieldType}), (String)"SDK_FIELDS", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.unmodifiableList($T.asList($L))", new Object[]{ClassName.get(Collections.class), ClassName.get(Arrays.class), fields.stream().map(f -> f.name).collect(Collectors.joining(","))}).build());
        return fields;
    }

    private CodeBlock sdkFieldInitializer(MemberModel m) {
        ClassName sdkFieldType = ClassName.get(SdkField.class);
        return CodeBlock.builder().add("$T.<$T>builder($T.$L)\n", new Object[]{sdkFieldType, this.typeProvider.fieldType(m), ClassName.get(MarshallingType.class), m.getMarshallingType()}).add(".memberName($S)\n", new Object[]{m.getC2jName()}).add(".getter(getter($T::$L))\n", new Object[]{this.className(), m.getFluentGetterMethodName()}).add(".setter(setter($T::$L))\n", new Object[]{this.className().nestedClass("Builder"), m.getFluentSetterMethodName()}).add(this.constructor(m)).add(this.traits(m)).add(".build()", new Object[0]).build();
    }

    private CodeBlock containerSdkFieldInitializer(MemberModel m) {
        ClassName sdkFieldType = ClassName.get(SdkField.class);
        return CodeBlock.builder().add("$T.<$T>builder($T.$L)\n", new Object[]{sdkFieldType, this.typeProvider.fieldType(m), ClassName.get(MarshallingType.class), m.getMarshallingType()}).add(this.constructor(m)).add(this.traits(m)).add(".build()", new Object[0]).build();
    }

    private CodeBlock traits(MemberModel m) {
        String customDefaultValueSupplier;
        ArrayList<CodeBlock> traits = new ArrayList<CodeBlock>();
        traits.add(this.createLocationTrait(m));
        if (m.isList()) {
            traits.add(this.createListTrait(m));
        } else if (m.isMap()) {
            traits.add(this.createMapTrait(m));
        }
        if (m.getHttp().getIsPayload() || m.isEventPayload() || this.attachPayloadTraitToMember(m)) {
            traits.add(this.createPayloadTrait());
        }
        if (m.isJsonValue()) {
            traits.add(this.createJsonValueTrait());
        }
        if (m.isIdempotencyToken()) {
            traits.add(this.createIdempotencyTrait());
        }
        if ((customDefaultValueSupplier = this.customizationConfig.getModelMarshallerDefaultValueSupplier().get(m.getC2jName())) != null) {
            traits.add(this.createDefaultValueTrait(customDefaultValueSupplier));
        }
        if (m.getTimestampFormat() != null) {
            traits.add(this.createTimestampFormatTrait(m));
        }
        if (m.getShape() != null && m.getShape().getXmlNamespace() != null) {
            traits.add(this.createXmlAttributesTrait(m));
        }
        if (m.isXmlAttribute()) {
            traits.add(this.createXmlAttributeTrait());
        }
        if (this.customizationConfig.isRequiredTraitValidationEnabled() && m.isRequired()) {
            traits.add(this.createRequiredTrait());
        }
        if (!traits.isEmpty()) {
            return CodeBlock.builder().add(".traits(" + traits.stream().map(t -> "$L").collect(Collectors.joining(", ")) + ")", traits.toArray()).build();
        }
        return CodeBlock.builder().build();
    }

    private boolean attachPayloadTraitToMember(MemberModel m) {
        return this.customizationConfig.getAttachPayloadTraitToMember().getOrDefault(this.shapeModel.getC2jName(), "").equals(m.getC2jName());
    }

    private CodeBlock createTimestampFormatTrait(MemberModel m) {
        TimestampFormatTrait.Format format = TimestampFormatTrait.Format.fromString((String)m.getTimestampFormat());
        ClassName traitClass = ClassName.get(TimestampFormatTrait.class);
        ClassName formatClass = ClassName.get(TimestampFormatTrait.Format.class);
        return CodeBlock.builder().add("$T.create($T.$L)", new Object[]{traitClass, formatClass, format.name()}).build();
    }

    private CodeBlock createLocationTrait(MemberModel m) {
        MarshallLocation marshallLocation = this.marshallLocation(m);
        String unmarshallLocation = this.unmarshallLocation(m);
        return CodeBlock.builder().add("$T.builder()\n.location($T.$L)\n.locationName($S)\n" + unmarshallLocation + ".build()", new Object[]{ClassName.get(LocationTrait.class), ClassName.get(MarshallLocation.class), marshallLocation, m.getHttp().getMarshallLocationName()}).build();
    }

    private MarshallLocation marshallLocation(MemberModel m) {
        if (m.isEventHeader()) {
            return MarshallLocation.HEADER;
        }
        if (m.isEventPayload()) {
            return MarshallLocation.PAYLOAD;
        }
        return m.getHttp().getMarshallLocation();
    }

    private String unmarshallLocation(MemberModel m) {
        return this.model.getMetadata().getProtocol() == Protocol.EC2 || this.model.getMetadata().getProtocol() == Protocol.REST_XML ? String.format(".unmarshallLocationName(\"%s\")%n", m.getHttp().getUnmarshallLocationName()) : "";
    }

    private CodeBlock createIdempotencyTrait() {
        return CodeBlock.builder().add("$T.idempotencyToken()", new Object[]{ClassName.get(DefaultValueTrait.class)}).build();
    }

    private CodeBlock createDefaultValueTrait(String customDefaultValueSupplier) {
        return CodeBlock.builder().add("$T.create($T.getInstance())", new Object[]{ClassName.get(DefaultValueTrait.class), ClassName.bestGuess((String)customDefaultValueSupplier)}).build();
    }

    private CodeBlock createJsonValueTrait() {
        return CodeBlock.builder().add("$T.create()", new Object[]{ClassName.get(JsonValueTrait.class)}).build();
    }

    private CodeBlock createPayloadTrait() {
        return CodeBlock.builder().add("$T.create()", new Object[]{ClassName.get(PayloadTrait.class)}).build();
    }

    private CodeBlock createRequiredTrait() {
        return CodeBlock.builder().add("$T.create()", new Object[]{ClassName.get(RequiredTrait.class)}).build();
    }

    private CodeBlock createMapTrait(MemberModel m) {
        return CodeBlock.builder().add("$T.builder()\n.keyLocationName($S)\n.valueLocationName($S)\n.valueFieldInfo($L)\n" + this.isFlattened(m) + ".build()", new Object[]{ClassName.get(MapTrait.class), m.getMapModel().getKeyLocationName(), m.getMapModel().getValueLocationName(), this.containerSdkFieldInitializer(m.getMapModel().getValueModel())}).build();
    }

    private CodeBlock createListTrait(MemberModel m) {
        return CodeBlock.builder().add("$T.builder()\n.memberLocationName($S)\n.memberFieldInfo($L)\n" + this.isFlattened(m) + ".build()", new Object[]{ClassName.get(ListTrait.class), m.getListModel().getMemberLocationName(), this.containerSdkFieldInitializer(m.getListModel().getListMemberModel())}).build();
    }

    private CodeBlock createXmlAttributeTrait() {
        return CodeBlock.builder().add("$T.create()", new Object[]{ClassName.get(XmlAttributeTrait.class)}).build();
    }

    private CodeBlock createXmlAttributesTrait(MemberModel model) {
        ShapeModel shape = model.getShape();
        XmlNamespace xmlNamespace = shape.getXmlNamespace();
        String uri = xmlNamespace.getUri();
        String prefix = xmlNamespace.getPrefix();
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder().add("$T.create(", new Object[]{ClassName.get(XmlAttributesTrait.class)});
        String namespacePrefix = "xmlns:" + prefix;
        codeBlockBuilder.add("$T.of($S, $T.builder().attributeGetter((ignore) -> $S).build())", new Object[]{Pair.class, namespacePrefix, XmlAttributesTrait.AttributeAccessors.class, uri});
        Optional<MemberModel> memberWithXmlAttribute = ShapeModelSpec.findMemberWithXmlAttribute(shape);
        memberWithXmlAttribute.ifPresent(m -> {
            String attributeLocation = m.getHttp().getMarshallLocationName();
            codeBlockBuilder.add(", $T.of($S, ", new Object[]{Pair.class, attributeLocation}).add("$T.builder()", new Object[]{XmlAttributesTrait.AttributeAccessors.class}).add(".attributeGetter(t -> (($T)t).$L())\n", new Object[]{this.typeProvider.fieldType(model), m.getFluentGetterMethodName()}).add(".build())", new Object[0]);
        });
        codeBlockBuilder.add(")", new Object[0]);
        return codeBlockBuilder.build();
    }

    private static Optional<MemberModel> findMemberWithXmlAttribute(ShapeModel shapeModel) {
        return shapeModel.getMembers().stream().filter(MemberModel::isXmlAttribute).findAny();
    }

    private String isFlattened(MemberModel m) {
        return m.getHttp().isFlattened() ? ".isFlattened(true)\n" : "";
    }

    private CodeBlock constructor(MemberModel m) {
        if (!(m.isSimple() || m.isList() || m.isMap())) {
            return CodeBlock.builder().add(".constructor($T::builder)\n", new Object[]{this.typeProvider.fieldType(m)}).build();
        }
        return CodeBlock.builder().build();
    }
}

