/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetOnPremisesInstance</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOnPremisesInstanceResponse extends CodeDeployResponse implements
        ToCopyableBuilder<GetOnPremisesInstanceResponse.Builder, GetOnPremisesInstanceResponse> {
    private static final SdkField<InstanceInfo> INSTANCE_INFO_FIELD = SdkField.<InstanceInfo> builder(MarshallingType.SDK_POJO)
            .memberName("instanceInfo").getter(getter(GetOnPremisesInstanceResponse::instanceInfo))
            .setter(setter(Builder::instanceInfo)).constructor(InstanceInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_INFO_FIELD));

    private final InstanceInfo instanceInfo;

    private GetOnPremisesInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.instanceInfo = builder.instanceInfo;
    }

    /**
     * <p>
     * Information about the on-premises instance.
     * </p>
     * 
     * @return Information about the on-premises instance.
     */
    public final InstanceInfo instanceInfo() {
        return instanceInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOnPremisesInstanceResponse)) {
            return false;
        }
        GetOnPremisesInstanceResponse other = (GetOnPremisesInstanceResponse) obj;
        return Objects.equals(instanceInfo(), other.instanceInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOnPremisesInstanceResponse").add("InstanceInfo", instanceInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceInfo":
            return Optional.ofNullable(clazz.cast(instanceInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOnPremisesInstanceResponse, T> g) {
        return obj -> g.apply((GetOnPremisesInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetOnPremisesInstanceResponse> {
        /**
         * <p>
         * Information about the on-premises instance.
         * </p>
         * 
         * @param instanceInfo
         *        Information about the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInfo(InstanceInfo instanceInfo);

        /**
         * <p>
         * Information about the on-premises instance.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceInfo.Builder} avoiding the need to
         * create one manually via {@link InstanceInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceInfo(InstanceInfo)}.
         * 
         * @param instanceInfo
         *        a consumer that will call methods on {@link InstanceInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceInfo(InstanceInfo)
         */
        default Builder instanceInfo(Consumer<InstanceInfo.Builder> instanceInfo) {
            return instanceInfo(InstanceInfo.builder().applyMutation(instanceInfo).build());
        }
    }

    static final class BuilderImpl extends CodeDeployResponse.BuilderImpl implements Builder {
        private InstanceInfo instanceInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOnPremisesInstanceResponse model) {
            super(model);
            instanceInfo(model.instanceInfo);
        }

        public final InstanceInfo.Builder getInstanceInfo() {
            return instanceInfo != null ? instanceInfo.toBuilder() : null;
        }

        public final void setInstanceInfo(InstanceInfo.BuilderImpl instanceInfo) {
            this.instanceInfo = instanceInfo != null ? instanceInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceInfo(InstanceInfo instanceInfo) {
            this.instanceInfo = instanceInfo;
            return this;
        }

        @Override
        public GetOnPremisesInstanceResponse build() {
            return new GetOnPremisesInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
