/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about blue/green deployment options for a deployment group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlueGreenDeploymentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BlueGreenDeploymentConfiguration.Builder, BlueGreenDeploymentConfiguration> {
    private static final SdkField<BlueInstanceTerminationOption> TERMINATE_BLUE_INSTANCES_ON_DEPLOYMENT_SUCCESS_FIELD = SdkField
            .<BlueInstanceTerminationOption> builder(MarshallingType.SDK_POJO)
            .memberName("terminateBlueInstancesOnDeploymentSuccess")
            .getter(getter(BlueGreenDeploymentConfiguration::terminateBlueInstancesOnDeploymentSuccess))
            .setter(setter(Builder::terminateBlueInstancesOnDeploymentSuccess))
            .constructor(BlueInstanceTerminationOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("terminateBlueInstancesOnDeploymentSuccess").build()).build();

    private static final SdkField<DeploymentReadyOption> DEPLOYMENT_READY_OPTION_FIELD = SdkField
            .<DeploymentReadyOption> builder(MarshallingType.SDK_POJO).memberName("deploymentReadyOption")
            .getter(getter(BlueGreenDeploymentConfiguration::deploymentReadyOption))
            .setter(setter(Builder::deploymentReadyOption)).constructor(DeploymentReadyOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentReadyOption").build())
            .build();

    private static final SdkField<GreenFleetProvisioningOption> GREEN_FLEET_PROVISIONING_OPTION_FIELD = SdkField
            .<GreenFleetProvisioningOption> builder(MarshallingType.SDK_POJO)
            .memberName("greenFleetProvisioningOption")
            .getter(getter(BlueGreenDeploymentConfiguration::greenFleetProvisioningOption))
            .setter(setter(Builder::greenFleetProvisioningOption))
            .constructor(GreenFleetProvisioningOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greenFleetProvisioningOption")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TERMINATE_BLUE_INSTANCES_ON_DEPLOYMENT_SUCCESS_FIELD, DEPLOYMENT_READY_OPTION_FIELD,
            GREEN_FLEET_PROVISIONING_OPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final BlueInstanceTerminationOption terminateBlueInstancesOnDeploymentSuccess;

    private final DeploymentReadyOption deploymentReadyOption;

    private final GreenFleetProvisioningOption greenFleetProvisioningOption;

    private BlueGreenDeploymentConfiguration(BuilderImpl builder) {
        this.terminateBlueInstancesOnDeploymentSuccess = builder.terminateBlueInstancesOnDeploymentSuccess;
        this.deploymentReadyOption = builder.deploymentReadyOption;
        this.greenFleetProvisioningOption = builder.greenFleetProvisioningOption;
    }

    /**
     * <p>
     * Information about whether to terminate instances in the original fleet during a blue/green deployment.
     * </p>
     * 
     * @return Information about whether to terminate instances in the original fleet during a blue/green deployment.
     */
    public final BlueInstanceTerminationOption terminateBlueInstancesOnDeploymentSuccess() {
        return terminateBlueInstancesOnDeploymentSuccess;
    }

    /**
     * <p>
     * Information about the action to take when newly provisioned instances are ready to receive traffic in a
     * blue/green deployment.
     * </p>
     * 
     * @return Information about the action to take when newly provisioned instances are ready to receive traffic in a
     *         blue/green deployment.
     */
    public final DeploymentReadyOption deploymentReadyOption() {
        return deploymentReadyOption;
    }

    /**
     * <p>
     * Information about how instances are provisioned for a replacement environment in a blue/green deployment.
     * </p>
     * 
     * @return Information about how instances are provisioned for a replacement environment in a blue/green deployment.
     */
    public final GreenFleetProvisioningOption greenFleetProvisioningOption() {
        return greenFleetProvisioningOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(terminateBlueInstancesOnDeploymentSuccess());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentReadyOption());
        hashCode = 31 * hashCode + Objects.hashCode(greenFleetProvisioningOption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueGreenDeploymentConfiguration)) {
            return false;
        }
        BlueGreenDeploymentConfiguration other = (BlueGreenDeploymentConfiguration) obj;
        return Objects.equals(terminateBlueInstancesOnDeploymentSuccess(), other.terminateBlueInstancesOnDeploymentSuccess())
                && Objects.equals(deploymentReadyOption(), other.deploymentReadyOption())
                && Objects.equals(greenFleetProvisioningOption(), other.greenFleetProvisioningOption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlueGreenDeploymentConfiguration")
                .add("TerminateBlueInstancesOnDeploymentSuccess", terminateBlueInstancesOnDeploymentSuccess())
                .add("DeploymentReadyOption", deploymentReadyOption())
                .add("GreenFleetProvisioningOption", greenFleetProvisioningOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "terminateBlueInstancesOnDeploymentSuccess":
            return Optional.ofNullable(clazz.cast(terminateBlueInstancesOnDeploymentSuccess()));
        case "deploymentReadyOption":
            return Optional.ofNullable(clazz.cast(deploymentReadyOption()));
        case "greenFleetProvisioningOption":
            return Optional.ofNullable(clazz.cast(greenFleetProvisioningOption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlueGreenDeploymentConfiguration, T> g) {
        return obj -> g.apply((BlueGreenDeploymentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlueGreenDeploymentConfiguration> {
        /**
         * <p>
         * Information about whether to terminate instances in the original fleet during a blue/green deployment.
         * </p>
         * 
         * @param terminateBlueInstancesOnDeploymentSuccess
         *        Information about whether to terminate instances in the original fleet during a blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateBlueInstancesOnDeploymentSuccess(BlueInstanceTerminationOption terminateBlueInstancesOnDeploymentSuccess);

        /**
         * <p>
         * Information about whether to terminate instances in the original fleet during a blue/green deployment.
         * </p>
         * This is a convenience that creates an instance of the {@link BlueInstanceTerminationOption.Builder} avoiding
         * the need to create one manually via {@link BlueInstanceTerminationOption#builder()}.
         *
         * When the {@link Consumer} completes, {@link BlueInstanceTerminationOption.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #terminateBlueInstancesOnDeploymentSuccess(BlueInstanceTerminationOption)}.
         * 
         * @param terminateBlueInstancesOnDeploymentSuccess
         *        a consumer that will call methods on {@link BlueInstanceTerminationOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terminateBlueInstancesOnDeploymentSuccess(BlueInstanceTerminationOption)
         */
        default Builder terminateBlueInstancesOnDeploymentSuccess(
                Consumer<BlueInstanceTerminationOption.Builder> terminateBlueInstancesOnDeploymentSuccess) {
            return terminateBlueInstancesOnDeploymentSuccess(BlueInstanceTerminationOption.builder()
                    .applyMutation(terminateBlueInstancesOnDeploymentSuccess).build());
        }

        /**
         * <p>
         * Information about the action to take when newly provisioned instances are ready to receive traffic in a
         * blue/green deployment.
         * </p>
         * 
         * @param deploymentReadyOption
         *        Information about the action to take when newly provisioned instances are ready to receive traffic in
         *        a blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentReadyOption(DeploymentReadyOption deploymentReadyOption);

        /**
         * <p>
         * Information about the action to take when newly provisioned instances are ready to receive traffic in a
         * blue/green deployment.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentReadyOption.Builder} avoiding the need
         * to create one manually via {@link DeploymentReadyOption#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentReadyOption.Builder#build()} is called immediately and
         * its result is passed to {@link #deploymentReadyOption(DeploymentReadyOption)}.
         * 
         * @param deploymentReadyOption
         *        a consumer that will call methods on {@link DeploymentReadyOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentReadyOption(DeploymentReadyOption)
         */
        default Builder deploymentReadyOption(Consumer<DeploymentReadyOption.Builder> deploymentReadyOption) {
            return deploymentReadyOption(DeploymentReadyOption.builder().applyMutation(deploymentReadyOption).build());
        }

        /**
         * <p>
         * Information about how instances are provisioned for a replacement environment in a blue/green deployment.
         * </p>
         * 
         * @param greenFleetProvisioningOption
         *        Information about how instances are provisioned for a replacement environment in a blue/green
         *        deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greenFleetProvisioningOption(GreenFleetProvisioningOption greenFleetProvisioningOption);

        /**
         * <p>
         * Information about how instances are provisioned for a replacement environment in a blue/green deployment.
         * </p>
         * This is a convenience that creates an instance of the {@link GreenFleetProvisioningOption.Builder} avoiding
         * the need to create one manually via {@link GreenFleetProvisioningOption#builder()}.
         *
         * When the {@link Consumer} completes, {@link GreenFleetProvisioningOption.Builder#build()} is called
         * immediately and its result is passed to {@link #greenFleetProvisioningOption(GreenFleetProvisioningOption)}.
         * 
         * @param greenFleetProvisioningOption
         *        a consumer that will call methods on {@link GreenFleetProvisioningOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greenFleetProvisioningOption(GreenFleetProvisioningOption)
         */
        default Builder greenFleetProvisioningOption(Consumer<GreenFleetProvisioningOption.Builder> greenFleetProvisioningOption) {
            return greenFleetProvisioningOption(GreenFleetProvisioningOption.builder()
                    .applyMutation(greenFleetProvisioningOption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BlueInstanceTerminationOption terminateBlueInstancesOnDeploymentSuccess;

        private DeploymentReadyOption deploymentReadyOption;

        private GreenFleetProvisioningOption greenFleetProvisioningOption;

        private BuilderImpl() {
        }

        private BuilderImpl(BlueGreenDeploymentConfiguration model) {
            terminateBlueInstancesOnDeploymentSuccess(model.terminateBlueInstancesOnDeploymentSuccess);
            deploymentReadyOption(model.deploymentReadyOption);
            greenFleetProvisioningOption(model.greenFleetProvisioningOption);
        }

        public final BlueInstanceTerminationOption.Builder getTerminateBlueInstancesOnDeploymentSuccess() {
            return terminateBlueInstancesOnDeploymentSuccess != null ? terminateBlueInstancesOnDeploymentSuccess.toBuilder()
                    : null;
        }

        public final void setTerminateBlueInstancesOnDeploymentSuccess(
                BlueInstanceTerminationOption.BuilderImpl terminateBlueInstancesOnDeploymentSuccess) {
            this.terminateBlueInstancesOnDeploymentSuccess = terminateBlueInstancesOnDeploymentSuccess != null ? terminateBlueInstancesOnDeploymentSuccess
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder terminateBlueInstancesOnDeploymentSuccess(
                BlueInstanceTerminationOption terminateBlueInstancesOnDeploymentSuccess) {
            this.terminateBlueInstancesOnDeploymentSuccess = terminateBlueInstancesOnDeploymentSuccess;
            return this;
        }

        public final DeploymentReadyOption.Builder getDeploymentReadyOption() {
            return deploymentReadyOption != null ? deploymentReadyOption.toBuilder() : null;
        }

        public final void setDeploymentReadyOption(DeploymentReadyOption.BuilderImpl deploymentReadyOption) {
            this.deploymentReadyOption = deploymentReadyOption != null ? deploymentReadyOption.build() : null;
        }

        @Override
        @Transient
        public final Builder deploymentReadyOption(DeploymentReadyOption deploymentReadyOption) {
            this.deploymentReadyOption = deploymentReadyOption;
            return this;
        }

        public final GreenFleetProvisioningOption.Builder getGreenFleetProvisioningOption() {
            return greenFleetProvisioningOption != null ? greenFleetProvisioningOption.toBuilder() : null;
        }

        public final void setGreenFleetProvisioningOption(GreenFleetProvisioningOption.BuilderImpl greenFleetProvisioningOption) {
            this.greenFleetProvisioningOption = greenFleetProvisioningOption != null ? greenFleetProvisioningOption.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder greenFleetProvisioningOption(GreenFleetProvisioningOption greenFleetProvisioningOption) {
            this.greenFleetProvisioningOption = greenFleetProvisioningOption;
            return this;
        }

        @Override
        public BlueGreenDeploymentConfiguration build() {
            return new BlueGreenDeploymentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
