/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.AlarmsLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.ArnNotSupportedException;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.BucketNameFilterRequiredException;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployException;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteResourcesByExternalIdRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteResourcesByExternalIdResponse;
import software.amazon.awssdk.services.codedeploy.model.DeploymentAlreadyCompletedException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigInUseException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentIdRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentIsNotInReadyStateException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentNotStartedException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentTargetDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentTargetIdRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentTargetListSizeExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.DescriptionTooLongException;
import software.amazon.awssdk.services.codedeploy.model.EcsServiceMappingLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetResponse;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.GitHubAccountTokenDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.GitHubAccountTokenNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.IamArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.IamSessionArnAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.IamUserArnAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.IamUserArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNotRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAlarmConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidApplicationNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAutoRollbackConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAutoScalingGroupException;
import software.amazon.awssdk.services.codedeploy.model.InvalidBlueGreenDeploymentConfigurationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidBucketNameFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidComputePlatformException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeployedStateFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentConfigNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentGroupNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentInstanceTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentStyleException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentTargetIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentWaitTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidEc2TagCombinationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidEc2TagException;
import software.amazon.awssdk.services.codedeploy.model.InvalidEcsServiceException;
import software.amazon.awssdk.services.codedeploy.model.InvalidExternalIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidFileExistsBehaviorException;
import software.amazon.awssdk.services.codedeploy.model.InvalidGitHubAccountTokenException;
import software.amazon.awssdk.services.codedeploy.model.InvalidGitHubAccountTokenNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIamSessionArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIamUserArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIgnoreApplicationStopFailuresValueException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInputException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidKeyPrefixFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidLifecycleEventHookExecutionIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidLifecycleEventHookExecutionStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidLoadBalancerInfoException;
import software.amazon.awssdk.services.codedeploy.model.InvalidMinimumHealthyHostValueException;
import software.amazon.awssdk.services.codedeploy.model.InvalidNextTokenException;
import software.amazon.awssdk.services.codedeploy.model.InvalidOnPremisesTagCombinationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidOperationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRegistrationStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRevisionException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRoleException;
import software.amazon.awssdk.services.codedeploy.model.InvalidSortByException;
import software.amazon.awssdk.services.codedeploy.model.InvalidSortOrderException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagsToAddException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTargetGroupPairException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTargetInstancesException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTrafficRoutingConfigurationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTriggerConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidUpdateOutdatedInstancesOnlyValueException;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEventAlreadyCompletedException;
import software.amazon.awssdk.services.codedeploy.model.LifecycleHookLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codedeploy.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codedeploy.model.MultipleIamArnsProvidedException;
import software.amazon.awssdk.services.codedeploy.model.OperationNotSupportedException;
import software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest;
import software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ResourceArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.ResourceValidationException;
import software.amazon.awssdk.services.codedeploy.model.RevisionDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.RevisionRequiredException;
import software.amazon.awssdk.services.codedeploy.model.RoleRequiredException;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.TagLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.TagRequiredException;
import software.amazon.awssdk.services.codedeploy.model.TagResourceRequest;
import software.amazon.awssdk.services.codedeploy.model.TagResourceResponse;
import software.amazon.awssdk.services.codedeploy.model.TagSetListLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ThrottlingException;
import software.amazon.awssdk.services.codedeploy.model.TriggerTargetsLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.UnsupportedActionForDeploymentTypeException;
import software.amazon.awssdk.services.codedeploy.model.UntagResourceRequest;
import software.amazon.awssdk.services.codedeploy.model.UntagResourceResponse;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.paginators.ListApplicationRevisionsIterable;
import software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsIterable;
import software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsIterable;
import software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentGroupsIterable;
import software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsIterable;
import software.amazon.awssdk.services.codedeploy.waiters.CodeDeployWaiter;

/**
 * Service client for accessing CodeDeploy. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS CodeDeploy</fullname>
 * <p>
 * AWS CodeDeploy is a deployment service that automates application deployments to Amazon EC2 instances, on-premises
 * instances running in your own facility, serverless AWS Lambda functions, or applications in an Amazon ECS service.
 * </p>
 * <p>
 * You can deploy a nearly unlimited variety of application content, such as an updated Lambda function, updated
 * applications in an Amazon ECS service, code, web and configuration files, executables, packages, scripts, multimedia
 * files, and so on. AWS CodeDeploy can deploy application content stored in Amazon S3 buckets, GitHub repositories, or
 * Bitbucket repositories. You do not need to make changes to your existing code before you can use AWS CodeDeploy.
 * </p>
 * <p>
 * AWS CodeDeploy makes it easier for you to rapidly release new features, helps you avoid downtime during application
 * deployment, and handles the complexity of updating your applications, without many of the risks associated with
 * error-prone manual deployments.
 * </p>
 * <p>
 * <b>AWS CodeDeploy Components</b>
 * </p>
 * <p>
 * Use the information in this guide to help you work with the following AWS CodeDeploy components:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Application</b>: A name that uniquely identifies the application you want to deploy. AWS CodeDeploy uses this
 * name, which functions as a container, to ensure the correct combination of revision, deployment configuration, and
 * deployment group are referenced during a deployment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Deployment group</b>: A set of individual instances, CodeDeploy Lambda deployment configuration settings, or an
 * Amazon ECS service and network details. A Lambda deployment group specifies how to route traffic to a new version of
 * a Lambda function. An Amazon ECS deployment group specifies the service created in Amazon ECS to deploy, a load
 * balancer, and a listener to reroute production traffic to an updated containerized application. An EC2/On-premises
 * deployment group contains individually tagged instances, Amazon EC2 instances in Amazon EC2 Auto Scaling groups, or
 * both. All deployment groups can specify optional trigger, alarm, and rollback settings.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Deployment configuration</b>: A set of deployment rules and deployment success and failure conditions used by AWS
 * CodeDeploy during a deployment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Deployment</b>: The process and the components used when updating a Lambda function, a containerized application
 * in an Amazon ECS service, or of installing content on one or more instances.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Application revisions</b>: For an AWS Lambda deployment, this is an AppSpec file that specifies the Lambda
 * function to be updated and one or more functions to validate deployment lifecycle events. For an Amazon ECS
 * deployment, this is an AppSpec file that specifies the Amazon ECS task definition, container, and port where
 * production traffic is rerouted. For an EC2/On-premises deployment, this is an archive file that contains source
 * content—source code, webpages, executable files, and deployment scripts—along with an AppSpec file. Revisions are
 * stored in Amazon S3 buckets or GitHub repositories. For Amazon S3, a revision is uniquely identified by its Amazon S3
 * object key and its ETag, version, or both. For GitHub, a revision is uniquely identified by its commit ID.
 * </p>
 * </li>
 * </ul>
 * <p>
 * This guide also contains information to help you get details about the instances in your deployments, to make
 * on-premises instances available for AWS CodeDeploy deployments, to get details about a Lambda function deployment,
 * and to get details about Amazon ECS service deployments.
 * </p>
 * <p>
 * <b>AWS CodeDeploy Information Resources</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide">AWS CodeDeploy User Guide</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/">AWS CodeDeploy API Reference Guide</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/cli/latest/reference/deploy/index.html">AWS CLI Reference for AWS CodeDeploy</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://forums.aws.amazon.com/forum.jspa?forumID=179">AWS CodeDeploy Developer Forum</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CodeDeployClient extends SdkClient {
    String SERVICE_NAME = "codedeploy";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "codedeploy";

    /**
     * Create a {@link CodeDeployClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CodeDeployClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CodeDeployClient}.
     */
    static CodeDeployClientBuilder builder() {
        return new DefaultCodeDeployClientBuilder();
    }

    /**
     * <p>
     * Adds tags to on-premises instances.
     * </p>
     *
     * @param addTagsToOnPremisesInstancesRequest
     *        Represents the input of, and adds tags to, an on-premises instance operation.
     * @return Result of the AddTagsToOnPremisesInstances operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws TagRequiredException
     *         A tag was not specified.
     * @throws InvalidTagException
     *         The tag was specified in an invalid format.
     * @throws TagLimitExceededException
     *         The maximum allowed number of tags was exceeded.
     * @throws InstanceLimitExceededException
     *         The maximum number of allowed on-premises instances in a single call was exceeded.
     * @throws InstanceNotRegisteredException
     *         The specified on-premises instance is not registered.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.AddTagsToOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/AddTagsToOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default AddTagsToOnPremisesInstancesResponse addTagsToOnPremisesInstances(
            AddTagsToOnPremisesInstancesRequest addTagsToOnPremisesInstancesRequest) throws InstanceNameRequiredException,
            InvalidInstanceNameException, TagRequiredException, InvalidTagException, TagLimitExceededException,
            InstanceLimitExceededException, InstanceNotRegisteredException, AwsServiceException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to on-premises instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToOnPremisesInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link AddTagsToOnPremisesInstancesRequest#builder()}
     * </p>
     *
     * @param addTagsToOnPremisesInstancesRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsToOnPremisesInstancesInput.Builder} to create a
     *        request. Represents the input of, and adds tags to, an on-premises instance operation.
     * @return Result of the AddTagsToOnPremisesInstances operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws TagRequiredException
     *         A tag was not specified.
     * @throws InvalidTagException
     *         The tag was specified in an invalid format.
     * @throws TagLimitExceededException
     *         The maximum allowed number of tags was exceeded.
     * @throws InstanceLimitExceededException
     *         The maximum number of allowed on-premises instances in a single call was exceeded.
     * @throws InstanceNotRegisteredException
     *         The specified on-premises instance is not registered.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.AddTagsToOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/AddTagsToOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default AddTagsToOnPremisesInstancesResponse addTagsToOnPremisesInstances(
            Consumer<AddTagsToOnPremisesInstancesRequest.Builder> addTagsToOnPremisesInstancesRequest)
            throws InstanceNameRequiredException, InvalidInstanceNameException, TagRequiredException, InvalidTagException,
            TagLimitExceededException, InstanceLimitExceededException, InstanceNotRegisteredException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return addTagsToOnPremisesInstances(AddTagsToOnPremisesInstancesRequest.builder()
                .applyMutation(addTagsToOnPremisesInstancesRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more application revisions. The maximum number of application revisions that can be
     * returned is 25.
     * </p>
     *
     * @param batchGetApplicationRevisionsRequest
     *        Represents the input of a <code>BatchGetApplicationRevisions</code> operation.
     * @return Result of the BatchGetApplicationRevisions operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetApplicationRevisionsResponse batchGetApplicationRevisions(
            BatchGetApplicationRevisionsRequest batchGetApplicationRevisionsRequest) throws ApplicationDoesNotExistException,
            ApplicationNameRequiredException, InvalidApplicationNameException, RevisionRequiredException,
            InvalidRevisionException, BatchLimitExceededException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more application revisions. The maximum number of application revisions that can be
     * returned is 25.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetApplicationRevisionsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetApplicationRevisionsRequest#builder()}
     * </p>
     *
     * @param batchGetApplicationRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetApplicationRevisionsInput.Builder} to create a
     *        request. Represents the input of a <code>BatchGetApplicationRevisions</code> operation.
     * @return Result of the BatchGetApplicationRevisions operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetApplicationRevisionsResponse batchGetApplicationRevisions(
            Consumer<BatchGetApplicationRevisionsRequest.Builder> batchGetApplicationRevisionsRequest)
            throws ApplicationDoesNotExistException, ApplicationNameRequiredException, InvalidApplicationNameException,
            RevisionRequiredException, InvalidRevisionException, BatchLimitExceededException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return batchGetApplicationRevisions(BatchGetApplicationRevisionsRequest.builder()
                .applyMutation(batchGetApplicationRevisionsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more applications. The maximum number of applications that can be returned is 100.
     * </p>
     *
     * @param batchGetApplicationsRequest
     *        Represents the input of a <code>BatchGetApplications</code> operation.
     * @return Result of the BatchGetApplications operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetApplicationsResponse batchGetApplications(BatchGetApplicationsRequest batchGetApplicationsRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            BatchLimitExceededException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more applications. The maximum number of applications that can be returned is 100.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetApplicationsRequest#builder()}
     * </p>
     *
     * @param batchGetApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetApplicationsInput.Builder} to create a
     *        request. Represents the input of a <code>BatchGetApplications</code> operation.
     * @return Result of the BatchGetApplications operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetApplicationsResponse batchGetApplications(
            Consumer<BatchGetApplicationsRequest.Builder> batchGetApplicationsRequest) throws ApplicationNameRequiredException,
            InvalidApplicationNameException, ApplicationDoesNotExistException, BatchLimitExceededException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return batchGetApplications(BatchGetApplicationsRequest.builder().applyMutation(batchGetApplicationsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more deployment groups.
     * </p>
     *
     * @param batchGetDeploymentGroupsRequest
     *        Represents the input of a <code>BatchGetDeploymentGroups</code> operation.
     * @return Result of the BatchGetDeploymentGroups operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the IAM user or AWS account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetDeploymentGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetDeploymentGroupsResponse batchGetDeploymentGroups(
            BatchGetDeploymentGroupsRequest batchGetDeploymentGroupsRequest) throws ApplicationNameRequiredException,
            InvalidApplicationNameException, ApplicationDoesNotExistException, DeploymentGroupNameRequiredException,
            InvalidDeploymentGroupNameException, BatchLimitExceededException, DeploymentConfigDoesNotExistException,
            AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more deployment groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetDeploymentGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetDeploymentGroupsRequest#builder()}
     * </p>
     *
     * @param batchGetDeploymentGroupsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetDeploymentGroupsInput.Builder} to create a
     *        request. Represents the input of a <code>BatchGetDeploymentGroups</code> operation.
     * @return Result of the BatchGetDeploymentGroups operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the IAM user or AWS account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetDeploymentGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetDeploymentGroupsResponse batchGetDeploymentGroups(
            Consumer<BatchGetDeploymentGroupsRequest.Builder> batchGetDeploymentGroupsRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            DeploymentGroupNameRequiredException, InvalidDeploymentGroupNameException, BatchLimitExceededException,
            DeploymentConfigDoesNotExistException, AwsServiceException, SdkClientException, CodeDeployException {
        return batchGetDeploymentGroups(BatchGetDeploymentGroupsRequest.builder().applyMutation(batchGetDeploymentGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns an array of one or more targets associated with a deployment. This method works with all compute types
     * and should be used instead of the deprecated <code>BatchGetDeploymentInstances</code>. The maximum number of
     * targets that can be returned is 25.
     * </p>
     * <p>
     * The type of targets returned depends on the deployment's compute platform or deployment method:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>EC2/On-premises</b>: Information about EC2 instance targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AWS Lambda</b>: Information about Lambda functions targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon ECS</b>: Information about Amazon ECS service targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CloudFormation</b>: Information about targets of blue/green deployments initiated by a CloudFormation stack
     * update.
     * </p>
     * </li>
     * </ul>
     *
     * @param batchGetDeploymentTargetsRequest
     * @return Result of the BatchGetDeploymentTargets operation returned by the service.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the IAM user or AWS account does not exist.
     * @throws DeploymentNotStartedException
     *         The specified deployment has not started.
     * @throws DeploymentTargetIdRequiredException
     *         A deployment target ID was not provided.
     * @throws InvalidDeploymentTargetIdException
     *         The target ID provided was not valid.
     * @throws DeploymentTargetDoesNotExistException
     *         The provided target ID does not belong to the attempted deployment.
     * @throws DeploymentTargetListSizeExceededException
     *         The maximum number of targets that can be associated with an Amazon ECS or AWS Lambda deployment was
     *         exceeded. The target list of both types of deployments must have exactly one item. This exception does
     *         not apply to EC2/On-premises deployments.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetDeploymentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetDeploymentTargetsResponse batchGetDeploymentTargets(
            BatchGetDeploymentTargetsRequest batchGetDeploymentTargetsRequest) throws InvalidDeploymentIdException,
            DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentNotStartedException,
            DeploymentTargetIdRequiredException, InvalidDeploymentTargetIdException, DeploymentTargetDoesNotExistException,
            DeploymentTargetListSizeExceededException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of one or more targets associated with a deployment. This method works with all compute types
     * and should be used instead of the deprecated <code>BatchGetDeploymentInstances</code>. The maximum number of
     * targets that can be returned is 25.
     * </p>
     * <p>
     * The type of targets returned depends on the deployment's compute platform or deployment method:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>EC2/On-premises</b>: Information about EC2 instance targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AWS Lambda</b>: Information about Lambda functions targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon ECS</b>: Information about Amazon ECS service targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CloudFormation</b>: Information about targets of blue/green deployments initiated by a CloudFormation stack
     * update.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetDeploymentTargetsRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetDeploymentTargetsRequest#builder()}
     * </p>
     *
     * @param batchGetDeploymentTargetsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetDeploymentTargetsInput.Builder} to create a
     *        request.
     * @return Result of the BatchGetDeploymentTargets operation returned by the service.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the IAM user or AWS account does not exist.
     * @throws DeploymentNotStartedException
     *         The specified deployment has not started.
     * @throws DeploymentTargetIdRequiredException
     *         A deployment target ID was not provided.
     * @throws InvalidDeploymentTargetIdException
     *         The target ID provided was not valid.
     * @throws DeploymentTargetDoesNotExistException
     *         The provided target ID does not belong to the attempted deployment.
     * @throws DeploymentTargetListSizeExceededException
     *         The maximum number of targets that can be associated with an Amazon ECS or AWS Lambda deployment was
     *         exceeded. The target list of both types of deployments must have exactly one item. This exception does
     *         not apply to EC2/On-premises deployments.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetDeploymentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetDeploymentTargetsResponse batchGetDeploymentTargets(
            Consumer<BatchGetDeploymentTargetsRequest.Builder> batchGetDeploymentTargetsRequest)
            throws InvalidDeploymentIdException, DeploymentIdRequiredException, DeploymentDoesNotExistException,
            DeploymentNotStartedException, DeploymentTargetIdRequiredException, InvalidDeploymentTargetIdException,
            DeploymentTargetDoesNotExistException, DeploymentTargetListSizeExceededException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return batchGetDeploymentTargets(BatchGetDeploymentTargetsRequest.builder()
                .applyMutation(batchGetDeploymentTargetsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more deployments. The maximum number of deployments that can be returned is 25.
     * </p>
     *
     * @param batchGetDeploymentsRequest
     *        Represents the input of a <code>BatchGetDeployments</code> operation.
     * @return Result of the BatchGetDeployments operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetDeploymentsResponse batchGetDeployments(BatchGetDeploymentsRequest batchGetDeploymentsRequest)
            throws DeploymentIdRequiredException, InvalidDeploymentIdException, BatchLimitExceededException, AwsServiceException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more deployments. The maximum number of deployments that can be returned is 25.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetDeploymentsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetDeploymentsRequest#builder()}
     * </p>
     *
     * @param batchGetDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetDeploymentsInput.Builder} to create a request.
     *        Represents the input of a <code>BatchGetDeployments</code> operation.
     * @return Result of the BatchGetDeployments operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetDeploymentsResponse batchGetDeployments(
            Consumer<BatchGetDeploymentsRequest.Builder> batchGetDeploymentsRequest) throws DeploymentIdRequiredException,
            InvalidDeploymentIdException, BatchLimitExceededException, AwsServiceException, SdkClientException,
            CodeDeployException {
        return batchGetDeployments(BatchGetDeploymentsRequest.builder().applyMutation(batchGetDeploymentsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more on-premises instances. The maximum number of on-premises instances that can be
     * returned is 25.
     * </p>
     *
     * @param batchGetOnPremisesInstancesRequest
     *        Represents the input of a <code>BatchGetOnPremisesInstances</code> operation.
     * @return Result of the BatchGetOnPremisesInstances operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetOnPremisesInstancesResponse batchGetOnPremisesInstances(
            BatchGetOnPremisesInstancesRequest batchGetOnPremisesInstancesRequest) throws InstanceNameRequiredException,
            InvalidInstanceNameException, BatchLimitExceededException, AwsServiceException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more on-premises instances. The maximum number of on-premises instances that can be
     * returned is 25.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetOnPremisesInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetOnPremisesInstancesRequest#builder()}
     * </p>
     *
     * @param batchGetOnPremisesInstancesRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetOnPremisesInstancesInput.Builder} to create a
     *        request. Represents the input of a <code>BatchGetOnPremisesInstances</code> operation.
     * @return Result of the BatchGetOnPremisesInstances operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetOnPremisesInstancesResponse batchGetOnPremisesInstances(
            Consumer<BatchGetOnPremisesInstancesRequest.Builder> batchGetOnPremisesInstancesRequest)
            throws InstanceNameRequiredException, InvalidInstanceNameException, BatchLimitExceededException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return batchGetOnPremisesInstances(BatchGetOnPremisesInstancesRequest.builder()
                .applyMutation(batchGetOnPremisesInstancesRequest).build());
    }

    /**
     * <p>
     * For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment
     * to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic
     * rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can
     * start as soon as all instances have a status of Ready.)
     * </p>
     *
     * @param continueDeploymentRequest
     * @return Result of the ContinueDeployment operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the IAM user or AWS account does not exist.
     * @throws DeploymentAlreadyCompletedException
     *         The deployment is already complete.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentIsNotInReadyStateException
     *         The deployment does not have a status of Ready and can't continue yet.
     * @throws UnsupportedActionForDeploymentTypeException
     *         A call was submitted that is not supported for the specified deployment type.
     * @throws InvalidDeploymentWaitTypeException
     *         The wait type is invalid.
     * @throws InvalidDeploymentStatusException
     *         The specified deployment status doesn't exist or cannot be determined.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ContinueDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ContinueDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default ContinueDeploymentResponse continueDeployment(ContinueDeploymentRequest continueDeploymentRequest)
            throws DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentAlreadyCompletedException,
            InvalidDeploymentIdException, DeploymentIsNotInReadyStateException, UnsupportedActionForDeploymentTypeException,
            InvalidDeploymentWaitTypeException, InvalidDeploymentStatusException, AwsServiceException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment
     * to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic
     * rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can
     * start as soon as all instances have a status of Ready.)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ContinueDeploymentRequest.Builder} avoiding the
     * need to create one manually via {@link ContinueDeploymentRequest#builder()}
     * </p>
     *
     * @param continueDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link ContinueDeploymentInput.Builder} to create a request.
     * @return Result of the ContinueDeployment operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the IAM user or AWS account does not exist.
     * @throws DeploymentAlreadyCompletedException
     *         The deployment is already complete.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentIsNotInReadyStateException
     *         The deployment does not have a status of Ready and can't continue yet.
     * @throws UnsupportedActionForDeploymentTypeException
     *         A call was submitted that is not supported for the specified deployment type.
     * @throws InvalidDeploymentWaitTypeException
     *         The wait type is invalid.
     * @throws InvalidDeploymentStatusException
     *         The specified deployment status doesn't exist or cannot be determined.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ContinueDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ContinueDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default ContinueDeploymentResponse continueDeployment(Consumer<ContinueDeploymentRequest.Builder> continueDeploymentRequest)
            throws DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentAlreadyCompletedException,
            InvalidDeploymentIdException, DeploymentIsNotInReadyStateException, UnsupportedActionForDeploymentTypeException,
            InvalidDeploymentWaitTypeException, InvalidDeploymentStatusException, AwsServiceException, SdkClientException,
            CodeDeployException {
        return continueDeployment(ContinueDeploymentRequest.builder().applyMutation(continueDeploymentRequest).build());
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     *
     * @param createApplicationRequest
     *        Represents the input of a <code>CreateApplication</code> operation.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationAlreadyExistsException
     *         An application with the specified name with the IAM user or AWS account already exists.
     * @throws ApplicationLimitExceededException
     *         More applications were attempted to be created than are allowed.
     * @throws InvalidComputePlatformException
     *         The computePlatform is invalid. The computePlatform should be <code>Lambda</code>, <code>Server</code>,
     *         or <code>ECS</code>.
     * @throws InvalidTagsToAddException
     *         The specified tags are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationAlreadyExistsException,
            ApplicationLimitExceededException, InvalidComputePlatformException, InvalidTagsToAddException, AwsServiceException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationInput.Builder} to create a request.
     *        Represents the input of a <code>CreateApplication</code> operation.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationAlreadyExistsException
     *         An application with the specified name with the IAM user or AWS account already exists.
     * @throws ApplicationLimitExceededException
     *         More applications were attempted to be created than are allowed.
     * @throws InvalidComputePlatformException
     *         The computePlatform is invalid. The computePlatform should be <code>Lambda</code>, <code>Server</code>,
     *         or <code>ECS</code>.
     * @throws InvalidTagsToAddException
     *         The specified tags are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateApplicationResponse createApplication(Consumer<CreateApplicationRequest.Builder> createApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationAlreadyExistsException,
            ApplicationLimitExceededException, InvalidComputePlatformException, InvalidTagsToAddException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Deploys an application revision through the specified deployment group.
     * </p>
     *
     * @param createDeploymentRequest
     *        Represents the input of a <code>CreateDeployment</code> operation.
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws RevisionDoesNotExistException
     *         The named revision does not exist with the IAM user or AWS account.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the IAM user or AWS account.
     * @throws DescriptionTooLongException
     *         The description is too long.
     * @throws DeploymentLimitExceededException
     *         The number of allowed deployments was exceeded.
     * @throws InvalidTargetInstancesException
     *         The target instance configuration is invalid. Possible causes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Configuration data for target instances was entered for an in-place deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The limit of 10 tags for a tag type was exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The combined length of the tag names exceeded the limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A specified tag is not currently applied to any instances.
     *         </p>
     *         </li>
     * @throws InvalidAutoRollbackConfigException
     *         The automatic rollback configuration was specified in an invalid format. For example, automatic rollback
     *         is enabled, but an invalid triggering event type or no event types were listed.
     * @throws InvalidLoadBalancerInfoException
     *         An invalid load balancer name, or no load balancer name, was specified.
     * @throws InvalidFileExistsBehaviorException
     *         An invalid fileExistsBehavior option was specified to determine how AWS CodeDeploy handles files or
     *         directories that already exist in a deployment target location, but weren't part of the previous
     *         successful deployment. Valid values include "DISALLOW," "OVERWRITE," and "RETAIN."
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Amazon EC2 Auto Scaling.
     * @throws InvalidAutoScalingGroupException
     *         The Auto Scaling group was specified in an invalid format or does not exist.
     * @throws ThrottlingException
     *         An API function was called too frequently.
     * @throws InvalidUpdateOutdatedInstancesOnlyValueException
     *         The UpdateOutdatedInstancesOnly value is invalid. For AWS Lambda deployments, <code>false</code> is
     *         expected. For EC2/On-premises deployments, <code>true</code> or <code>false</code> is expected.
     * @throws InvalidIgnoreApplicationStopFailuresValueException
     *         The IgnoreApplicationStopFailures value is invalid. For AWS Lambda deployments, <code>false</code> is
     *         expected. For EC2/On-premises deployments, <code>true</code> or <code>false</code> is expected.
     * @throws InvalidGitHubAccountTokenException
     *         The GitHub token is not valid.
     * @throws InvalidTrafficRoutingConfigurationException
     *         The configuration that specifies how traffic is routed during a deployment is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDeploymentResponse createDeployment(CreateDeploymentRequest createDeploymentRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            DeploymentGroupNameRequiredException, InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException,
            RevisionRequiredException, RevisionDoesNotExistException, InvalidRevisionException,
            InvalidDeploymentConfigNameException, DeploymentConfigDoesNotExistException, DescriptionTooLongException,
            DeploymentLimitExceededException, InvalidTargetInstancesException, InvalidAutoRollbackConfigException,
            InvalidLoadBalancerInfoException, InvalidFileExistsBehaviorException, InvalidRoleException,
            InvalidAutoScalingGroupException, ThrottlingException, InvalidUpdateOutdatedInstancesOnlyValueException,
            InvalidIgnoreApplicationStopFailuresValueException, InvalidGitHubAccountTokenException,
            InvalidTrafficRoutingConfigurationException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deploys an application revision through the specified deployment group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDeploymentRequest#builder()}
     * </p>
     *
     * @param createDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeploymentInput.Builder} to create a request.
     *        Represents the input of a <code>CreateDeployment</code> operation.
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws RevisionDoesNotExistException
     *         The named revision does not exist with the IAM user or AWS account.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the IAM user or AWS account.
     * @throws DescriptionTooLongException
     *         The description is too long.
     * @throws DeploymentLimitExceededException
     *         The number of allowed deployments was exceeded.
     * @throws InvalidTargetInstancesException
     *         The target instance configuration is invalid. Possible causes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Configuration data for target instances was entered for an in-place deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The limit of 10 tags for a tag type was exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The combined length of the tag names exceeded the limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A specified tag is not currently applied to any instances.
     *         </p>
     *         </li>
     * @throws InvalidAutoRollbackConfigException
     *         The automatic rollback configuration was specified in an invalid format. For example, automatic rollback
     *         is enabled, but an invalid triggering event type or no event types were listed.
     * @throws InvalidLoadBalancerInfoException
     *         An invalid load balancer name, or no load balancer name, was specified.
     * @throws InvalidFileExistsBehaviorException
     *         An invalid fileExistsBehavior option was specified to determine how AWS CodeDeploy handles files or
     *         directories that already exist in a deployment target location, but weren't part of the previous
     *         successful deployment. Valid values include "DISALLOW," "OVERWRITE," and "RETAIN."
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Amazon EC2 Auto Scaling.
     * @throws InvalidAutoScalingGroupException
     *         The Auto Scaling group was specified in an invalid format or does not exist.
     * @throws ThrottlingException
     *         An API function was called too frequently.
     * @throws InvalidUpdateOutdatedInstancesOnlyValueException
     *         The UpdateOutdatedInstancesOnly value is invalid. For AWS Lambda deployments, <code>false</code> is
     *         expected. For EC2/On-premises deployments, <code>true</code> or <code>false</code> is expected.
     * @throws InvalidIgnoreApplicationStopFailuresValueException
     *         The IgnoreApplicationStopFailures value is invalid. For AWS Lambda deployments, <code>false</code> is
     *         expected. For EC2/On-premises deployments, <code>true</code> or <code>false</code> is expected.
     * @throws InvalidGitHubAccountTokenException
     *         The GitHub token is not valid.
     * @throws InvalidTrafficRoutingConfigurationException
     *         The configuration that specifies how traffic is routed during a deployment is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDeploymentResponse createDeployment(Consumer<CreateDeploymentRequest.Builder> createDeploymentRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            DeploymentGroupNameRequiredException, InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException,
            RevisionRequiredException, RevisionDoesNotExistException, InvalidRevisionException,
            InvalidDeploymentConfigNameException, DeploymentConfigDoesNotExistException, DescriptionTooLongException,
            DeploymentLimitExceededException, InvalidTargetInstancesException, InvalidAutoRollbackConfigException,
            InvalidLoadBalancerInfoException, InvalidFileExistsBehaviorException, InvalidRoleException,
            InvalidAutoScalingGroupException, ThrottlingException, InvalidUpdateOutdatedInstancesOnlyValueException,
            InvalidIgnoreApplicationStopFailuresValueException, InvalidGitHubAccountTokenException,
            InvalidTrafficRoutingConfigurationException, AwsServiceException, SdkClientException, CodeDeployException {
        return createDeployment(CreateDeploymentRequest.builder().applyMutation(createDeploymentRequest).build());
    }

    /**
     * <p>
     * Creates a deployment configuration.
     * </p>
     *
     * @param createDeploymentConfigRequest
     *        Represents the input of a <code>CreateDeploymentConfig</code> operation.
     * @return Result of the CreateDeploymentConfig operation returned by the service.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigNameRequiredException
     *         The deployment configuration name was not specified.
     * @throws DeploymentConfigAlreadyExistsException
     *         A deployment configuration with the specified name with the IAM user or AWS account already exists.
     * @throws InvalidMinimumHealthyHostValueException
     *         The minimum healthy instance value was specified in an invalid format.
     * @throws DeploymentConfigLimitExceededException
     *         The deployment configurations limit was exceeded.
     * @throws InvalidComputePlatformException
     *         The computePlatform is invalid. The computePlatform should be <code>Lambda</code>, <code>Server</code>,
     *         or <code>ECS</code>.
     * @throws InvalidTrafficRoutingConfigurationException
     *         The configuration that specifies how traffic is routed during a deployment is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.CreateDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeploymentConfigResponse createDeploymentConfig(CreateDeploymentConfigRequest createDeploymentConfigRequest)
            throws InvalidDeploymentConfigNameException, DeploymentConfigNameRequiredException,
            DeploymentConfigAlreadyExistsException, InvalidMinimumHealthyHostValueException,
            DeploymentConfigLimitExceededException, InvalidComputePlatformException, InvalidTrafficRoutingConfigurationException,
            AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a deployment configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentConfigRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDeploymentConfigRequest#builder()}
     * </p>
     *
     * @param createDeploymentConfigRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeploymentConfigInput.Builder} to create a
     *        request. Represents the input of a <code>CreateDeploymentConfig</code> operation.
     * @return Result of the CreateDeploymentConfig operation returned by the service.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigNameRequiredException
     *         The deployment configuration name was not specified.
     * @throws DeploymentConfigAlreadyExistsException
     *         A deployment configuration with the specified name with the IAM user or AWS account already exists.
     * @throws InvalidMinimumHealthyHostValueException
     *         The minimum healthy instance value was specified in an invalid format.
     * @throws DeploymentConfigLimitExceededException
     *         The deployment configurations limit was exceeded.
     * @throws InvalidComputePlatformException
     *         The computePlatform is invalid. The computePlatform should be <code>Lambda</code>, <code>Server</code>,
     *         or <code>ECS</code>.
     * @throws InvalidTrafficRoutingConfigurationException
     *         The configuration that specifies how traffic is routed during a deployment is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.CreateDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeploymentConfigResponse createDeploymentConfig(
            Consumer<CreateDeploymentConfigRequest.Builder> createDeploymentConfigRequest)
            throws InvalidDeploymentConfigNameException, DeploymentConfigNameRequiredException,
            DeploymentConfigAlreadyExistsException, InvalidMinimumHealthyHostValueException,
            DeploymentConfigLimitExceededException, InvalidComputePlatformException, InvalidTrafficRoutingConfigurationException,
            AwsServiceException, SdkClientException, CodeDeployException {
        return createDeploymentConfig(CreateDeploymentConfigRequest.builder().applyMutation(createDeploymentConfigRequest)
                .build());
    }

    /**
     * <p>
     * Creates a deployment group to which application revisions are deployed.
     * </p>
     *
     * @param createDeploymentGroupRequest
     *        Represents the input of a <code>CreateDeploymentGroup</code> operation.
     * @return Result of the CreateDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupAlreadyExistsException
     *         A deployment group with the specified name with the IAM user or AWS account already exists.
     * @throws InvalidEc2TagException
     *         The tag was specified in an invalid format.
     * @throws InvalidTagException
     *         The tag was specified in an invalid format.
     * @throws InvalidAutoScalingGroupException
     *         The Auto Scaling group was specified in an invalid format or does not exist.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the IAM user or AWS account.
     * @throws RoleRequiredException
     *         The role ID was not specified.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Amazon EC2 Auto Scaling.
     * @throws DeploymentGroupLimitExceededException
     *         The deployment groups limit was exceeded.
     * @throws LifecycleHookLimitExceededException
     *         The limit for lifecycle hooks was exceeded.
     * @throws InvalidTriggerConfigException
     *         The trigger was specified in an invalid format.
     * @throws TriggerTargetsLimitExceededException
     *         The maximum allowed number of triggers was exceeded.
     * @throws InvalidAlarmConfigException
     *         The format of the alarm configuration is invalid. Possible causes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the limit of 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled, but the alarm list is empty.
     *         </p>
     *         </li>
     * @throws AlarmsLimitExceededException
     *         The maximum number of alarms for a deployment group (10) was exceeded.
     * @throws InvalidAutoRollbackConfigException
     *         The automatic rollback configuration was specified in an invalid format. For example, automatic rollback
     *         is enabled, but an invalid triggering event type or no event types were listed.
     * @throws InvalidLoadBalancerInfoException
     *         An invalid load balancer name, or no load balancer name, was specified.
     * @throws InvalidDeploymentStyleException
     *         An invalid deployment style was specified. Valid deployment types include "IN_PLACE" and "BLUE_GREEN."
     *         Valid deployment options include "WITH_TRAFFIC_CONTROL" and "WITHOUT_TRAFFIC_CONTROL."
     * @throws InvalidBlueGreenDeploymentConfigurationException
     *         The configuration for the blue/green deployment group was provided in an invalid format. For information
     *         about deployment configuration format, see <a>CreateDeploymentConfig</a>.
     * @throws InvalidEc2TagCombinationException
     *         A call was submitted that specified both Ec2TagFilters and Ec2TagSet, but only one of these data types
     *         can be used in a single call.
     * @throws InvalidOnPremisesTagCombinationException
     *         A call was submitted that specified both OnPremisesTagFilters and OnPremisesTagSet, but only one of these
     *         data types can be used in a single call.
     * @throws TagSetListLimitExceededException
     *         The number of tag groups included in the tag set list exceeded the maximum allowed limit of 3.
     * @throws InvalidInputException
     *         The input was specified in an invalid format.
     * @throws ThrottlingException
     *         An API function was called too frequently.
     * @throws InvalidEcsServiceException
     *         The Amazon ECS service identifier is not valid.
     * @throws InvalidTargetGroupPairException
     *         A target group pair associated with this deployment is not valid.
     * @throws EcsServiceMappingLimitExceededException
     *         The Amazon ECS service is associated with more than one deployment groups. An Amazon ECS service can be
     *         associated with only one deployment group.
     * @throws InvalidTagsToAddException
     *         The specified tags are not valid.
     * @throws InvalidTrafficRoutingConfigurationException
     *         The configuration that specifies how traffic is routed during a deployment is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.CreateDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeploymentGroupResponse createDeploymentGroup(CreateDeploymentGroupRequest createDeploymentGroupRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            DeploymentGroupNameRequiredException, InvalidDeploymentGroupNameException, DeploymentGroupAlreadyExistsException,
            InvalidEc2TagException, InvalidTagException, InvalidAutoScalingGroupException, InvalidDeploymentConfigNameException,
            DeploymentConfigDoesNotExistException, RoleRequiredException, InvalidRoleException,
            DeploymentGroupLimitExceededException, LifecycleHookLimitExceededException, InvalidTriggerConfigException,
            TriggerTargetsLimitExceededException, InvalidAlarmConfigException, AlarmsLimitExceededException,
            InvalidAutoRollbackConfigException, InvalidLoadBalancerInfoException, InvalidDeploymentStyleException,
            InvalidBlueGreenDeploymentConfigurationException, InvalidEc2TagCombinationException,
            InvalidOnPremisesTagCombinationException, TagSetListLimitExceededException, InvalidInputException,
            ThrottlingException, InvalidEcsServiceException, InvalidTargetGroupPairException,
            EcsServiceMappingLimitExceededException, InvalidTagsToAddException, InvalidTrafficRoutingConfigurationException,
            AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a deployment group to which application revisions are deployed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDeploymentGroupRequest#builder()}
     * </p>
     *
     * @param createDeploymentGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeploymentGroupInput.Builder} to create a
     *        request. Represents the input of a <code>CreateDeploymentGroup</code> operation.
     * @return Result of the CreateDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupAlreadyExistsException
     *         A deployment group with the specified name with the IAM user or AWS account already exists.
     * @throws InvalidEc2TagException
     *         The tag was specified in an invalid format.
     * @throws InvalidTagException
     *         The tag was specified in an invalid format.
     * @throws InvalidAutoScalingGroupException
     *         The Auto Scaling group was specified in an invalid format or does not exist.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the IAM user or AWS account.
     * @throws RoleRequiredException
     *         The role ID was not specified.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Amazon EC2 Auto Scaling.
     * @throws DeploymentGroupLimitExceededException
     *         The deployment groups limit was exceeded.
     * @throws LifecycleHookLimitExceededException
     *         The limit for lifecycle hooks was exceeded.
     * @throws InvalidTriggerConfigException
     *         The trigger was specified in an invalid format.
     * @throws TriggerTargetsLimitExceededException
     *         The maximum allowed number of triggers was exceeded.
     * @throws InvalidAlarmConfigException
     *         The format of the alarm configuration is invalid. Possible causes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the limit of 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled, but the alarm list is empty.
     *         </p>
     *         </li>
     * @throws AlarmsLimitExceededException
     *         The maximum number of alarms for a deployment group (10) was exceeded.
     * @throws InvalidAutoRollbackConfigException
     *         The automatic rollback configuration was specified in an invalid format. For example, automatic rollback
     *         is enabled, but an invalid triggering event type or no event types were listed.
     * @throws InvalidLoadBalancerInfoException
     *         An invalid load balancer name, or no load balancer name, was specified.
     * @throws InvalidDeploymentStyleException
     *         An invalid deployment style was specified. Valid deployment types include "IN_PLACE" and "BLUE_GREEN."
     *         Valid deployment options include "WITH_TRAFFIC_CONTROL" and "WITHOUT_TRAFFIC_CONTROL."
     * @throws InvalidBlueGreenDeploymentConfigurationException
     *         The configuration for the blue/green deployment group was provided in an invalid format. For information
     *         about deployment configuration format, see <a>CreateDeploymentConfig</a>.
     * @throws InvalidEc2TagCombinationException
     *         A call was submitted that specified both Ec2TagFilters and Ec2TagSet, but only one of these data types
     *         can be used in a single call.
     * @throws InvalidOnPremisesTagCombinationException
     *         A call was submitted that specified both OnPremisesTagFilters and OnPremisesTagSet, but only one of these
     *         data types can be used in a single call.
     * @throws TagSetListLimitExceededException
     *         The number of tag groups included in the tag set list exceeded the maximum allowed limit of 3.
     * @throws InvalidInputException
     *         The input was specified in an invalid format.
     * @throws ThrottlingException
     *         An API function was called too frequently.
     * @throws InvalidEcsServiceException
     *         The Amazon ECS service identifier is not valid.
     * @throws InvalidTargetGroupPairException
     *         A target group pair associated with this deployment is not valid.
     * @throws EcsServiceMappingLimitExceededException
     *         The Amazon ECS service is associated with more than one deployment groups. An Amazon ECS service can be
     *         associated with only one deployment group.
     * @throws InvalidTagsToAddException
     *         The specified tags are not valid.
     * @throws InvalidTrafficRoutingConfigurationException
     *         The configuration that specifies how traffic is routed during a deployment is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.CreateDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeploymentGroupResponse createDeploymentGroup(
            Consumer<CreateDeploymentGroupRequest.Builder> createDeploymentGroupRequest) throws ApplicationNameRequiredException,
            InvalidApplicationNameException, ApplicationDoesNotExistException, DeploymentGroupNameRequiredException,
            InvalidDeploymentGroupNameException, DeploymentGroupAlreadyExistsException, InvalidEc2TagException,
            InvalidTagException, InvalidAutoScalingGroupException, InvalidDeploymentConfigNameException,
            DeploymentConfigDoesNotExistException, RoleRequiredException, InvalidRoleException,
            DeploymentGroupLimitExceededException, LifecycleHookLimitExceededException, InvalidTriggerConfigException,
            TriggerTargetsLimitExceededException, InvalidAlarmConfigException, AlarmsLimitExceededException,
            InvalidAutoRollbackConfigException, InvalidLoadBalancerInfoException, InvalidDeploymentStyleException,
            InvalidBlueGreenDeploymentConfigurationException, InvalidEc2TagCombinationException,
            InvalidOnPremisesTagCombinationException, TagSetListLimitExceededException, InvalidInputException,
            ThrottlingException, InvalidEcsServiceException, InvalidTargetGroupPairException,
            EcsServiceMappingLimitExceededException, InvalidTagsToAddException, InvalidTrafficRoutingConfigurationException,
            AwsServiceException, SdkClientException, CodeDeployException {
        return createDeploymentGroup(CreateDeploymentGroupRequest.builder().applyMutation(createDeploymentGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     *
     * @param deleteApplicationRequest
     *        Represents the input of a <code>DeleteApplication</code> operation.
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Amazon EC2 Auto Scaling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, InvalidRoleException, AwsServiceException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationInput.Builder} to create a request.
     *        Represents the input of a <code>DeleteApplication</code> operation.
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Amazon EC2 Auto Scaling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, InvalidRoleException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes a deployment configuration.
     * </p>
     * <note>
     * <p>
     * A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be
     * deleted.
     * </p>
     * </note>
     *
     * @param deleteDeploymentConfigRequest
     *        Represents the input of a <code>DeleteDeploymentConfig</code> operation.
     * @return Result of the DeleteDeploymentConfig operation returned by the service.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigNameRequiredException
     *         The deployment configuration name was not specified.
     * @throws DeploymentConfigInUseException
     *         The deployment configuration is still in use.
     * @throws InvalidOperationException
     *         An invalid operation was detected.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeleteDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDeploymentConfigResponse deleteDeploymentConfig(DeleteDeploymentConfigRequest deleteDeploymentConfigRequest)
            throws InvalidDeploymentConfigNameException, DeploymentConfigNameRequiredException, DeploymentConfigInUseException,
            InvalidOperationException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a deployment configuration.
     * </p>
     * <note>
     * <p>
     * A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be
     * deleted.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeploymentConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDeploymentConfigRequest#builder()}
     * </p>
     *
     * @param deleteDeploymentConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeploymentConfigInput.Builder} to create a
     *        request. Represents the input of a <code>DeleteDeploymentConfig</code> operation.
     * @return Result of the DeleteDeploymentConfig operation returned by the service.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigNameRequiredException
     *         The deployment configuration name was not specified.
     * @throws DeploymentConfigInUseException
     *         The deployment configuration is still in use.
     * @throws InvalidOperationException
     *         An invalid operation was detected.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeleteDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDeploymentConfigResponse deleteDeploymentConfig(
            Consumer<DeleteDeploymentConfigRequest.Builder> deleteDeploymentConfigRequest)
            throws InvalidDeploymentConfigNameException, DeploymentConfigNameRequiredException, DeploymentConfigInUseException,
            InvalidOperationException, AwsServiceException, SdkClientException, CodeDeployException {
        return deleteDeploymentConfig(DeleteDeploymentConfigRequest.builder().applyMutation(deleteDeploymentConfigRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a deployment group.
     * </p>
     *
     * @param deleteDeploymentGroupRequest
     *        Represents the input of a <code>DeleteDeploymentGroup</code> operation.
     * @return Result of the DeleteDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Amazon EC2 Auto Scaling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeleteDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDeploymentGroupResponse deleteDeploymentGroup(DeleteDeploymentGroupRequest deleteDeploymentGroupRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, DeploymentGroupNameRequiredException,
            InvalidDeploymentGroupNameException, InvalidRoleException, AwsServiceException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a deployment group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeploymentGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDeploymentGroupRequest#builder()}
     * </p>
     *
     * @param deleteDeploymentGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeploymentGroupInput.Builder} to create a
     *        request. Represents the input of a <code>DeleteDeploymentGroup</code> operation.
     * @return Result of the DeleteDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Amazon EC2 Auto Scaling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeleteDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDeploymentGroupResponse deleteDeploymentGroup(
            Consumer<DeleteDeploymentGroupRequest.Builder> deleteDeploymentGroupRequest) throws ApplicationNameRequiredException,
            InvalidApplicationNameException, DeploymentGroupNameRequiredException, InvalidDeploymentGroupNameException,
            InvalidRoleException, AwsServiceException, SdkClientException, CodeDeployException {
        return deleteDeploymentGroup(DeleteDeploymentGroupRequest.builder().applyMutation(deleteDeploymentGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a GitHub account connection.
     * </p>
     *
     * @param deleteGitHubAccountTokenRequest
     *        Represents the input of a <code>DeleteGitHubAccount</code> operation.
     * @return Result of the DeleteGitHubAccountToken operation returned by the service.
     * @throws GitHubAccountTokenNameRequiredException
     *         The call is missing a required GitHub account connection name.
     * @throws GitHubAccountTokenDoesNotExistException
     *         No GitHub account connection exists with the named specified in the call.
     * @throws InvalidGitHubAccountTokenNameException
     *         The format of the specified GitHub account connection name is invalid.
     * @throws ResourceValidationException
     *         The specified resource could not be validated.
     * @throws OperationNotSupportedException
     *         The API used does not support the deployment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeleteGitHubAccountToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteGitHubAccountToken"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGitHubAccountTokenResponse deleteGitHubAccountToken(
            DeleteGitHubAccountTokenRequest deleteGitHubAccountTokenRequest) throws GitHubAccountTokenNameRequiredException,
            GitHubAccountTokenDoesNotExistException, InvalidGitHubAccountTokenNameException, ResourceValidationException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a GitHub account connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGitHubAccountTokenRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteGitHubAccountTokenRequest#builder()}
     * </p>
     *
     * @param deleteGitHubAccountTokenRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGitHubAccountTokenInput.Builder} to create a
     *        request. Represents the input of a <code>DeleteGitHubAccount</code> operation.
     * @return Result of the DeleteGitHubAccountToken operation returned by the service.
     * @throws GitHubAccountTokenNameRequiredException
     *         The call is missing a required GitHub account connection name.
     * @throws GitHubAccountTokenDoesNotExistException
     *         No GitHub account connection exists with the named specified in the call.
     * @throws InvalidGitHubAccountTokenNameException
     *         The format of the specified GitHub account connection name is invalid.
     * @throws ResourceValidationException
     *         The specified resource could not be validated.
     * @throws OperationNotSupportedException
     *         The API used does not support the deployment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeleteGitHubAccountToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteGitHubAccountToken"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGitHubAccountTokenResponse deleteGitHubAccountToken(
            Consumer<DeleteGitHubAccountTokenRequest.Builder> deleteGitHubAccountTokenRequest)
            throws GitHubAccountTokenNameRequiredException, GitHubAccountTokenDoesNotExistException,
            InvalidGitHubAccountTokenNameException, ResourceValidationException, OperationNotSupportedException,
            AwsServiceException, SdkClientException, CodeDeployException {
        return deleteGitHubAccountToken(DeleteGitHubAccountTokenRequest.builder().applyMutation(deleteGitHubAccountTokenRequest)
                .build());
    }

    /**
     * <p>
     * Deletes resources linked to an external ID.
     * </p>
     *
     * @param deleteResourcesByExternalIdRequest
     * @return Result of the DeleteResourcesByExternalId operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeleteResourcesByExternalId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteResourcesByExternalId"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcesByExternalIdResponse deleteResourcesByExternalId(
            DeleteResourcesByExternalIdRequest deleteResourcesByExternalIdRequest) throws AwsServiceException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes resources linked to an external ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcesByExternalIdRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteResourcesByExternalIdRequest#builder()}
     * </p>
     *
     * @param deleteResourcesByExternalIdRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourcesByExternalIdInput.Builder} to create a
     *        request.
     * @return Result of the DeleteResourcesByExternalId operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeleteResourcesByExternalId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteResourcesByExternalId"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcesByExternalIdResponse deleteResourcesByExternalId(
            Consumer<DeleteResourcesByExternalIdRequest.Builder> deleteResourcesByExternalIdRequest) throws AwsServiceException,
            SdkClientException, CodeDeployException {
        return deleteResourcesByExternalId(DeleteResourcesByExternalIdRequest.builder()
                .applyMutation(deleteResourcesByExternalIdRequest).build());
    }

    /**
     * <p>
     * Deregisters an on-premises instance.
     * </p>
     *
     * @param deregisterOnPremisesInstanceRequest
     *        Represents the input of a <code>DeregisterOnPremisesInstance</code> operation.
     * @return Result of the DeregisterOnPremisesInstance operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeregisterOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeregisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterOnPremisesInstanceResponse deregisterOnPremisesInstance(
            DeregisterOnPremisesInstanceRequest deregisterOnPremisesInstanceRequest) throws InstanceNameRequiredException,
            InvalidInstanceNameException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters an on-premises instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterOnPremisesInstanceRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterOnPremisesInstanceRequest#builder()}
     * </p>
     *
     * @param deregisterOnPremisesInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterOnPremisesInstanceInput.Builder} to create a
     *        request. Represents the input of a <code>DeregisterOnPremisesInstance</code> operation.
     * @return Result of the DeregisterOnPremisesInstance operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeregisterOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeregisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterOnPremisesInstanceResponse deregisterOnPremisesInstance(
            Consumer<DeregisterOnPremisesInstanceRequest.Builder> deregisterOnPremisesInstanceRequest)
            throws InstanceNameRequiredException, InvalidInstanceNameException, AwsServiceException, SdkClientException,
            CodeDeployException {
        return deregisterOnPremisesInstance(DeregisterOnPremisesInstanceRequest.builder()
                .applyMutation(deregisterOnPremisesInstanceRequest).build());
    }

    /**
     * <p>
     * Gets information about an application.
     * </p>
     *
     * @param getApplicationRequest
     *        Represents the input of a <code>GetApplication</code> operation.
     * @return Result of the GetApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default GetApplicationResponse getApplication(GetApplicationRequest getApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationRequest.Builder} avoiding the need to
     * create one manually via {@link GetApplicationRequest#builder()}
     * </p>
     *
     * @param getApplicationRequest
     *        A {@link Consumer} that will call methods on {@link GetApplicationInput.Builder} to create a request.
     *        Represents the input of a <code>GetApplication</code> operation.
     * @return Result of the GetApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default GetApplicationResponse getApplication(Consumer<GetApplicationRequest.Builder> getApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            AwsServiceException, SdkClientException, CodeDeployException {
        return getApplication(GetApplicationRequest.builder().applyMutation(getApplicationRequest).build());
    }

    /**
     * <p>
     * Gets information about an application revision.
     * </p>
     *
     * @param getApplicationRevisionRequest
     *        Represents the input of a <code>GetApplicationRevision</code> operation.
     * @return Result of the GetApplicationRevision operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws RevisionDoesNotExistException
     *         The named revision does not exist with the IAM user or AWS account.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetApplicationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApplicationRevisionResponse getApplicationRevision(GetApplicationRevisionRequest getApplicationRevisionRequest)
            throws ApplicationDoesNotExistException, ApplicationNameRequiredException, InvalidApplicationNameException,
            RevisionDoesNotExistException, RevisionRequiredException, InvalidRevisionException, AwsServiceException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an application revision.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationRevisionRequest.Builder} avoiding the
     * need to create one manually via {@link GetApplicationRevisionRequest#builder()}
     * </p>
     *
     * @param getApplicationRevisionRequest
     *        A {@link Consumer} that will call methods on {@link GetApplicationRevisionInput.Builder} to create a
     *        request. Represents the input of a <code>GetApplicationRevision</code> operation.
     * @return Result of the GetApplicationRevision operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws RevisionDoesNotExistException
     *         The named revision does not exist with the IAM user or AWS account.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetApplicationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApplicationRevisionResponse getApplicationRevision(
            Consumer<GetApplicationRevisionRequest.Builder> getApplicationRevisionRequest)
            throws ApplicationDoesNotExistException, ApplicationNameRequiredException, InvalidApplicationNameException,
            RevisionDoesNotExistException, RevisionRequiredException, InvalidRevisionException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return getApplicationRevision(GetApplicationRevisionRequest.builder().applyMutation(getApplicationRevisionRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a deployment.
     * </p>
     * <note>
     * <p>
     * The <code>content</code> property of the <code>appSpecContent</code> object in the returned revision is always
     * null. Use <code>GetApplicationRevision</code> and the <code>sha256</code> property of the returned
     * <code>appSpecContent</code> object to get the content of the deployment’s AppSpec file.
     * </p>
     * </note>
     *
     * @param getDeploymentRequest
     *        Represents the input of a <code>GetDeployment</code> operation.
     * @return Result of the GetDeployment operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the IAM user or AWS account does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDeploymentResponse getDeployment(GetDeploymentRequest getDeploymentRequest) throws DeploymentIdRequiredException,
            InvalidDeploymentIdException, DeploymentDoesNotExistException, AwsServiceException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a deployment.
     * </p>
     * <note>
     * <p>
     * The <code>content</code> property of the <code>appSpecContent</code> object in the returned revision is always
     * null. Use <code>GetApplicationRevision</code> and the <code>sha256</code> property of the returned
     * <code>appSpecContent</code> object to get the content of the deployment’s AppSpec file.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentRequest#builder()}
     * </p>
     *
     * @param getDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link GetDeploymentInput.Builder} to create a request.
     *        Represents the input of a <code>GetDeployment</code> operation.
     * @return Result of the GetDeployment operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the IAM user or AWS account does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDeploymentResponse getDeployment(Consumer<GetDeploymentRequest.Builder> getDeploymentRequest)
            throws DeploymentIdRequiredException, InvalidDeploymentIdException, DeploymentDoesNotExistException,
            AwsServiceException, SdkClientException, CodeDeployException {
        return getDeployment(GetDeploymentRequest.builder().applyMutation(getDeploymentRequest).build());
    }

    /**
     * <p>
     * Gets information about a deployment configuration.
     * </p>
     *
     * @param getDeploymentConfigRequest
     *        Represents the input of a <code>GetDeploymentConfig</code> operation.
     * @return Result of the GetDeploymentConfig operation returned by the service.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigNameRequiredException
     *         The deployment configuration name was not specified.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the IAM user or AWS account.
     * @throws InvalidComputePlatformException
     *         The computePlatform is invalid. The computePlatform should be <code>Lambda</code>, <code>Server</code>,
     *         or <code>ECS</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeploymentConfigResponse getDeploymentConfig(GetDeploymentConfigRequest getDeploymentConfigRequest)
            throws InvalidDeploymentConfigNameException, DeploymentConfigNameRequiredException,
            DeploymentConfigDoesNotExistException, InvalidComputePlatformException, AwsServiceException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a deployment configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeploymentConfigRequest#builder()}
     * </p>
     *
     * @param getDeploymentConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetDeploymentConfigInput.Builder} to create a request.
     *        Represents the input of a <code>GetDeploymentConfig</code> operation.
     * @return Result of the GetDeploymentConfig operation returned by the service.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigNameRequiredException
     *         The deployment configuration name was not specified.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the IAM user or AWS account.
     * @throws InvalidComputePlatformException
     *         The computePlatform is invalid. The computePlatform should be <code>Lambda</code>, <code>Server</code>,
     *         or <code>ECS</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeploymentConfigResponse getDeploymentConfig(
            Consumer<GetDeploymentConfigRequest.Builder> getDeploymentConfigRequest) throws InvalidDeploymentConfigNameException,
            DeploymentConfigNameRequiredException, DeploymentConfigDoesNotExistException, InvalidComputePlatformException,
            AwsServiceException, SdkClientException, CodeDeployException {
        return getDeploymentConfig(GetDeploymentConfigRequest.builder().applyMutation(getDeploymentConfigRequest).build());
    }

    /**
     * <p>
     * Gets information about a deployment group.
     * </p>
     *
     * @param getDeploymentGroupRequest
     *        Represents the input of a <code>GetDeploymentGroup</code> operation.
     * @return Result of the GetDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the IAM user or AWS account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDeploymentGroupResponse getDeploymentGroup(GetDeploymentGroupRequest getDeploymentGroupRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            DeploymentGroupNameRequiredException, InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException,
            DeploymentConfigDoesNotExistException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a deployment group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentGroupRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeploymentGroupRequest#builder()}
     * </p>
     *
     * @param getDeploymentGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetDeploymentGroupInput.Builder} to create a request.
     *        Represents the input of a <code>GetDeploymentGroup</code> operation.
     * @return Result of the GetDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the IAM user or AWS account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDeploymentGroupResponse getDeploymentGroup(Consumer<GetDeploymentGroupRequest.Builder> getDeploymentGroupRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            DeploymentGroupNameRequiredException, InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException,
            DeploymentConfigDoesNotExistException, AwsServiceException, SdkClientException, CodeDeployException {
        return getDeploymentGroup(GetDeploymentGroupRequest.builder().applyMutation(getDeploymentGroupRequest).build());
    }

    /**
     * <p>
     * Returns information about a deployment target.
     * </p>
     *
     * @param getDeploymentTargetRequest
     * @return Result of the GetDeploymentTarget operation returned by the service.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the IAM user or AWS account does not exist.
     * @throws DeploymentNotStartedException
     *         The specified deployment has not started.
     * @throws DeploymentTargetIdRequiredException
     *         A deployment target ID was not provided.
     * @throws InvalidDeploymentTargetIdException
     *         The target ID provided was not valid.
     * @throws DeploymentTargetDoesNotExistException
     *         The provided target ID does not belong to the attempted deployment.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetDeploymentTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeploymentTargetResponse getDeploymentTarget(GetDeploymentTargetRequest getDeploymentTargetRequest)
            throws InvalidDeploymentIdException, DeploymentIdRequiredException, DeploymentDoesNotExistException,
            DeploymentNotStartedException, DeploymentTargetIdRequiredException, InvalidDeploymentTargetIdException,
            DeploymentTargetDoesNotExistException, InvalidInstanceNameException, AwsServiceException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a deployment target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentTargetRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeploymentTargetRequest#builder()}
     * </p>
     *
     * @param getDeploymentTargetRequest
     *        A {@link Consumer} that will call methods on {@link GetDeploymentTargetInput.Builder} to create a request.
     * @return Result of the GetDeploymentTarget operation returned by the service.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the IAM user or AWS account does not exist.
     * @throws DeploymentNotStartedException
     *         The specified deployment has not started.
     * @throws DeploymentTargetIdRequiredException
     *         A deployment target ID was not provided.
     * @throws InvalidDeploymentTargetIdException
     *         The target ID provided was not valid.
     * @throws DeploymentTargetDoesNotExistException
     *         The provided target ID does not belong to the attempted deployment.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetDeploymentTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeploymentTargetResponse getDeploymentTarget(
            Consumer<GetDeploymentTargetRequest.Builder> getDeploymentTargetRequest) throws InvalidDeploymentIdException,
            DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentNotStartedException,
            DeploymentTargetIdRequiredException, InvalidDeploymentTargetIdException, DeploymentTargetDoesNotExistException,
            InvalidInstanceNameException, AwsServiceException, SdkClientException, CodeDeployException {
        return getDeploymentTarget(GetDeploymentTargetRequest.builder().applyMutation(getDeploymentTargetRequest).build());
    }

    /**
     * <p>
     * Gets information about an on-premises instance.
     * </p>
     *
     * @param getOnPremisesInstanceRequest
     *        Represents the input of a <code>GetOnPremisesInstance</code> operation.
     * @return Result of the GetOnPremisesInstance operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InstanceNotRegisteredException
     *         The specified on-premises instance is not registered.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOnPremisesInstanceResponse getOnPremisesInstance(GetOnPremisesInstanceRequest getOnPremisesInstanceRequest)
            throws InstanceNameRequiredException, InstanceNotRegisteredException, InvalidInstanceNameException,
            AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an on-premises instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOnPremisesInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link GetOnPremisesInstanceRequest#builder()}
     * </p>
     *
     * @param getOnPremisesInstanceRequest
     *        A {@link Consumer} that will call methods on {@link GetOnPremisesInstanceInput.Builder} to create a
     *        request. Represents the input of a <code>GetOnPremisesInstance</code> operation.
     * @return Result of the GetOnPremisesInstance operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InstanceNotRegisteredException
     *         The specified on-premises instance is not registered.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOnPremisesInstanceResponse getOnPremisesInstance(
            Consumer<GetOnPremisesInstanceRequest.Builder> getOnPremisesInstanceRequest) throws InstanceNameRequiredException,
            InstanceNotRegisteredException, InvalidInstanceNameException, AwsServiceException, SdkClientException,
            CodeDeployException {
        return getOnPremisesInstance(GetOnPremisesInstanceRequest.builder().applyMutation(getOnPremisesInstanceRequest).build());
    }

    /**
     * <p>
     * Lists information about revisions for an application.
     * </p>
     *
     * @param listApplicationRevisionsRequest
     *        Represents the input of a <code>ListApplicationRevisions</code> operation.
     * @return Result of the ListApplicationRevisions operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws InvalidSortByException
     *         The column name to sort by is either not present or was specified in an invalid format.
     * @throws InvalidSortOrderException
     *         The sort order was specified in an invalid format.
     * @throws InvalidBucketNameFilterException
     *         The bucket name either doesn't exist or was specified in an invalid format.
     * @throws InvalidKeyPrefixFilterException
     *         The specified key prefix filter was specified in an invalid format.
     * @throws BucketNameFilterRequiredException
     *         A bucket name is required, but was not provided.
     * @throws InvalidDeployedStateFilterException
     *         The deployed state filter was specified in an invalid format.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationRevisionsResponse listApplicationRevisions(
            ListApplicationRevisionsRequest listApplicationRevisionsRequest) throws ApplicationDoesNotExistException,
            ApplicationNameRequiredException, InvalidApplicationNameException, InvalidSortByException, InvalidSortOrderException,
            InvalidBucketNameFilterException, InvalidKeyPrefixFilterException, BucketNameFilterRequiredException,
            InvalidDeployedStateFilterException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about revisions for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationRevisionsRequest#builder()}
     * </p>
     *
     * @param listApplicationRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationRevisionsInput.Builder} to create a
     *        request. Represents the input of a <code>ListApplicationRevisions</code> operation.
     * @return Result of the ListApplicationRevisions operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws InvalidSortByException
     *         The column name to sort by is either not present or was specified in an invalid format.
     * @throws InvalidSortOrderException
     *         The sort order was specified in an invalid format.
     * @throws InvalidBucketNameFilterException
     *         The bucket name either doesn't exist or was specified in an invalid format.
     * @throws InvalidKeyPrefixFilterException
     *         The specified key prefix filter was specified in an invalid format.
     * @throws BucketNameFilterRequiredException
     *         A bucket name is required, but was not provided.
     * @throws InvalidDeployedStateFilterException
     *         The deployed state filter was specified in an invalid format.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationRevisionsResponse listApplicationRevisions(
            Consumer<ListApplicationRevisionsRequest.Builder> listApplicationRevisionsRequest)
            throws ApplicationDoesNotExistException, ApplicationNameRequiredException, InvalidApplicationNameException,
            InvalidSortByException, InvalidSortOrderException, InvalidBucketNameFilterException, InvalidKeyPrefixFilterException,
            BucketNameFilterRequiredException, InvalidDeployedStateFilterException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, CodeDeployException {
        return listApplicationRevisions(ListApplicationRevisionsRequest.builder().applyMutation(listApplicationRevisionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists information about revisions for an application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationRevisions(software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationRevisionsIterable responses = client.listApplicationRevisionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codedeploy.paginators.ListApplicationRevisionsIterable responses = client
     *             .listApplicationRevisionsPaginator(request);
     *     for (software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationRevisionsIterable responses = client.listApplicationRevisionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationRevisions(software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationRevisionsRequest
     *        Represents the input of a <code>ListApplicationRevisions</code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws InvalidSortByException
     *         The column name to sort by is either not present or was specified in an invalid format.
     * @throws InvalidSortOrderException
     *         The sort order was specified in an invalid format.
     * @throws InvalidBucketNameFilterException
     *         The bucket name either doesn't exist or was specified in an invalid format.
     * @throws InvalidKeyPrefixFilterException
     *         The specified key prefix filter was specified in an invalid format.
     * @throws BucketNameFilterRequiredException
     *         A bucket name is required, but was not provided.
     * @throws InvalidDeployedStateFilterException
     *         The deployed state filter was specified in an invalid format.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationRevisionsIterable listApplicationRevisionsPaginator(
            ListApplicationRevisionsRequest listApplicationRevisionsRequest) throws ApplicationDoesNotExistException,
            ApplicationNameRequiredException, InvalidApplicationNameException, InvalidSortByException, InvalidSortOrderException,
            InvalidBucketNameFilterException, InvalidKeyPrefixFilterException, BucketNameFilterRequiredException,
            InvalidDeployedStateFilterException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about revisions for an application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationRevisions(software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationRevisionsIterable responses = client.listApplicationRevisionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codedeploy.paginators.ListApplicationRevisionsIterable responses = client
     *             .listApplicationRevisionsPaginator(request);
     *     for (software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationRevisionsIterable responses = client.listApplicationRevisionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationRevisions(software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationRevisionsRequest#builder()}
     * </p>
     *
     * @param listApplicationRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationRevisionsInput.Builder} to create a
     *        request. Represents the input of a <code>ListApplicationRevisions</code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws InvalidSortByException
     *         The column name to sort by is either not present or was specified in an invalid format.
     * @throws InvalidSortOrderException
     *         The sort order was specified in an invalid format.
     * @throws InvalidBucketNameFilterException
     *         The bucket name either doesn't exist or was specified in an invalid format.
     * @throws InvalidKeyPrefixFilterException
     *         The specified key prefix filter was specified in an invalid format.
     * @throws BucketNameFilterRequiredException
     *         A bucket name is required, but was not provided.
     * @throws InvalidDeployedStateFilterException
     *         The deployed state filter was specified in an invalid format.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationRevisionsIterable listApplicationRevisionsPaginator(
            Consumer<ListApplicationRevisionsRequest.Builder> listApplicationRevisionsRequest)
            throws ApplicationDoesNotExistException, ApplicationNameRequiredException, InvalidApplicationNameException,
            InvalidSortByException, InvalidSortOrderException, InvalidBucketNameFilterException, InvalidKeyPrefixFilterException,
            BucketNameFilterRequiredException, InvalidDeployedStateFilterException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, CodeDeployException {
        return listApplicationRevisionsPaginator(ListApplicationRevisionsRequest.builder()
                .applyMutation(listApplicationRevisionsRequest).build());
    }

    /**
     * <p>
     * Lists the applications registered with the IAM user or AWS account.
     * </p>
     *
     * @return Result of the ListApplications operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListApplications
     * @see #listApplications(ListApplicationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsResponse listApplications() throws InvalidNextTokenException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return listApplications(ListApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the applications registered with the IAM user or AWS account.
     * </p>
     *
     * @param listApplicationsRequest
     *        Represents the input of a <code>ListApplications</code> operation.
     * @return Result of the ListApplications operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the applications registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationsInput.Builder} to create a request.
     *        Represents the input of a <code>ListApplications</code> operation.
     * @return Result of the ListApplications operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsResponse listApplications(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, CodeDeployException {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists the applications registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListApplications
     * @see #listApplicationsPaginator(ListApplicationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator() throws InvalidNextTokenException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return listApplicationsPaginator(ListApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the applications registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     *        Represents the input of a <code>ListApplications</code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the applications registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationsInput.Builder} to create a request.
     *        Represents the input of a <code>ListApplications</code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, CodeDeployException {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists the deployment configurations with the IAM user or AWS account.
     * </p>
     *
     * @return Result of the ListDeploymentConfigs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeploymentConfigs
     * @see #listDeploymentConfigs(ListDeploymentConfigsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentConfigsResponse listDeploymentConfigs() throws InvalidNextTokenException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return listDeploymentConfigs(ListDeploymentConfigsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the deployment configurations with the IAM user or AWS account.
     * </p>
     *
     * @param listDeploymentConfigsRequest
     *        Represents the input of a <code>ListDeploymentConfigs</code> operation.
     * @return Result of the ListDeploymentConfigs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeploymentConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentConfigsResponse listDeploymentConfigs(ListDeploymentConfigsRequest listDeploymentConfigsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployment configurations with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentConfigsRequest#builder()}
     * </p>
     *
     * @param listDeploymentConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentConfigsInput.Builder} to create a
     *        request. Represents the input of a <code>ListDeploymentConfigs</code> operation.
     * @return Result of the ListDeploymentConfigs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeploymentConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentConfigsResponse listDeploymentConfigs(
            Consumer<ListDeploymentConfigsRequest.Builder> listDeploymentConfigsRequest) throws InvalidNextTokenException,
            AwsServiceException, SdkClientException, CodeDeployException {
        return listDeploymentConfigs(ListDeploymentConfigsRequest.builder().applyMutation(listDeploymentConfigsRequest).build());
    }

    /**
     * <p>
     * Lists the deployment configurations with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentConfigs(software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsIterable responses = client.listDeploymentConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsIterable responses = client
     *             .listDeploymentConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsIterable responses = client.listDeploymentConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentConfigs(software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeploymentConfigs
     * @see #listDeploymentConfigsPaginator(ListDeploymentConfigsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentConfigsIterable listDeploymentConfigsPaginator() throws InvalidNextTokenException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return listDeploymentConfigsPaginator(ListDeploymentConfigsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the deployment configurations with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentConfigs(software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsIterable responses = client.listDeploymentConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsIterable responses = client
     *             .listDeploymentConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsIterable responses = client.listDeploymentConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentConfigs(software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeploymentConfigsRequest
     *        Represents the input of a <code>ListDeploymentConfigs</code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeploymentConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentConfigsIterable listDeploymentConfigsPaginator(ListDeploymentConfigsRequest listDeploymentConfigsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployment configurations with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentConfigs(software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsIterable responses = client.listDeploymentConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsIterable responses = client
     *             .listDeploymentConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentConfigsIterable responses = client.listDeploymentConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentConfigs(software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentConfigsRequest#builder()}
     * </p>
     *
     * @param listDeploymentConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentConfigsInput.Builder} to create a
     *        request. Represents the input of a <code>ListDeploymentConfigs</code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeploymentConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentConfigsIterable listDeploymentConfigsPaginator(
            Consumer<ListDeploymentConfigsRequest.Builder> listDeploymentConfigsRequest) throws InvalidNextTokenException,
            AwsServiceException, SdkClientException, CodeDeployException {
        return listDeploymentConfigsPaginator(ListDeploymentConfigsRequest.builder().applyMutation(listDeploymentConfigsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the deployment groups for an application registered with the IAM user or AWS account.
     * </p>
     *
     * @param listDeploymentGroupsRequest
     *        Represents the input of a <code>ListDeploymentGroups</code> operation.
     * @return Result of the ListDeploymentGroups operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeploymentGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentGroupsResponse listDeploymentGroups(ListDeploymentGroupsRequest listDeploymentGroupsRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployment groups for an application registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentGroupsRequest#builder()}
     * </p>
     *
     * @param listDeploymentGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentGroupsInput.Builder} to create a
     *        request. Represents the input of a <code>ListDeploymentGroups</code> operation.
     * @return Result of the ListDeploymentGroups operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeploymentGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentGroupsResponse listDeploymentGroups(
            Consumer<ListDeploymentGroupsRequest.Builder> listDeploymentGroupsRequest) throws ApplicationNameRequiredException,
            InvalidApplicationNameException, ApplicationDoesNotExistException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return listDeploymentGroups(ListDeploymentGroupsRequest.builder().applyMutation(listDeploymentGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the deployment groups for an application registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentGroups(software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentGroupsIterable responses = client.listDeploymentGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentGroupsIterable responses = client
     *             .listDeploymentGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentGroupsIterable responses = client.listDeploymentGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentGroups(software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeploymentGroupsRequest
     *        Represents the input of a <code>ListDeploymentGroups</code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeploymentGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentGroupsIterable listDeploymentGroupsPaginator(ListDeploymentGroupsRequest listDeploymentGroupsRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployment groups for an application registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentGroups(software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentGroupsIterable responses = client.listDeploymentGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentGroupsIterable responses = client
     *             .listDeploymentGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentGroupsIterable responses = client.listDeploymentGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentGroups(software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentGroupsRequest#builder()}
     * </p>
     *
     * @param listDeploymentGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentGroupsInput.Builder} to create a
     *        request. Represents the input of a <code>ListDeploymentGroups</code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeploymentGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentGroupsIterable listDeploymentGroupsPaginator(
            Consumer<ListDeploymentGroupsRequest.Builder> listDeploymentGroupsRequest) throws ApplicationNameRequiredException,
            InvalidApplicationNameException, ApplicationDoesNotExistException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return listDeploymentGroupsPaginator(ListDeploymentGroupsRequest.builder().applyMutation(listDeploymentGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns an array of target IDs that are associated a deployment.
     * </p>
     *
     * @param listDeploymentTargetsRequest
     * @return Result of the ListDeploymentTargets operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the IAM user or AWS account does not exist.
     * @throws DeploymentNotStartedException
     *         The specified deployment has not started.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws InvalidInstanceStatusException
     *         The specified instance status does not exist.
     * @throws InvalidInstanceTypeException
     *         An invalid instance type was specified for instances in a blue/green deployment. Valid values include
     *         "Blue" for an original environment and "Green" for a replacement environment.
     * @throws InvalidDeploymentInstanceTypeException
     *         An instance type was specified for an in-place deployment. Instance types are supported for blue/green
     *         deployments only.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeploymentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentTargetsResponse listDeploymentTargets(ListDeploymentTargetsRequest listDeploymentTargetsRequest)
            throws DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentNotStartedException,
            InvalidNextTokenException, InvalidDeploymentIdException, InvalidInstanceStatusException,
            InvalidInstanceTypeException, InvalidDeploymentInstanceTypeException, AwsServiceException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of target IDs that are associated a deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentTargetsRequest#builder()}
     * </p>
     *
     * @param listDeploymentTargetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentTargetsInput.Builder} to create a
     *        request.
     * @return Result of the ListDeploymentTargets operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the IAM user or AWS account does not exist.
     * @throws DeploymentNotStartedException
     *         The specified deployment has not started.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws InvalidInstanceStatusException
     *         The specified instance status does not exist.
     * @throws InvalidInstanceTypeException
     *         An invalid instance type was specified for instances in a blue/green deployment. Valid values include
     *         "Blue" for an original environment and "Green" for a replacement environment.
     * @throws InvalidDeploymentInstanceTypeException
     *         An instance type was specified for an in-place deployment. Instance types are supported for blue/green
     *         deployments only.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeploymentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentTargetsResponse listDeploymentTargets(
            Consumer<ListDeploymentTargetsRequest.Builder> listDeploymentTargetsRequest) throws DeploymentIdRequiredException,
            DeploymentDoesNotExistException, DeploymentNotStartedException, InvalidNextTokenException,
            InvalidDeploymentIdException, InvalidInstanceStatusException, InvalidInstanceTypeException,
            InvalidDeploymentInstanceTypeException, AwsServiceException, SdkClientException, CodeDeployException {
        return listDeploymentTargets(ListDeploymentTargetsRequest.builder().applyMutation(listDeploymentTargetsRequest).build());
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.
     * </p>
     *
     * @return Result of the ListDeployments operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidTimeRangeException
     *         The specified time range was specified in an invalid format.
     * @throws InvalidDeploymentStatusException
     *         The specified deployment status doesn't exist or cannot be determined.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws InvalidExternalIdException
     *         The external ID was specified in an invalid format.
     * @throws InvalidInputException
     *         The input was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeployments
     * @see #listDeployments(ListDeploymentsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsResponse listDeployments() throws ApplicationNameRequiredException, InvalidApplicationNameException,
            ApplicationDoesNotExistException, InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException,
            DeploymentGroupNameRequiredException, InvalidTimeRangeException, InvalidDeploymentStatusException,
            InvalidNextTokenException, InvalidExternalIdException, InvalidInputException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return listDeployments(ListDeploymentsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.
     * </p>
     *
     * @param listDeploymentsRequest
     *        Represents the input of a <code>ListDeployments</code> operation.
     * @return Result of the ListDeployments operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidTimeRangeException
     *         The specified time range was specified in an invalid format.
     * @throws InvalidDeploymentStatusException
     *         The specified deployment status doesn't exist or cannot be determined.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws InvalidExternalIdException
     *         The external ID was specified in an invalid format.
     * @throws InvalidInputException
     *         The input was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsResponse listDeployments(ListDeploymentsRequest listDeploymentsRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException, DeploymentGroupNameRequiredException,
            InvalidTimeRangeException, InvalidDeploymentStatusException, InvalidNextTokenException, InvalidExternalIdException,
            InvalidInputException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeploymentsRequest#builder()}
     * </p>
     *
     * @param listDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentsInput.Builder} to create a request.
     *        Represents the input of a <code>ListDeployments</code> operation.
     * @return Result of the ListDeployments operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidTimeRangeException
     *         The specified time range was specified in an invalid format.
     * @throws InvalidDeploymentStatusException
     *         The specified deployment status doesn't exist or cannot be determined.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws InvalidExternalIdException
     *         The external ID was specified in an invalid format.
     * @throws InvalidInputException
     *         The input was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsResponse listDeployments(Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException, DeploymentGroupNameRequiredException,
            InvalidTimeRangeException, InvalidDeploymentStatusException, InvalidNextTokenException, InvalidExternalIdException,
            InvalidInputException, AwsServiceException, SdkClientException, CodeDeployException {
        return listDeployments(ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest).build());
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeployments(software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsIterable responses = client.listDeploymentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsIterable responses = client
     *             .listDeploymentsPaginator(request);
     *     for (software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsIterable responses = client.listDeploymentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeployments(software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidTimeRangeException
     *         The specified time range was specified in an invalid format.
     * @throws InvalidDeploymentStatusException
     *         The specified deployment status doesn't exist or cannot be determined.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws InvalidExternalIdException
     *         The external ID was specified in an invalid format.
     * @throws InvalidInputException
     *         The input was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeployments
     * @see #listDeploymentsPaginator(ListDeploymentsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsIterable listDeploymentsPaginator() throws ApplicationNameRequiredException,
            InvalidApplicationNameException, ApplicationDoesNotExistException, InvalidDeploymentGroupNameException,
            DeploymentGroupDoesNotExistException, DeploymentGroupNameRequiredException, InvalidTimeRangeException,
            InvalidDeploymentStatusException, InvalidNextTokenException, InvalidExternalIdException, InvalidInputException,
            AwsServiceException, SdkClientException, CodeDeployException {
        return listDeploymentsPaginator(ListDeploymentsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeployments(software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsIterable responses = client.listDeploymentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsIterable responses = client
     *             .listDeploymentsPaginator(request);
     *     for (software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsIterable responses = client.listDeploymentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeployments(software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest)} operation.</b>
     * </p>
     *
     * @param listDeploymentsRequest
     *        Represents the input of a <code>ListDeployments</code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidTimeRangeException
     *         The specified time range was specified in an invalid format.
     * @throws InvalidDeploymentStatusException
     *         The specified deployment status doesn't exist or cannot be determined.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws InvalidExternalIdException
     *         The external ID was specified in an invalid format.
     * @throws InvalidInputException
     *         The input was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsIterable listDeploymentsPaginator(ListDeploymentsRequest listDeploymentsRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException, DeploymentGroupNameRequiredException,
            InvalidTimeRangeException, InvalidDeploymentStatusException, InvalidNextTokenException, InvalidExternalIdException,
            InvalidInputException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeployments(software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsIterable responses = client.listDeploymentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsIterable responses = client
     *             .listDeploymentsPaginator(request);
     *     for (software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codedeploy.paginators.ListDeploymentsIterable responses = client.listDeploymentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeployments(software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeploymentsRequest#builder()}
     * </p>
     *
     * @param listDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentsInput.Builder} to create a request.
     *        Represents the input of a <code>ListDeployments</code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidTimeRangeException
     *         The specified time range was specified in an invalid format.
     * @throws InvalidDeploymentStatusException
     *         The specified deployment status doesn't exist or cannot be determined.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws InvalidExternalIdException
     *         The external ID was specified in an invalid format.
     * @throws InvalidInputException
     *         The input was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsIterable listDeploymentsPaginator(Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException, DeploymentGroupNameRequiredException,
            InvalidTimeRangeException, InvalidDeploymentStatusException, InvalidNextTokenException, InvalidExternalIdException,
            InvalidInputException, AwsServiceException, SdkClientException, CodeDeployException {
        return listDeploymentsPaginator(ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest).build());
    }

    /**
     * <p>
     * Lists the names of stored connections to GitHub accounts.
     * </p>
     *
     * @return Result of the ListGitHubAccountTokenNames operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws ResourceValidationException
     *         The specified resource could not be validated.
     * @throws OperationNotSupportedException
     *         The API used does not support the deployment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListGitHubAccountTokenNames
     * @see #listGitHubAccountTokenNames(ListGitHubAccountTokenNamesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListGitHubAccountTokenNames"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGitHubAccountTokenNamesResponse listGitHubAccountTokenNames() throws InvalidNextTokenException,
            ResourceValidationException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            CodeDeployException {
        return listGitHubAccountTokenNames(ListGitHubAccountTokenNamesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the names of stored connections to GitHub accounts.
     * </p>
     *
     * @param listGitHubAccountTokenNamesRequest
     *        Represents the input of a <code>ListGitHubAccountTokenNames</code> operation.
     * @return Result of the ListGitHubAccountTokenNames operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws ResourceValidationException
     *         The specified resource could not be validated.
     * @throws OperationNotSupportedException
     *         The API used does not support the deployment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListGitHubAccountTokenNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListGitHubAccountTokenNames"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGitHubAccountTokenNamesResponse listGitHubAccountTokenNames(
            ListGitHubAccountTokenNamesRequest listGitHubAccountTokenNamesRequest) throws InvalidNextTokenException,
            ResourceValidationException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the names of stored connections to GitHub accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGitHubAccountTokenNamesRequest.Builder}
     * avoiding the need to create one manually via {@link ListGitHubAccountTokenNamesRequest#builder()}
     * </p>
     *
     * @param listGitHubAccountTokenNamesRequest
     *        A {@link Consumer} that will call methods on {@link ListGitHubAccountTokenNamesInput.Builder} to create a
     *        request. Represents the input of a <code>ListGitHubAccountTokenNames</code> operation.
     * @return Result of the ListGitHubAccountTokenNames operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws ResourceValidationException
     *         The specified resource could not be validated.
     * @throws OperationNotSupportedException
     *         The API used does not support the deployment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListGitHubAccountTokenNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListGitHubAccountTokenNames"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGitHubAccountTokenNamesResponse listGitHubAccountTokenNames(
            Consumer<ListGitHubAccountTokenNamesRequest.Builder> listGitHubAccountTokenNamesRequest)
            throws InvalidNextTokenException, ResourceValidationException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return listGitHubAccountTokenNames(ListGitHubAccountTokenNamesRequest.builder()
                .applyMutation(listGitHubAccountTokenNamesRequest).build());
    }

    /**
     * <p>
     * Gets a list of names for one or more on-premises instances.
     * </p>
     * <p>
     * Unless otherwise specified, both registered and deregistered on-premises instance names are listed. To list only
     * registered or deregistered on-premises instance names, use the registration status parameter.
     * </p>
     *
     * @return Result of the ListOnPremisesInstances operation returned by the service.
     * @throws InvalidRegistrationStatusException
     *         The registration status was specified in an invalid format.
     * @throws InvalidTagFilterException
     *         The tag filter was specified in an invalid format.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListOnPremisesInstances
     * @see #listOnPremisesInstances(ListOnPremisesInstancesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOnPremisesInstancesResponse listOnPremisesInstances() throws InvalidRegistrationStatusException,
            InvalidTagFilterException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodeDeployException {
        return listOnPremisesInstances(ListOnPremisesInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of names for one or more on-premises instances.
     * </p>
     * <p>
     * Unless otherwise specified, both registered and deregistered on-premises instance names are listed. To list only
     * registered or deregistered on-premises instance names, use the registration status parameter.
     * </p>
     *
     * @param listOnPremisesInstancesRequest
     *        Represents the input of a <code>ListOnPremisesInstances</code> operation.
     * @return Result of the ListOnPremisesInstances operation returned by the service.
     * @throws InvalidRegistrationStatusException
     *         The registration status was specified in an invalid format.
     * @throws InvalidTagFilterException
     *         The tag filter was specified in an invalid format.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOnPremisesInstancesResponse listOnPremisesInstances(ListOnPremisesInstancesRequest listOnPremisesInstancesRequest)
            throws InvalidRegistrationStatusException, InvalidTagFilterException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of names for one or more on-premises instances.
     * </p>
     * <p>
     * Unless otherwise specified, both registered and deregistered on-premises instance names are listed. To list only
     * registered or deregistered on-premises instance names, use the registration status parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOnPremisesInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListOnPremisesInstancesRequest#builder()}
     * </p>
     *
     * @param listOnPremisesInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListOnPremisesInstancesInput.Builder} to create a
     *        request. Represents the input of a <code>ListOnPremisesInstances</code> operation.
     * @return Result of the ListOnPremisesInstances operation returned by the service.
     * @throws InvalidRegistrationStatusException
     *         The registration status was specified in an invalid format.
     * @throws InvalidTagFilterException
     *         The tag filter was specified in an invalid format.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOnPremisesInstancesResponse listOnPremisesInstances(
            Consumer<ListOnPremisesInstancesRequest.Builder> listOnPremisesInstancesRequest)
            throws InvalidRegistrationStatusException, InvalidTagFilterException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return listOnPremisesInstances(ListOnPremisesInstancesRequest.builder().applyMutation(listOnPremisesInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of tags for the resource identified by a specified Amazon Resource Name (ARN). Tags are used to
     * organize and categorize your CodeDeploy resources.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ArnNotSupportedException
     *         The specified ARN is not supported. For example, it might be an ARN for a resource that is not expected.
     * @throws InvalidArnException
     *         The specified ARN is not in a valid format.
     * @throws ResourceArnRequiredException
     *         The ARN of a resource is required, but was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ArnNotSupportedException, InvalidArnException, ResourceArnRequiredException, AwsServiceException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for the resource identified by a specified Amazon Resource Name (ARN). Tags are used to
     * organize and categorize your CodeDeploy resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceInput.Builder} to create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ArnNotSupportedException
     *         The specified ARN is not supported. For example, it might be an ARN for a resource that is not expected.
     * @throws InvalidArnException
     *         The specified ARN is not in a valid format.
     * @throws ResourceArnRequiredException
     *         The ARN of a resource is required, but was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ArnNotSupportedException,
            InvalidArnException, ResourceArnRequiredException, AwsServiceException, SdkClientException, CodeDeployException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Sets the result of a Lambda validation function. The function validates lifecycle hooks during a deployment that
     * uses the AWS Lambda or Amazon ECS compute platform. For AWS Lambda deployments, the available lifecycle hooks are
     * <code>BeforeAllowTraffic</code> and <code>AfterAllowTraffic</code>. For Amazon ECS deployments, the available
     * lifecycle hooks are <code>BeforeInstall</code>, <code>AfterInstall</code>, <code>AfterAllowTestTraffic</code>,
     * <code>BeforeAllowTraffic</code>, and <code>AfterAllowTraffic</code>. Lambda validation functions return
     * <code>Succeeded</code> or <code>Failed</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-lambda"
     * >AppSpec 'hooks' Section for an AWS Lambda Deployment </a> and <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs"
     * >AppSpec 'hooks' Section for an Amazon ECS Deployment</a>.
     * </p>
     *
     * @param putLifecycleEventHookExecutionStatusRequest
     * @return Result of the PutLifecycleEventHookExecutionStatus operation returned by the service.
     * @throws InvalidLifecycleEventHookExecutionStatusException
     *         The result of a Lambda validation function that verifies a lifecycle event is invalid. It should return
     *         <code>Succeeded</code> or <code>Failed</code>.
     * @throws InvalidLifecycleEventHookExecutionIdException
     *         A lifecycle event hook is invalid. Review the <code>hooks</code> section in your AppSpec file to ensure
     *         the lifecycle events and <code>hooks</code> functions are valid.
     * @throws LifecycleEventAlreadyCompletedException
     *         An attempt to return the status of an already completed lifecycle event occurred.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the IAM user or AWS account does not exist.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws UnsupportedActionForDeploymentTypeException
     *         A call was submitted that is not supported for the specified deployment type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.PutLifecycleEventHookExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/PutLifecycleEventHookExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default PutLifecycleEventHookExecutionStatusResponse putLifecycleEventHookExecutionStatus(
            PutLifecycleEventHookExecutionStatusRequest putLifecycleEventHookExecutionStatusRequest)
            throws InvalidLifecycleEventHookExecutionStatusException, InvalidLifecycleEventHookExecutionIdException,
            LifecycleEventAlreadyCompletedException, DeploymentIdRequiredException, DeploymentDoesNotExistException,
            InvalidDeploymentIdException, UnsupportedActionForDeploymentTypeException, AwsServiceException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the result of a Lambda validation function. The function validates lifecycle hooks during a deployment that
     * uses the AWS Lambda or Amazon ECS compute platform. For AWS Lambda deployments, the available lifecycle hooks are
     * <code>BeforeAllowTraffic</code> and <code>AfterAllowTraffic</code>. For Amazon ECS deployments, the available
     * lifecycle hooks are <code>BeforeInstall</code>, <code>AfterInstall</code>, <code>AfterAllowTestTraffic</code>,
     * <code>BeforeAllowTraffic</code>, and <code>AfterAllowTraffic</code>. Lambda validation functions return
     * <code>Succeeded</code> or <code>Failed</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-lambda"
     * >AppSpec 'hooks' Section for an AWS Lambda Deployment </a> and <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs"
     * >AppSpec 'hooks' Section for an Amazon ECS Deployment</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutLifecycleEventHookExecutionStatusRequest.Builder} avoiding the need to create one manually via
     * {@link PutLifecycleEventHookExecutionStatusRequest#builder()}
     * </p>
     *
     * @param putLifecycleEventHookExecutionStatusRequest
     *        A {@link Consumer} that will call methods on {@link PutLifecycleEventHookExecutionStatusInput.Builder} to
     *        create a request.
     * @return Result of the PutLifecycleEventHookExecutionStatus operation returned by the service.
     * @throws InvalidLifecycleEventHookExecutionStatusException
     *         The result of a Lambda validation function that verifies a lifecycle event is invalid. It should return
     *         <code>Succeeded</code> or <code>Failed</code>.
     * @throws InvalidLifecycleEventHookExecutionIdException
     *         A lifecycle event hook is invalid. Review the <code>hooks</code> section in your AppSpec file to ensure
     *         the lifecycle events and <code>hooks</code> functions are valid.
     * @throws LifecycleEventAlreadyCompletedException
     *         An attempt to return the status of an already completed lifecycle event occurred.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the IAM user or AWS account does not exist.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws UnsupportedActionForDeploymentTypeException
     *         A call was submitted that is not supported for the specified deployment type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.PutLifecycleEventHookExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/PutLifecycleEventHookExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default PutLifecycleEventHookExecutionStatusResponse putLifecycleEventHookExecutionStatus(
            Consumer<PutLifecycleEventHookExecutionStatusRequest.Builder> putLifecycleEventHookExecutionStatusRequest)
            throws InvalidLifecycleEventHookExecutionStatusException, InvalidLifecycleEventHookExecutionIdException,
            LifecycleEventAlreadyCompletedException, DeploymentIdRequiredException, DeploymentDoesNotExistException,
            InvalidDeploymentIdException, UnsupportedActionForDeploymentTypeException, AwsServiceException, SdkClientException,
            CodeDeployException {
        return putLifecycleEventHookExecutionStatus(PutLifecycleEventHookExecutionStatusRequest.builder()
                .applyMutation(putLifecycleEventHookExecutionStatusRequest).build());
    }

    /**
     * <p>
     * Registers with AWS CodeDeploy a revision for the specified application.
     * </p>
     *
     * @param registerApplicationRevisionRequest
     *        Represents the input of a RegisterApplicationRevision operation.
     * @return Result of the RegisterApplicationRevision operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws DescriptionTooLongException
     *         The description is too long.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.RegisterApplicationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterApplicationRevisionResponse registerApplicationRevision(
            RegisterApplicationRevisionRequest registerApplicationRevisionRequest) throws ApplicationDoesNotExistException,
            ApplicationNameRequiredException, InvalidApplicationNameException, DescriptionTooLongException,
            RevisionRequiredException, InvalidRevisionException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers with AWS CodeDeploy a revision for the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterApplicationRevisionRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterApplicationRevisionRequest#builder()}
     * </p>
     *
     * @param registerApplicationRevisionRequest
     *        A {@link Consumer} that will call methods on {@link RegisterApplicationRevisionInput.Builder} to create a
     *        request. Represents the input of a RegisterApplicationRevision operation.
     * @return Result of the RegisterApplicationRevision operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws DescriptionTooLongException
     *         The description is too long.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.RegisterApplicationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterApplicationRevisionResponse registerApplicationRevision(
            Consumer<RegisterApplicationRevisionRequest.Builder> registerApplicationRevisionRequest)
            throws ApplicationDoesNotExistException, ApplicationNameRequiredException, InvalidApplicationNameException,
            DescriptionTooLongException, RevisionRequiredException, InvalidRevisionException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return registerApplicationRevision(RegisterApplicationRevisionRequest.builder()
                .applyMutation(registerApplicationRevisionRequest).build());
    }

    /**
     * <p>
     * Registers an on-premises instance.
     * </p>
     * <note>
     * <p>
     * Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.
     * </p>
     * </note>
     *
     * @param registerOnPremisesInstanceRequest
     *        Represents the input of the register on-premises instance operation.
     * @return Result of the RegisterOnPremisesInstance operation returned by the service.
     * @throws InstanceNameAlreadyRegisteredException
     *         The specified on-premises instance name is already registered.
     * @throws IamArnRequiredException
     *         No IAM ARN was included in the request. You must use an IAM session ARN or IAM user ARN in the request.
     * @throws IamSessionArnAlreadyRegisteredException
     *         The request included an IAM session ARN that has already been used to register a different instance.
     * @throws IamUserArnAlreadyRegisteredException
     *         The specified IAM user ARN is already registered with an on-premises instance.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws IamUserArnRequiredException
     *         An IAM user ARN was not specified.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws InvalidIamSessionArnException
     *         The IAM session ARN was specified in an invalid format.
     * @throws InvalidIamUserArnException
     *         The IAM user ARN was specified in an invalid format.
     * @throws MultipleIamArnsProvidedException
     *         Both an IAM user ARN and an IAM session ARN were included in the request. Use only one ARN type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.RegisterOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterOnPremisesInstanceResponse registerOnPremisesInstance(
            RegisterOnPremisesInstanceRequest registerOnPremisesInstanceRequest) throws InstanceNameAlreadyRegisteredException,
            IamArnRequiredException, IamSessionArnAlreadyRegisteredException, IamUserArnAlreadyRegisteredException,
            InstanceNameRequiredException, IamUserArnRequiredException, InvalidInstanceNameException,
            InvalidIamSessionArnException, InvalidIamUserArnException, MultipleIamArnsProvidedException, AwsServiceException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an on-premises instance.
     * </p>
     * <note>
     * <p>
     * Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterOnPremisesInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link RegisterOnPremisesInstanceRequest#builder()}
     * </p>
     *
     * @param registerOnPremisesInstanceRequest
     *        A {@link Consumer} that will call methods on {@link RegisterOnPremisesInstanceInput.Builder} to create a
     *        request. Represents the input of the register on-premises instance operation.
     * @return Result of the RegisterOnPremisesInstance operation returned by the service.
     * @throws InstanceNameAlreadyRegisteredException
     *         The specified on-premises instance name is already registered.
     * @throws IamArnRequiredException
     *         No IAM ARN was included in the request. You must use an IAM session ARN or IAM user ARN in the request.
     * @throws IamSessionArnAlreadyRegisteredException
     *         The request included an IAM session ARN that has already been used to register a different instance.
     * @throws IamUserArnAlreadyRegisteredException
     *         The specified IAM user ARN is already registered with an on-premises instance.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws IamUserArnRequiredException
     *         An IAM user ARN was not specified.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws InvalidIamSessionArnException
     *         The IAM session ARN was specified in an invalid format.
     * @throws InvalidIamUserArnException
     *         The IAM user ARN was specified in an invalid format.
     * @throws MultipleIamArnsProvidedException
     *         Both an IAM user ARN and an IAM session ARN were included in the request. Use only one ARN type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.RegisterOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterOnPremisesInstanceResponse registerOnPremisesInstance(
            Consumer<RegisterOnPremisesInstanceRequest.Builder> registerOnPremisesInstanceRequest)
            throws InstanceNameAlreadyRegisteredException, IamArnRequiredException, IamSessionArnAlreadyRegisteredException,
            IamUserArnAlreadyRegisteredException, InstanceNameRequiredException, IamUserArnRequiredException,
            InvalidInstanceNameException, InvalidIamSessionArnException, InvalidIamUserArnException,
            MultipleIamArnsProvidedException, AwsServiceException, SdkClientException, CodeDeployException {
        return registerOnPremisesInstance(RegisterOnPremisesInstanceRequest.builder()
                .applyMutation(registerOnPremisesInstanceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from one or more on-premises instances.
     * </p>
     *
     * @param removeTagsFromOnPremisesInstancesRequest
     *        Represents the input of a <code>RemoveTagsFromOnPremisesInstances</code> operation.
     * @return Result of the RemoveTagsFromOnPremisesInstances operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws TagRequiredException
     *         A tag was not specified.
     * @throws InvalidTagException
     *         The tag was specified in an invalid format.
     * @throws TagLimitExceededException
     *         The maximum allowed number of tags was exceeded.
     * @throws InstanceLimitExceededException
     *         The maximum number of allowed on-premises instances in a single call was exceeded.
     * @throws InstanceNotRegisteredException
     *         The specified on-premises instance is not registered.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.RemoveTagsFromOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RemoveTagsFromOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveTagsFromOnPremisesInstancesResponse removeTagsFromOnPremisesInstances(
            RemoveTagsFromOnPremisesInstancesRequest removeTagsFromOnPremisesInstancesRequest)
            throws InstanceNameRequiredException, InvalidInstanceNameException, TagRequiredException, InvalidTagException,
            TagLimitExceededException, InstanceLimitExceededException, InstanceNotRegisteredException, AwsServiceException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from one or more on-premises instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsFromOnPremisesInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveTagsFromOnPremisesInstancesRequest#builder()}
     * </p>
     *
     * @param removeTagsFromOnPremisesInstancesRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTagsFromOnPremisesInstancesInput.Builder} to
     *        create a request. Represents the input of a <code>RemoveTagsFromOnPremisesInstances</code> operation.
     * @return Result of the RemoveTagsFromOnPremisesInstances operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws TagRequiredException
     *         A tag was not specified.
     * @throws InvalidTagException
     *         The tag was specified in an invalid format.
     * @throws TagLimitExceededException
     *         The maximum allowed number of tags was exceeded.
     * @throws InstanceLimitExceededException
     *         The maximum number of allowed on-premises instances in a single call was exceeded.
     * @throws InstanceNotRegisteredException
     *         The specified on-premises instance is not registered.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.RemoveTagsFromOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RemoveTagsFromOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveTagsFromOnPremisesInstancesResponse removeTagsFromOnPremisesInstances(
            Consumer<RemoveTagsFromOnPremisesInstancesRequest.Builder> removeTagsFromOnPremisesInstancesRequest)
            throws InstanceNameRequiredException, InvalidInstanceNameException, TagRequiredException, InvalidTagException,
            TagLimitExceededException, InstanceLimitExceededException, InstanceNotRegisteredException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return removeTagsFromOnPremisesInstances(RemoveTagsFromOnPremisesInstancesRequest.builder()
                .applyMutation(removeTagsFromOnPremisesInstancesRequest).build());
    }

    /**
     * <p>
     * Attempts to stop an ongoing deployment.
     * </p>
     *
     * @param stopDeploymentRequest
     *        Represents the input of a <code>StopDeployment</code> operation.
     * @return Result of the StopDeployment operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the IAM user or AWS account does not exist.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws DeploymentAlreadyCompletedException
     *         The deployment is already complete.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws UnsupportedActionForDeploymentTypeException
     *         A call was submitted that is not supported for the specified deployment type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.StopDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/StopDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default StopDeploymentResponse stopDeployment(StopDeploymentRequest stopDeploymentRequest)
            throws DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentGroupDoesNotExistException,
            DeploymentAlreadyCompletedException, InvalidDeploymentIdException, UnsupportedActionForDeploymentTypeException,
            AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to stop an ongoing deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDeploymentRequest.Builder} avoiding the need to
     * create one manually via {@link StopDeploymentRequest#builder()}
     * </p>
     *
     * @param stopDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link StopDeploymentInput.Builder} to create a request.
     *        Represents the input of a <code>StopDeployment</code> operation.
     * @return Result of the StopDeployment operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the IAM user or AWS account does not exist.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws DeploymentAlreadyCompletedException
     *         The deployment is already complete.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws UnsupportedActionForDeploymentTypeException
     *         A call was submitted that is not supported for the specified deployment type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.StopDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/StopDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default StopDeploymentResponse stopDeployment(Consumer<StopDeploymentRequest.Builder> stopDeploymentRequest)
            throws DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentGroupDoesNotExistException,
            DeploymentAlreadyCompletedException, InvalidDeploymentIdException, UnsupportedActionForDeploymentTypeException,
            AwsServiceException, SdkClientException, CodeDeployException {
        return stopDeployment(StopDeploymentRequest.builder().applyMutation(stopDeploymentRequest).build());
    }

    /**
     * <p>
     * Associates the list of tags in the input <code>Tags</code> parameter with the resource identified by the
     * <code>ResourceArn</code> input parameter.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceArnRequiredException
     *         The ARN of a resource is required, but was not found.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the IAM user or AWS account.
     * @throws TagRequiredException
     *         A tag was not specified.
     * @throws InvalidTagsToAddException
     *         The specified tags are not valid.
     * @throws ArnNotSupportedException
     *         The specified ARN is not supported. For example, it might be an ARN for a resource that is not expected.
     * @throws InvalidArnException
     *         The specified ARN is not in a valid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceArnRequiredException,
            ApplicationDoesNotExistException, DeploymentGroupDoesNotExistException, DeploymentConfigDoesNotExistException,
            TagRequiredException, InvalidTagsToAddException, ArnNotSupportedException, InvalidArnException, AwsServiceException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the list of tags in the input <code>Tags</code> parameter with the resource identified by the
     * <code>ResourceArn</code> input parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceInput.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceArnRequiredException
     *         The ARN of a resource is required, but was not found.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the IAM user or AWS account.
     * @throws TagRequiredException
     *         A tag was not specified.
     * @throws InvalidTagsToAddException
     *         The specified tags are not valid.
     * @throws ArnNotSupportedException
     *         The specified ARN is not supported. For example, it might be an ARN for a resource that is not expected.
     * @throws InvalidArnException
     *         The specified ARN is not in a valid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceArnRequiredException, ApplicationDoesNotExistException, DeploymentGroupDoesNotExistException,
            DeploymentConfigDoesNotExistException, TagRequiredException, InvalidTagsToAddException, ArnNotSupportedException,
            InvalidArnException, AwsServiceException, SdkClientException, CodeDeployException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Disassociates a resource from a list of tags. The resource is identified by the <code>ResourceArn</code> input
     * parameter. The tags are identified by the list of keys in the <code>TagKeys</code> input parameter.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceArnRequiredException
     *         The ARN of a resource is required, but was not found.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the IAM user or AWS account.
     * @throws TagRequiredException
     *         A tag was not specified.
     * @throws InvalidTagsToAddException
     *         The specified tags are not valid.
     * @throws ArnNotSupportedException
     *         The specified ARN is not supported. For example, it might be an ARN for a resource that is not expected.
     * @throws InvalidArnException
     *         The specified ARN is not in a valid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceArnRequiredException,
            ApplicationDoesNotExistException, DeploymentGroupDoesNotExistException, DeploymentConfigDoesNotExistException,
            TagRequiredException, InvalidTagsToAddException, ArnNotSupportedException, InvalidArnException, AwsServiceException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a resource from a list of tags. The resource is identified by the <code>ResourceArn</code> input
     * parameter. The tags are identified by the list of keys in the <code>TagKeys</code> input parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceInput.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceArnRequiredException
     *         The ARN of a resource is required, but was not found.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the IAM user or AWS account.
     * @throws TagRequiredException
     *         A tag was not specified.
     * @throws InvalidTagsToAddException
     *         The specified tags are not valid.
     * @throws ArnNotSupportedException
     *         The specified ARN is not supported. For example, it might be an ARN for a resource that is not expected.
     * @throws InvalidArnException
     *         The specified ARN is not in a valid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceArnRequiredException, ApplicationDoesNotExistException, DeploymentGroupDoesNotExistException,
            DeploymentConfigDoesNotExistException, TagRequiredException, InvalidTagsToAddException, ArnNotSupportedException,
            InvalidArnException, AwsServiceException, SdkClientException, CodeDeployException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Changes the name of an application.
     * </p>
     *
     * @param updateApplicationRequest
     *        Represents the input of an <code>UpdateApplication</code> operation.
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationAlreadyExistsException
     *         An application with the specified name with the IAM user or AWS account already exists.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationAlreadyExistsException,
            ApplicationDoesNotExistException, AwsServiceException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the name of an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationInput.Builder} to create a request.
     *        Represents the input of an <code>UpdateApplication</code> operation.
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationAlreadyExistsException
     *         An application with the specified name with the IAM user or AWS account already exists.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationAlreadyExistsException,
            ApplicationDoesNotExistException, AwsServiceException, SdkClientException, CodeDeployException {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Changes information about a deployment group.
     * </p>
     *
     * @param updateDeploymentGroupRequest
     *        Represents the input of an <code>UpdateDeploymentGroup</code> operation.
     * @return Result of the UpdateDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupAlreadyExistsException
     *         A deployment group with the specified name with the IAM user or AWS account already exists.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws InvalidEc2TagException
     *         The tag was specified in an invalid format.
     * @throws InvalidTagException
     *         The tag was specified in an invalid format.
     * @throws InvalidAutoScalingGroupException
     *         The Auto Scaling group was specified in an invalid format or does not exist.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the IAM user or AWS account.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Amazon EC2 Auto Scaling.
     * @throws LifecycleHookLimitExceededException
     *         The limit for lifecycle hooks was exceeded.
     * @throws InvalidTriggerConfigException
     *         The trigger was specified in an invalid format.
     * @throws TriggerTargetsLimitExceededException
     *         The maximum allowed number of triggers was exceeded.
     * @throws InvalidAlarmConfigException
     *         The format of the alarm configuration is invalid. Possible causes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the limit of 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled, but the alarm list is empty.
     *         </p>
     *         </li>
     * @throws AlarmsLimitExceededException
     *         The maximum number of alarms for a deployment group (10) was exceeded.
     * @throws InvalidAutoRollbackConfigException
     *         The automatic rollback configuration was specified in an invalid format. For example, automatic rollback
     *         is enabled, but an invalid triggering event type or no event types were listed.
     * @throws InvalidLoadBalancerInfoException
     *         An invalid load balancer name, or no load balancer name, was specified.
     * @throws InvalidDeploymentStyleException
     *         An invalid deployment style was specified. Valid deployment types include "IN_PLACE" and "BLUE_GREEN."
     *         Valid deployment options include "WITH_TRAFFIC_CONTROL" and "WITHOUT_TRAFFIC_CONTROL."
     * @throws InvalidBlueGreenDeploymentConfigurationException
     *         The configuration for the blue/green deployment group was provided in an invalid format. For information
     *         about deployment configuration format, see <a>CreateDeploymentConfig</a>.
     * @throws InvalidEc2TagCombinationException
     *         A call was submitted that specified both Ec2TagFilters and Ec2TagSet, but only one of these data types
     *         can be used in a single call.
     * @throws InvalidOnPremisesTagCombinationException
     *         A call was submitted that specified both OnPremisesTagFilters and OnPremisesTagSet, but only one of these
     *         data types can be used in a single call.
     * @throws TagSetListLimitExceededException
     *         The number of tag groups included in the tag set list exceeded the maximum allowed limit of 3.
     * @throws InvalidInputException
     *         The input was specified in an invalid format.
     * @throws ThrottlingException
     *         An API function was called too frequently.
     * @throws InvalidEcsServiceException
     *         The Amazon ECS service identifier is not valid.
     * @throws InvalidTargetGroupPairException
     *         A target group pair associated with this deployment is not valid.
     * @throws EcsServiceMappingLimitExceededException
     *         The Amazon ECS service is associated with more than one deployment groups. An Amazon ECS service can be
     *         associated with only one deployment group.
     * @throws InvalidTrafficRoutingConfigurationException
     *         The configuration that specifies how traffic is routed during a deployment is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.UpdateDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDeploymentGroupResponse updateDeploymentGroup(UpdateDeploymentGroupRequest updateDeploymentGroupRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            InvalidDeploymentGroupNameException, DeploymentGroupAlreadyExistsException, DeploymentGroupNameRequiredException,
            DeploymentGroupDoesNotExistException, InvalidEc2TagException, InvalidTagException, InvalidAutoScalingGroupException,
            InvalidDeploymentConfigNameException, DeploymentConfigDoesNotExistException, InvalidRoleException,
            LifecycleHookLimitExceededException, InvalidTriggerConfigException, TriggerTargetsLimitExceededException,
            InvalidAlarmConfigException, AlarmsLimitExceededException, InvalidAutoRollbackConfigException,
            InvalidLoadBalancerInfoException, InvalidDeploymentStyleException, InvalidBlueGreenDeploymentConfigurationException,
            InvalidEc2TagCombinationException, InvalidOnPremisesTagCombinationException, TagSetListLimitExceededException,
            InvalidInputException, ThrottlingException, InvalidEcsServiceException, InvalidTargetGroupPairException,
            EcsServiceMappingLimitExceededException, InvalidTrafficRoutingConfigurationException, AwsServiceException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about a deployment group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeploymentGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDeploymentGroupRequest#builder()}
     * </p>
     *
     * @param updateDeploymentGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDeploymentGroupInput.Builder} to create a
     *        request. Represents the input of an <code>UpdateDeploymentGroup</code> operation.
     * @return Result of the UpdateDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the IAM user or AWS account.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupAlreadyExistsException
     *         A deployment group with the specified name with the IAM user or AWS account already exists.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the IAM user or AWS account does not exist.
     * @throws InvalidEc2TagException
     *         The tag was specified in an invalid format.
     * @throws InvalidTagException
     *         The tag was specified in an invalid format.
     * @throws InvalidAutoScalingGroupException
     *         The Auto Scaling group was specified in an invalid format or does not exist.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the IAM user or AWS account.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Amazon EC2 Auto Scaling.
     * @throws LifecycleHookLimitExceededException
     *         The limit for lifecycle hooks was exceeded.
     * @throws InvalidTriggerConfigException
     *         The trigger was specified in an invalid format.
     * @throws TriggerTargetsLimitExceededException
     *         The maximum allowed number of triggers was exceeded.
     * @throws InvalidAlarmConfigException
     *         The format of the alarm configuration is invalid. Possible causes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the limit of 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled, but the alarm list is empty.
     *         </p>
     *         </li>
     * @throws AlarmsLimitExceededException
     *         The maximum number of alarms for a deployment group (10) was exceeded.
     * @throws InvalidAutoRollbackConfigException
     *         The automatic rollback configuration was specified in an invalid format. For example, automatic rollback
     *         is enabled, but an invalid triggering event type or no event types were listed.
     * @throws InvalidLoadBalancerInfoException
     *         An invalid load balancer name, or no load balancer name, was specified.
     * @throws InvalidDeploymentStyleException
     *         An invalid deployment style was specified. Valid deployment types include "IN_PLACE" and "BLUE_GREEN."
     *         Valid deployment options include "WITH_TRAFFIC_CONTROL" and "WITHOUT_TRAFFIC_CONTROL."
     * @throws InvalidBlueGreenDeploymentConfigurationException
     *         The configuration for the blue/green deployment group was provided in an invalid format. For information
     *         about deployment configuration format, see <a>CreateDeploymentConfig</a>.
     * @throws InvalidEc2TagCombinationException
     *         A call was submitted that specified both Ec2TagFilters and Ec2TagSet, but only one of these data types
     *         can be used in a single call.
     * @throws InvalidOnPremisesTagCombinationException
     *         A call was submitted that specified both OnPremisesTagFilters and OnPremisesTagSet, but only one of these
     *         data types can be used in a single call.
     * @throws TagSetListLimitExceededException
     *         The number of tag groups included in the tag set list exceeded the maximum allowed limit of 3.
     * @throws InvalidInputException
     *         The input was specified in an invalid format.
     * @throws ThrottlingException
     *         An API function was called too frequently.
     * @throws InvalidEcsServiceException
     *         The Amazon ECS service identifier is not valid.
     * @throws InvalidTargetGroupPairException
     *         A target group pair associated with this deployment is not valid.
     * @throws EcsServiceMappingLimitExceededException
     *         The Amazon ECS service is associated with more than one deployment groups. An Amazon ECS service can be
     *         associated with only one deployment group.
     * @throws InvalidTrafficRoutingConfigurationException
     *         The configuration that specifies how traffic is routed during a deployment is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.UpdateDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDeploymentGroupResponse updateDeploymentGroup(
            Consumer<UpdateDeploymentGroupRequest.Builder> updateDeploymentGroupRequest) throws ApplicationNameRequiredException,
            InvalidApplicationNameException, ApplicationDoesNotExistException, InvalidDeploymentGroupNameException,
            DeploymentGroupAlreadyExistsException, DeploymentGroupNameRequiredException, DeploymentGroupDoesNotExistException,
            InvalidEc2TagException, InvalidTagException, InvalidAutoScalingGroupException, InvalidDeploymentConfigNameException,
            DeploymentConfigDoesNotExistException, InvalidRoleException, LifecycleHookLimitExceededException,
            InvalidTriggerConfigException, TriggerTargetsLimitExceededException, InvalidAlarmConfigException,
            AlarmsLimitExceededException, InvalidAutoRollbackConfigException, InvalidLoadBalancerInfoException,
            InvalidDeploymentStyleException, InvalidBlueGreenDeploymentConfigurationException, InvalidEc2TagCombinationException,
            InvalidOnPremisesTagCombinationException, TagSetListLimitExceededException, InvalidInputException,
            ThrottlingException, InvalidEcsServiceException, InvalidTargetGroupPairException,
            EcsServiceMappingLimitExceededException, InvalidTrafficRoutingConfigurationException, AwsServiceException,
            SdkClientException, CodeDeployException {
        return updateDeploymentGroup(UpdateDeploymentGroupRequest.builder().applyMutation(updateDeploymentGroupRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    /**
     * Create an instance of {@link CodeDeployWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link CodeDeployWaiter}
     */
    default CodeDeployWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}
