/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeconnections.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProviderType {
    BITBUCKET("Bitbucket"),
    GIT_HUB("GitHub"),
    GIT_HUB_ENTERPRISE_SERVER("GitHubEnterpriseServer"),
    GIT_LAB("GitLab"),
    GIT_LAB_SELF_MANAGED("GitLabSelfManaged"),
    AZURE_DEV_OPS("AzureDevOps"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProviderType> VALUE_MAP;
    private final String value;

    private ProviderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProviderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProviderType> knownValues() {
        EnumSet<ProviderType> knownValues = EnumSet.allOf(ProviderType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProviderType.class, ProviderType::toString);
    }
}

