/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeconnections.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeconnections.CodeConnectionsAsyncClient;
import software.amazon.awssdk.services.codeconnections.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeconnections.model.ListSyncConfigurationsRequest;
import software.amazon.awssdk.services.codeconnections.model.ListSyncConfigurationsResponse;

public class ListSyncConfigurationsPublisher
implements SdkPublisher<ListSyncConfigurationsResponse> {
    private final CodeConnectionsAsyncClient client;
    private final ListSyncConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSyncConfigurationsPublisher(CodeConnectionsAsyncClient client, ListSyncConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSyncConfigurationsPublisher(CodeConnectionsAsyncClient client, ListSyncConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSyncConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSyncConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSyncConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListSyncConfigurationsResponse> {
        private ListSyncConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSyncConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSyncConfigurationsResponse> nextPage(ListSyncConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListSyncConfigurationsPublisher.this.client.listSyncConfigurations(ListSyncConfigurationsPublisher.this.firstRequest);
            }
            return ListSyncConfigurationsPublisher.this.client.listSyncConfigurations((ListSyncConfigurationsRequest)((Object)ListSyncConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

