/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitClient;
import software.amazon.awssdk.services.codecommit.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest;
import software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesResponse;

public class ListApprovalRuleTemplatesIterable
implements SdkIterable<ListApprovalRuleTemplatesResponse> {
    private final CodeCommitClient client;
    private final ListApprovalRuleTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApprovalRuleTemplatesIterable(CodeCommitClient client, ListApprovalRuleTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApprovalRuleTemplatesResponseFetcher();
    }

    public Iterator<ListApprovalRuleTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListApprovalRuleTemplatesResponseFetcher
    implements SyncPageFetcher<ListApprovalRuleTemplatesResponse> {
        private ListApprovalRuleTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListApprovalRuleTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApprovalRuleTemplatesResponse nextPage(ListApprovalRuleTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListApprovalRuleTemplatesIterable.this.client.listApprovalRuleTemplates(ListApprovalRuleTemplatesIterable.this.firstRequest);
            }
            return ListApprovalRuleTemplatesIterable.this.client.listApprovalRuleTemplates((ListApprovalRuleTemplatesRequest)((Object)ListApprovalRuleTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

