/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApprovalState {
    APPROVE("APPROVE"),
    REVOKE("REVOKE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApprovalState> VALUE_MAP;
    private final String value;

    private ApprovalState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApprovalState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApprovalState> knownValues() {
        EnumSet<ApprovalState> knownValues = EnumSet.allOf(ApprovalState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApprovalState.class, ApprovalState::toString);
    }
}

