/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the reaction values provided by users on a comment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReactionForComment implements SdkPojo, Serializable,
        ToCopyableBuilder<ReactionForComment.Builder, ReactionForComment> {
    private static final SdkField<ReactionValueFormats> REACTION_FIELD = SdkField
            .<ReactionValueFormats> builder(MarshallingType.SDK_POJO).memberName("reaction")
            .getter(getter(ReactionForComment::reaction)).setter(setter(Builder::reaction))
            .constructor(ReactionValueFormats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reaction").build()).build();

    private static final SdkField<List<String>> REACTION_USERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("reactionUsers")
            .getter(getter(ReactionForComment::reactionUsers))
            .setter(setter(Builder::reactionUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reactionUsers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> REACTIONS_FROM_DELETED_USERS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("reactionsFromDeletedUsersCount")
            .getter(getter(ReactionForComment::reactionsFromDeletedUsersCount))
            .setter(setter(Builder::reactionsFromDeletedUsersCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reactionsFromDeletedUsersCount")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REACTION_FIELD,
            REACTION_USERS_FIELD, REACTIONS_FROM_DELETED_USERS_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final ReactionValueFormats reaction;

    private final List<String> reactionUsers;

    private final Integer reactionsFromDeletedUsersCount;

    private ReactionForComment(BuilderImpl builder) {
        this.reaction = builder.reaction;
        this.reactionUsers = builder.reactionUsers;
        this.reactionsFromDeletedUsersCount = builder.reactionsFromDeletedUsersCount;
    }

    /**
     * <p>
     * The reaction for a specified comment.
     * </p>
     * 
     * @return The reaction for a specified comment.
     */
    public final ReactionValueFormats reaction() {
        return reaction;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReactionUsers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReactionUsers() {
        return reactionUsers != null && !(reactionUsers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of users who have provided reactions to the comment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReactionUsers} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of users who have provided reactions to the comment.
     */
    public final List<String> reactionUsers() {
        return reactionUsers;
    }

    /**
     * <p>
     * A numerical count of users who reacted with the specified emoji whose identities have been subsequently deleted
     * from IAM. While these IAM users or roles no longer exist, the reactions might still appear in total reaction
     * counts.
     * </p>
     * 
     * @return A numerical count of users who reacted with the specified emoji whose identities have been subsequently
     *         deleted from IAM. While these IAM users or roles no longer exist, the reactions might still appear in
     *         total reaction counts.
     */
    public final Integer reactionsFromDeletedUsersCount() {
        return reactionsFromDeletedUsersCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reaction());
        hashCode = 31 * hashCode + Objects.hashCode(hasReactionUsers() ? reactionUsers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reactionsFromDeletedUsersCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReactionForComment)) {
            return false;
        }
        ReactionForComment other = (ReactionForComment) obj;
        return Objects.equals(reaction(), other.reaction()) && hasReactionUsers() == other.hasReactionUsers()
                && Objects.equals(reactionUsers(), other.reactionUsers())
                && Objects.equals(reactionsFromDeletedUsersCount(), other.reactionsFromDeletedUsersCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReactionForComment").add("Reaction", reaction())
                .add("ReactionUsers", hasReactionUsers() ? reactionUsers() : null)
                .add("ReactionsFromDeletedUsersCount", reactionsFromDeletedUsersCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reaction":
            return Optional.ofNullable(clazz.cast(reaction()));
        case "reactionUsers":
            return Optional.ofNullable(clazz.cast(reactionUsers()));
        case "reactionsFromDeletedUsersCount":
            return Optional.ofNullable(clazz.cast(reactionsFromDeletedUsersCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReactionForComment, T> g) {
        return obj -> g.apply((ReactionForComment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReactionForComment> {
        /**
         * <p>
         * The reaction for a specified comment.
         * </p>
         * 
         * @param reaction
         *        The reaction for a specified comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reaction(ReactionValueFormats reaction);

        /**
         * <p>
         * The reaction for a specified comment.
         * </p>
         * This is a convenience that creates an instance of the {@link ReactionValueFormats.Builder} avoiding the need
         * to create one manually via {@link ReactionValueFormats#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReactionValueFormats.Builder#build()} is called immediately and
         * its result is passed to {@link #reaction(ReactionValueFormats)}.
         * 
         * @param reaction
         *        a consumer that will call methods on {@link ReactionValueFormats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reaction(ReactionValueFormats)
         */
        default Builder reaction(Consumer<ReactionValueFormats.Builder> reaction) {
            return reaction(ReactionValueFormats.builder().applyMutation(reaction).build());
        }

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of users who have provided reactions to the comment.
         * </p>
         * 
         * @param reactionUsers
         *        The Amazon Resource Names (ARNs) of users who have provided reactions to the comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactionUsers(Collection<String> reactionUsers);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of users who have provided reactions to the comment.
         * </p>
         * 
         * @param reactionUsers
         *        The Amazon Resource Names (ARNs) of users who have provided reactions to the comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactionUsers(String... reactionUsers);

        /**
         * <p>
         * A numerical count of users who reacted with the specified emoji whose identities have been subsequently
         * deleted from IAM. While these IAM users or roles no longer exist, the reactions might still appear in total
         * reaction counts.
         * </p>
         * 
         * @param reactionsFromDeletedUsersCount
         *        A numerical count of users who reacted with the specified emoji whose identities have been
         *        subsequently deleted from IAM. While these IAM users or roles no longer exist, the reactions might
         *        still appear in total reaction counts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactionsFromDeletedUsersCount(Integer reactionsFromDeletedUsersCount);
    }

    static final class BuilderImpl implements Builder {
        private ReactionValueFormats reaction;

        private List<String> reactionUsers = DefaultSdkAutoConstructList.getInstance();

        private Integer reactionsFromDeletedUsersCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ReactionForComment model) {
            reaction(model.reaction);
            reactionUsers(model.reactionUsers);
            reactionsFromDeletedUsersCount(model.reactionsFromDeletedUsersCount);
        }

        public final ReactionValueFormats.Builder getReaction() {
            return reaction != null ? reaction.toBuilder() : null;
        }

        public final void setReaction(ReactionValueFormats.BuilderImpl reaction) {
            this.reaction = reaction != null ? reaction.build() : null;
        }

        @Override
        @Transient
        public final Builder reaction(ReactionValueFormats reaction) {
            this.reaction = reaction;
            return this;
        }

        public final Collection<String> getReactionUsers() {
            if (reactionUsers instanceof SdkAutoConstructList) {
                return null;
            }
            return reactionUsers;
        }

        public final void setReactionUsers(Collection<String> reactionUsers) {
            this.reactionUsers = ReactionUsersListCopier.copy(reactionUsers);
        }

        @Override
        @Transient
        public final Builder reactionUsers(Collection<String> reactionUsers) {
            this.reactionUsers = ReactionUsersListCopier.copy(reactionUsers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reactionUsers(String... reactionUsers) {
            reactionUsers(Arrays.asList(reactionUsers));
            return this;
        }

        public final Integer getReactionsFromDeletedUsersCount() {
            return reactionsFromDeletedUsersCount;
        }

        public final void setReactionsFromDeletedUsersCount(Integer reactionsFromDeletedUsersCount) {
            this.reactionsFromDeletedUsersCount = reactionsFromDeletedUsersCount;
        }

        @Override
        @Transient
        public final Builder reactionsFromDeletedUsersCount(Integer reactionsFromDeletedUsersCount) {
            this.reactionsFromDeletedUsersCount = reactionsFromDeletedUsersCount;
            return this;
        }

        @Override
        public ReactionForComment build() {
            return new ReactionForComment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
