/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about a set of differences for a commit specifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Difference implements SdkPojo, Serializable, ToCopyableBuilder<Difference.Builder, Difference> {
    private static final SdkField<BlobMetadata> BEFORE_BLOB_FIELD = SdkField.<BlobMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("beforeBlob").getter(getter(Difference::beforeBlob)).setter(setter(Builder::beforeBlob))
            .constructor(BlobMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeBlob").build()).build();

    private static final SdkField<BlobMetadata> AFTER_BLOB_FIELD = SdkField.<BlobMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("afterBlob").getter(getter(Difference::afterBlob)).setter(setter(Builder::afterBlob))
            .constructor(BlobMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterBlob").build()).build();

    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changeType").getter(getter(Difference::changeTypeAsString)).setter(setter(Builder::changeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEFORE_BLOB_FIELD,
            AFTER_BLOB_FIELD, CHANGE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final BlobMetadata beforeBlob;

    private final BlobMetadata afterBlob;

    private final String changeType;

    private Difference(BuilderImpl builder) {
        this.beforeBlob = builder.beforeBlob;
        this.afterBlob = builder.afterBlob;
        this.changeType = builder.changeType;
    }

    /**
     * <p>
     * Information about a <code>beforeBlob</code> data type object, including the ID, the file mode permission code,
     * and the path.
     * </p>
     * 
     * @return Information about a <code>beforeBlob</code> data type object, including the ID, the file mode permission
     *         code, and the path.
     */
    public final BlobMetadata beforeBlob() {
        return beforeBlob;
    }

    /**
     * <p>
     * Information about an <code>afterBlob</code> data type object, including the ID, the file mode permission code,
     * and the path.
     * </p>
     * 
     * @return Information about an <code>afterBlob</code> data type object, including the ID, the file mode permission
     *         code, and the path.
     */
    public final BlobMetadata afterBlob() {
        return afterBlob;
    }

    /**
     * <p>
     * Whether the change type of the difference is an addition (A), deletion (D), or modification (M).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeType} will
     * return {@link ChangeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeTypeAsString}.
     * </p>
     * 
     * @return Whether the change type of the difference is an addition (A), deletion (D), or modification (M).
     * @see ChangeTypeEnum
     */
    public final ChangeTypeEnum changeType() {
        return ChangeTypeEnum.fromValue(changeType);
    }

    /**
     * <p>
     * Whether the change type of the difference is an addition (A), deletion (D), or modification (M).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeType} will
     * return {@link ChangeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeTypeAsString}.
     * </p>
     * 
     * @return Whether the change type of the difference is an addition (A), deletion (D), or modification (M).
     * @see ChangeTypeEnum
     */
    public final String changeTypeAsString() {
        return changeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(beforeBlob());
        hashCode = 31 * hashCode + Objects.hashCode(afterBlob());
        hashCode = 31 * hashCode + Objects.hashCode(changeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Difference)) {
            return false;
        }
        Difference other = (Difference) obj;
        return Objects.equals(beforeBlob(), other.beforeBlob()) && Objects.equals(afterBlob(), other.afterBlob())
                && Objects.equals(changeTypeAsString(), other.changeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Difference").add("BeforeBlob", beforeBlob()).add("AfterBlob", afterBlob())
                .add("ChangeType", changeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "beforeBlob":
            return Optional.ofNullable(clazz.cast(beforeBlob()));
        case "afterBlob":
            return Optional.ofNullable(clazz.cast(afterBlob()));
        case "changeType":
            return Optional.ofNullable(clazz.cast(changeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Difference, T> g) {
        return obj -> g.apply((Difference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Difference> {
        /**
         * <p>
         * Information about a <code>beforeBlob</code> data type object, including the ID, the file mode permission
         * code, and the path.
         * </p>
         * 
         * @param beforeBlob
         *        Information about a <code>beforeBlob</code> data type object, including the ID, the file mode
         *        permission code, and the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeBlob(BlobMetadata beforeBlob);

        /**
         * <p>
         * Information about a <code>beforeBlob</code> data type object, including the ID, the file mode permission
         * code, and the path.
         * </p>
         * This is a convenience that creates an instance of the {@link BlobMetadata.Builder} avoiding the need to
         * create one manually via {@link BlobMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link BlobMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #beforeBlob(BlobMetadata)}.
         * 
         * @param beforeBlob
         *        a consumer that will call methods on {@link BlobMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #beforeBlob(BlobMetadata)
         */
        default Builder beforeBlob(Consumer<BlobMetadata.Builder> beforeBlob) {
            return beforeBlob(BlobMetadata.builder().applyMutation(beforeBlob).build());
        }

        /**
         * <p>
         * Information about an <code>afterBlob</code> data type object, including the ID, the file mode permission
         * code, and the path.
         * </p>
         * 
         * @param afterBlob
         *        Information about an <code>afterBlob</code> data type object, including the ID, the file mode
         *        permission code, and the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterBlob(BlobMetadata afterBlob);

        /**
         * <p>
         * Information about an <code>afterBlob</code> data type object, including the ID, the file mode permission
         * code, and the path.
         * </p>
         * This is a convenience that creates an instance of the {@link BlobMetadata.Builder} avoiding the need to
         * create one manually via {@link BlobMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link BlobMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #afterBlob(BlobMetadata)}.
         * 
         * @param afterBlob
         *        a consumer that will call methods on {@link BlobMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #afterBlob(BlobMetadata)
         */
        default Builder afterBlob(Consumer<BlobMetadata.Builder> afterBlob) {
            return afterBlob(BlobMetadata.builder().applyMutation(afterBlob).build());
        }

        /**
         * <p>
         * Whether the change type of the difference is an addition (A), deletion (D), or modification (M).
         * </p>
         * 
         * @param changeType
         *        Whether the change type of the difference is an addition (A), deletion (D), or modification (M).
         * @see ChangeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeTypeEnum
         */
        Builder changeType(String changeType);

        /**
         * <p>
         * Whether the change type of the difference is an addition (A), deletion (D), or modification (M).
         * </p>
         * 
         * @param changeType
         *        Whether the change type of the difference is an addition (A), deletion (D), or modification (M).
         * @see ChangeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeTypeEnum
         */
        Builder changeType(ChangeTypeEnum changeType);
    }

    static final class BuilderImpl implements Builder {
        private BlobMetadata beforeBlob;

        private BlobMetadata afterBlob;

        private String changeType;

        private BuilderImpl() {
        }

        private BuilderImpl(Difference model) {
            beforeBlob(model.beforeBlob);
            afterBlob(model.afterBlob);
            changeType(model.changeType);
        }

        public final BlobMetadata.Builder getBeforeBlob() {
            return beforeBlob != null ? beforeBlob.toBuilder() : null;
        }

        public final void setBeforeBlob(BlobMetadata.BuilderImpl beforeBlob) {
            this.beforeBlob = beforeBlob != null ? beforeBlob.build() : null;
        }

        @Override
        @Transient
        public final Builder beforeBlob(BlobMetadata beforeBlob) {
            this.beforeBlob = beforeBlob;
            return this;
        }

        public final BlobMetadata.Builder getAfterBlob() {
            return afterBlob != null ? afterBlob.toBuilder() : null;
        }

        public final void setAfterBlob(BlobMetadata.BuilderImpl afterBlob) {
            this.afterBlob = afterBlob != null ? afterBlob.build() : null;
        }

        @Override
        @Transient
        public final Builder afterBlob(BlobMetadata afterBlob) {
            this.afterBlob = afterBlob;
            return this;
        }

        public final String getChangeType() {
            return changeType;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        @Transient
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        @Transient
        public final Builder changeType(ChangeTypeEnum changeType) {
            this.changeType(changeType == null ? null : changeType.toString());
            return this;
        }

        @Override
        public Difference build() {
            return new Difference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
