/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFileRequest extends CodeCommitRequest implements
        ToCopyableBuilder<DeleteFileRequest.Builder, DeleteFileRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(DeleteFileRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("branchName").getter(getter(DeleteFileRequest::branchName)).setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()).build();

    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filePath").getter(getter(DeleteFileRequest::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final SdkField<String> PARENT_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentCommitId").getter(getter(DeleteFileRequest::parentCommitId))
            .setter(setter(Builder::parentCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentCommitId").build()).build();

    private static final SdkField<Boolean> KEEP_EMPTY_FOLDERS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("keepEmptyFolders").getter(getter(DeleteFileRequest::keepEmptyFolders))
            .setter(setter(Builder::keepEmptyFolders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keepEmptyFolders").build()).build();

    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitMessage").getter(getter(DeleteFileRequest::commitMessage)).setter(setter(Builder::commitMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitMessage").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DeleteFileRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("email")
            .getter(getter(DeleteFileRequest::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            BRANCH_NAME_FIELD, FILE_PATH_FIELD, PARENT_COMMIT_ID_FIELD, KEEP_EMPTY_FOLDERS_FIELD, COMMIT_MESSAGE_FIELD,
            NAME_FIELD, EMAIL_FIELD));

    private final String repositoryName;

    private final String branchName;

    private final String filePath;

    private final String parentCommitId;

    private final Boolean keepEmptyFolders;

    private final String commitMessage;

    private final String name;

    private final String email;

    private DeleteFileRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.branchName = builder.branchName;
        this.filePath = builder.filePath;
        this.parentCommitId = builder.parentCommitId;
        this.keepEmptyFolders = builder.keepEmptyFolders;
        this.commitMessage = builder.commitMessage;
        this.name = builder.name;
        this.email = builder.email;
    }

    /**
     * <p>
     * The name of the repository that contains the file to delete.
     * </p>
     * 
     * @return The name of the repository that contains the file to delete.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The name of the branch where the commit that deletes the file is made.
     * </p>
     * 
     * @return The name of the branch where the commit that deletes the file is made.
     */
    public final String branchName() {
        return branchName;
    }

    /**
     * <p>
     * The fully qualified path to the file that to be deleted, including the full name and extension of that file. For
     * example, /examples/file.md is a fully qualified path to a file named file.md in a folder named examples.
     * </p>
     * 
     * @return The fully qualified path to the file that to be deleted, including the full name and extension of that
     *         file. For example, /examples/file.md is a fully qualified path to a file named file.md in a folder named
     *         examples.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * The ID of the commit that is the tip of the branch where you want to create the commit that deletes the file.
     * This must be the HEAD commit for the branch. The commit that deletes the file is created from this commit ID.
     * </p>
     * 
     * @return The ID of the commit that is the tip of the branch where you want to create the commit that deletes the
     *         file. This must be the HEAD commit for the branch. The commit that deletes the file is created from this
     *         commit ID.
     */
    public final String parentCommitId() {
        return parentCommitId;
    }

    /**
     * <p>
     * If a file is the only object in the folder or directory, specifies whether to delete the folder or directory that
     * contains the file. By default, empty folders are deleted. This includes empty folders that are part of the
     * directory structure. For example, if the path to a file is dir1/dir2/dir3/dir4, and dir2 and dir3 are empty,
     * deleting the last file in dir4 also deletes the empty folders dir4, dir3, and dir2.
     * </p>
     * 
     * @return If a file is the only object in the folder or directory, specifies whether to delete the folder or
     *         directory that contains the file. By default, empty folders are deleted. This includes empty folders that
     *         are part of the directory structure. For example, if the path to a file is dir1/dir2/dir3/dir4, and dir2
     *         and dir3 are empty, deleting the last file in dir4 also deletes the empty folders dir4, dir3, and dir2.
     */
    public final Boolean keepEmptyFolders() {
        return keepEmptyFolders;
    }

    /**
     * <p>
     * The commit message you want to include as part of deleting the file. Commit messages are limited to 256 KB. If no
     * message is specified, a default message is used.
     * </p>
     * 
     * @return The commit message you want to include as part of deleting the file. Commit messages are limited to 256
     *         KB. If no message is specified, a default message is used.
     */
    public final String commitMessage() {
        return commitMessage;
    }

    /**
     * <p>
     * The name of the author of the commit that deletes the file. If no name is specified, the user's ARN is used as
     * the author name and committer name.
     * </p>
     * 
     * @return The name of the author of the commit that deletes the file. If no name is specified, the user's ARN is
     *         used as the author name and committer name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The email address for the commit that deletes the file. If no email address is specified, the email address is
     * left blank.
     * </p>
     * 
     * @return The email address for the commit that deletes the file. If no email address is specified, the email
     *         address is left blank.
     */
    public final String email() {
        return email;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(parentCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(keepEmptyFolders());
        hashCode = 31 * hashCode + Objects.hashCode(commitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileRequest)) {
            return false;
        }
        DeleteFileRequest other = (DeleteFileRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName()) && Objects.equals(branchName(), other.branchName())
                && Objects.equals(filePath(), other.filePath()) && Objects.equals(parentCommitId(), other.parentCommitId())
                && Objects.equals(keepEmptyFolders(), other.keepEmptyFolders())
                && Objects.equals(commitMessage(), other.commitMessage()) && Objects.equals(name(), other.name())
                && Objects.equals(email(), other.email());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFileRequest").add("RepositoryName", repositoryName()).add("BranchName", branchName())
                .add("FilePath", filePath()).add("ParentCommitId", parentCommitId()).add("KeepEmptyFolders", keepEmptyFolders())
                .add("CommitMessage", commitMessage()).add("Name", name()).add("Email", email()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "branchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        case "filePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "parentCommitId":
            return Optional.ofNullable(clazz.cast(parentCommitId()));
        case "keepEmptyFolders":
            return Optional.ofNullable(clazz.cast(keepEmptyFolders()));
        case "commitMessage":
            return Optional.ofNullable(clazz.cast(commitMessage()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "email":
            return Optional.ofNullable(clazz.cast(email()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFileRequest, T> g) {
        return obj -> g.apply((DeleteFileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteFileRequest> {
        /**
         * <p>
         * The name of the repository that contains the file to delete.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that contains the file to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The name of the branch where the commit that deletes the file is made.
         * </p>
         * 
         * @param branchName
         *        The name of the branch where the commit that deletes the file is made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);

        /**
         * <p>
         * The fully qualified path to the file that to be deleted, including the full name and extension of that file.
         * For example, /examples/file.md is a fully qualified path to a file named file.md in a folder named examples.
         * </p>
         * 
         * @param filePath
         *        The fully qualified path to the file that to be deleted, including the full name and extension of that
         *        file. For example, /examples/file.md is a fully qualified path to a file named file.md in a folder
         *        named examples.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * The ID of the commit that is the tip of the branch where you want to create the commit that deletes the file.
         * This must be the HEAD commit for the branch. The commit that deletes the file is created from this commit ID.
         * </p>
         * 
         * @param parentCommitId
         *        The ID of the commit that is the tip of the branch where you want to create the commit that deletes
         *        the file. This must be the HEAD commit for the branch. The commit that deletes the file is created
         *        from this commit ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentCommitId(String parentCommitId);

        /**
         * <p>
         * If a file is the only object in the folder or directory, specifies whether to delete the folder or directory
         * that contains the file. By default, empty folders are deleted. This includes empty folders that are part of
         * the directory structure. For example, if the path to a file is dir1/dir2/dir3/dir4, and dir2 and dir3 are
         * empty, deleting the last file in dir4 also deletes the empty folders dir4, dir3, and dir2.
         * </p>
         * 
         * @param keepEmptyFolders
         *        If a file is the only object in the folder or directory, specifies whether to delete the folder or
         *        directory that contains the file. By default, empty folders are deleted. This includes empty folders
         *        that are part of the directory structure. For example, if the path to a file is dir1/dir2/dir3/dir4,
         *        and dir2 and dir3 are empty, deleting the last file in dir4 also deletes the empty folders dir4, dir3,
         *        and dir2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keepEmptyFolders(Boolean keepEmptyFolders);

        /**
         * <p>
         * The commit message you want to include as part of deleting the file. Commit messages are limited to 256 KB.
         * If no message is specified, a default message is used.
         * </p>
         * 
         * @param commitMessage
         *        The commit message you want to include as part of deleting the file. Commit messages are limited to
         *        256 KB. If no message is specified, a default message is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitMessage(String commitMessage);

        /**
         * <p>
         * The name of the author of the commit that deletes the file. If no name is specified, the user's ARN is used
         * as the author name and committer name.
         * </p>
         * 
         * @param name
         *        The name of the author of the commit that deletes the file. If no name is specified, the user's ARN is
         *        used as the author name and committer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The email address for the commit that deletes the file. If no email address is specified, the email address
         * is left blank.
         * </p>
         * 
         * @param email
         *        The email address for the commit that deletes the file. If no email address is specified, the email
         *        address is left blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private String branchName;

        private String filePath;

        private String parentCommitId;

        private Boolean keepEmptyFolders;

        private String commitMessage;

        private String name;

        private String email;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            branchName(model.branchName);
            filePath(model.filePath);
            parentCommitId(model.parentCommitId);
            keepEmptyFolders(model.keepEmptyFolders);
            commitMessage(model.commitMessage);
            name(model.name);
            email(model.email);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        @Transient
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getBranchName() {
            return branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        @Transient
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        @Transient
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getParentCommitId() {
            return parentCommitId;
        }

        public final void setParentCommitId(String parentCommitId) {
            this.parentCommitId = parentCommitId;
        }

        @Override
        @Transient
        public final Builder parentCommitId(String parentCommitId) {
            this.parentCommitId = parentCommitId;
            return this;
        }

        public final Boolean getKeepEmptyFolders() {
            return keepEmptyFolders;
        }

        public final void setKeepEmptyFolders(Boolean keepEmptyFolders) {
            this.keepEmptyFolders = keepEmptyFolders;
        }

        @Override
        @Transient
        public final Builder keepEmptyFolders(Boolean keepEmptyFolders) {
            this.keepEmptyFolders = keepEmptyFolders;
            return this;
        }

        public final String getCommitMessage() {
            return commitMessage;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        @Override
        @Transient
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        @Transient
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFileRequest build() {
            return new DeleteFileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
