/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApprovalRuleTemplateRequest extends CodeCommitRequest implements
        ToCopyableBuilder<CreateApprovalRuleTemplateRequest.Builder, CreateApprovalRuleTemplateRequest> {
    private static final SdkField<String> APPROVAL_RULE_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("approvalRuleTemplateName").getter(getter(CreateApprovalRuleTemplateRequest::approvalRuleTemplateName))
            .setter(setter(Builder::approvalRuleTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplateName").build())
            .build();

    private static final SdkField<String> APPROVAL_RULE_TEMPLATE_CONTENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("approvalRuleTemplateContent")
            .getter(getter(CreateApprovalRuleTemplateRequest::approvalRuleTemplateContent))
            .setter(setter(Builder::approvalRuleTemplateContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplateContent")
                    .build()).build();

    private static final SdkField<String> APPROVAL_RULE_TEMPLATE_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("approvalRuleTemplateDescription")
            .getter(getter(CreateApprovalRuleTemplateRequest::approvalRuleTemplateDescription))
            .setter(setter(Builder::approvalRuleTemplateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplateDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPROVAL_RULE_TEMPLATE_NAME_FIELD, APPROVAL_RULE_TEMPLATE_CONTENT_FIELD, APPROVAL_RULE_TEMPLATE_DESCRIPTION_FIELD));

    private final String approvalRuleTemplateName;

    private final String approvalRuleTemplateContent;

    private final String approvalRuleTemplateDescription;

    private CreateApprovalRuleTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.approvalRuleTemplateName = builder.approvalRuleTemplateName;
        this.approvalRuleTemplateContent = builder.approvalRuleTemplateContent;
        this.approvalRuleTemplateDescription = builder.approvalRuleTemplateDescription;
    }

    /**
     * <p>
     * The name of the approval rule template. Provide descriptive names, because this name is applied to the approval
     * rules created automatically in associated repositories.
     * </p>
     * 
     * @return The name of the approval rule template. Provide descriptive names, because this name is applied to the
     *         approval rules created automatically in associated repositories.
     */
    public final String approvalRuleTemplateName() {
        return approvalRuleTemplateName;
    }

    /**
     * <p>
     * The content of the approval rule that is created on pull requests in associated repositories. If you specify one
     * or more destination references (branches), approval rules are created in an associated repository only if their
     * destination references (branches) match those specified in the template.
     * </p>
     * <note>
     * <p>
     * When you create the content of the approval rule template, you can specify approvers in an approval pool in one
     * of two ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM
     * users and federated access users whose name matches the provided resource name. This is a very powerful option
     * that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and
     * <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * A federated user identified in IAM as Mary_Major
     * (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role
     * session name of <i>Mary_Major</i>
     * (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard
     * (*Mary_Major).
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of
     * the IAM user or role.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about IAM ARNs, wildcards, and formats, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </note>
     * 
     * @return The content of the approval rule that is created on pull requests in associated repositories. If you
     *         specify one or more destination references (branches), approval rules are created in an associated
     *         repository only if their destination references (branches) match those specified in the template.</p>
     *         <note>
     *         <p>
     *         When you create the content of the approval rule template, you can specify approvers in an approval pool
     *         in one of two ways:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for
     *         both IAM users and federated access users whose name matches the provided resource name. This is a very
     *         powerful option that offers a great deal of flexibility. For example, if you specify the AWS account
     *         <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that
     *         user:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A federated user identified in IAM as Mary_Major
     *         (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This option does not recognize an active session of someone assuming the role of CodeCommitReview with a
     *         role session name of <i>Mary_Major</i>
     *         (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a
     *         wildcard (*Mary_Major).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name
     *         (ARN) of the IAM user or role.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about IAM ARNs, wildcards, and formats, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in
     *         the <i>IAM User Guide</i>.
     *         </p>
     */
    public final String approvalRuleTemplateContent() {
        return approvalRuleTemplateContent;
    }

    /**
     * <p>
     * The description of the approval rule template. Consider providing a description that explains what this template
     * does and when it might be appropriate to associate it with repositories.
     * </p>
     * 
     * @return The description of the approval rule template. Consider providing a description that explains what this
     *         template does and when it might be appropriate to associate it with repositories.
     */
    public final String approvalRuleTemplateDescription() {
        return approvalRuleTemplateDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleTemplateContent());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleTemplateDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApprovalRuleTemplateRequest)) {
            return false;
        }
        CreateApprovalRuleTemplateRequest other = (CreateApprovalRuleTemplateRequest) obj;
        return Objects.equals(approvalRuleTemplateName(), other.approvalRuleTemplateName())
                && Objects.equals(approvalRuleTemplateContent(), other.approvalRuleTemplateContent())
                && Objects.equals(approvalRuleTemplateDescription(), other.approvalRuleTemplateDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApprovalRuleTemplateRequest").add("ApprovalRuleTemplateName", approvalRuleTemplateName())
                .add("ApprovalRuleTemplateContent", approvalRuleTemplateContent())
                .add("ApprovalRuleTemplateDescription", approvalRuleTemplateDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approvalRuleTemplateName":
            return Optional.ofNullable(clazz.cast(approvalRuleTemplateName()));
        case "approvalRuleTemplateContent":
            return Optional.ofNullable(clazz.cast(approvalRuleTemplateContent()));
        case "approvalRuleTemplateDescription":
            return Optional.ofNullable(clazz.cast(approvalRuleTemplateDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApprovalRuleTemplateRequest, T> g) {
        return obj -> g.apply((CreateApprovalRuleTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateApprovalRuleTemplateRequest> {
        /**
         * <p>
         * The name of the approval rule template. Provide descriptive names, because this name is applied to the
         * approval rules created automatically in associated repositories.
         * </p>
         * 
         * @param approvalRuleTemplateName
         *        The name of the approval rule template. Provide descriptive names, because this name is applied to the
         *        approval rules created automatically in associated repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleTemplateName(String approvalRuleTemplateName);

        /**
         * <p>
         * The content of the approval rule that is created on pull requests in associated repositories. If you specify
         * one or more destination references (branches), approval rules are created in an associated repository only if
         * their destination references (branches) match those specified in the template.
         * </p>
         * <note>
         * <p>
         * When you create the content of the approval rule template, you can specify approvers in an approval pool in
         * one of two ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both
         * IAM users and federated access users whose name matches the provided resource name. This is a very powerful
         * option that offers a great deal of flexibility. For example, if you specify the AWS account
         * <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that
         * user:
         * </p>
         * <ul>
         * <li>
         * <p>
         * An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)
         * </p>
         * </li>
         * <li>
         * <p>
         * A federated user identified in IAM as Mary_Major
         * (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)
         * </p>
         * </li>
         * </ul>
         * <p>
         * This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role
         * session name of <i>Mary_Major</i>
         * (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a
         * wildcard (*Mary_Major).
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN)
         * of the IAM user or role.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about IAM ARNs, wildcards, and formats, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * </note>
         * 
         * @param approvalRuleTemplateContent
         *        The content of the approval rule that is created on pull requests in associated repositories. If you
         *        specify one or more destination references (branches), approval rules are created in an associated
         *        repository only if their destination references (branches) match those specified in the template.</p>
         *        <note>
         *        <p>
         *        When you create the content of the approval rule template, you can specify approvers in an approval
         *        pool in one of two ways:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used
         *        for both IAM users and federated access users whose name matches the provided resource name. This is a
         *        very powerful option that offers a great deal of flexibility. For example, if you specify the AWS
         *        account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals
         *        coming from that user:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A federated user identified in IAM as Mary_Major
         *        (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This option does not recognize an active session of someone assuming the role of CodeCommitReview with
         *        a role session name of <i>Mary_Major</i>
         *        (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include
         *        a wildcard (*Mary_Major).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name
         *        (ARN) of the IAM user or role.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about IAM ARNs, wildcards, and formats, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a>
         *        in the <i>IAM User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleTemplateContent(String approvalRuleTemplateContent);

        /**
         * <p>
         * The description of the approval rule template. Consider providing a description that explains what this
         * template does and when it might be appropriate to associate it with repositories.
         * </p>
         * 
         * @param approvalRuleTemplateDescription
         *        The description of the approval rule template. Consider providing a description that explains what
         *        this template does and when it might be appropriate to associate it with repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleTemplateDescription(String approvalRuleTemplateDescription);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String approvalRuleTemplateName;

        private String approvalRuleTemplateContent;

        private String approvalRuleTemplateDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApprovalRuleTemplateRequest model) {
            super(model);
            approvalRuleTemplateName(model.approvalRuleTemplateName);
            approvalRuleTemplateContent(model.approvalRuleTemplateContent);
            approvalRuleTemplateDescription(model.approvalRuleTemplateDescription);
        }

        public final String getApprovalRuleTemplateName() {
            return approvalRuleTemplateName;
        }

        public final void setApprovalRuleTemplateName(String approvalRuleTemplateName) {
            this.approvalRuleTemplateName = approvalRuleTemplateName;
        }

        @Override
        @Transient
        public final Builder approvalRuleTemplateName(String approvalRuleTemplateName) {
            this.approvalRuleTemplateName = approvalRuleTemplateName;
            return this;
        }

        public final String getApprovalRuleTemplateContent() {
            return approvalRuleTemplateContent;
        }

        public final void setApprovalRuleTemplateContent(String approvalRuleTemplateContent) {
            this.approvalRuleTemplateContent = approvalRuleTemplateContent;
        }

        @Override
        @Transient
        public final Builder approvalRuleTemplateContent(String approvalRuleTemplateContent) {
            this.approvalRuleTemplateContent = approvalRuleTemplateContent;
            return this;
        }

        public final String getApprovalRuleTemplateDescription() {
            return approvalRuleTemplateDescription;
        }

        public final void setApprovalRuleTemplateDescription(String approvalRuleTemplateDescription) {
            this.approvalRuleTemplateDescription = approvalRuleTemplateDescription;
        }

        @Override
        @Transient
        public final Builder approvalRuleTemplateDescription(String approvalRuleTemplateDescription) {
            this.approvalRuleTemplateDescription = approvalRuleTemplateDescription;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApprovalRuleTemplateRequest build() {
            return new CreateApprovalRuleTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
