/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about a specific Git blob object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlobMetadata implements SdkPojo, Serializable, ToCopyableBuilder<BlobMetadata.Builder, BlobMetadata> {
    private static final SdkField<String> BLOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("blobId")
            .getter(getter(BlobMetadata::blobId)).setter(setter(Builder::blobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobId").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("path")
            .getter(getter(BlobMetadata::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(BlobMetadata::mode)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOB_ID_FIELD, PATH_FIELD,
            MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String blobId;

    private final String path;

    private final String mode;

    private BlobMetadata(BuilderImpl builder) {
        this.blobId = builder.blobId;
        this.path = builder.path;
        this.mode = builder.mode;
    }

    /**
     * <p>
     * The full ID of the blob.
     * </p>
     * 
     * @return The full ID of the blob.
     */
    public final String blobId() {
        return blobId;
    }

    /**
     * <p>
     * The path to the blob and associated file name, if any.
     * </p>
     * 
     * @return The path to the blob and associated file name, if any.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The file mode permissions of the blob. File mode permission codes include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>100644</code> indicates read/write
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>100755</code> indicates read/write/execute
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>160000</code> indicates a submodule
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>120000</code> indicates a symlink
     * </p>
     * </li>
     * </ul>
     * 
     * @return The file mode permissions of the blob. File mode permission codes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>100644</code> indicates read/write
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>100755</code> indicates read/write/execute
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>160000</code> indicates a submodule
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>120000</code> indicates a symlink
     *         </p>
     *         </li>
     */
    public final String mode() {
        return mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blobId());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(mode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlobMetadata)) {
            return false;
        }
        BlobMetadata other = (BlobMetadata) obj;
        return Objects.equals(blobId(), other.blobId()) && Objects.equals(path(), other.path())
                && Objects.equals(mode(), other.mode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlobMetadata").add("BlobId", blobId()).add("Path", path()).add("Mode", mode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blobId":
            return Optional.ofNullable(clazz.cast(blobId()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "mode":
            return Optional.ofNullable(clazz.cast(mode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlobMetadata, T> g) {
        return obj -> g.apply((BlobMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlobMetadata> {
        /**
         * <p>
         * The full ID of the blob.
         * </p>
         * 
         * @param blobId
         *        The full ID of the blob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blobId(String blobId);

        /**
         * <p>
         * The path to the blob and associated file name, if any.
         * </p>
         * 
         * @param path
         *        The path to the blob and associated file name, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The file mode permissions of the blob. File mode permission codes include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>100644</code> indicates read/write
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>100755</code> indicates read/write/execute
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>160000</code> indicates a submodule
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>120000</code> indicates a symlink
         * </p>
         * </li>
         * </ul>
         * 
         * @param mode
         *        The file mode permissions of the blob. File mode permission codes include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>100644</code> indicates read/write
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>100755</code> indicates read/write/execute
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>160000</code> indicates a submodule
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>120000</code> indicates a symlink
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mode(String mode);
    }

    static final class BuilderImpl implements Builder {
        private String blobId;

        private String path;

        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(BlobMetadata model) {
            blobId(model.blobId);
            path(model.path);
            mode(model.mode);
        }

        public final String getBlobId() {
            return blobId;
        }

        public final void setBlobId(String blobId) {
            this.blobId = blobId;
        }

        @Override
        @Transient
        public final Builder blobId(String blobId) {
            this.blobId = blobId;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        @Transient
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        @Transient
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public BlobMetadata build() {
            return new BlobMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
