/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystAsyncClient;
import software.amazon.awssdk.services.codecatalyst.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSummary;
import software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentsRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentsResponse;

public class ListDevEnvironmentsPublisher
implements SdkPublisher<ListDevEnvironmentsResponse> {
    private final CodeCatalystAsyncClient client;
    private final ListDevEnvironmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDevEnvironmentsPublisher(CodeCatalystAsyncClient client, ListDevEnvironmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDevEnvironmentsPublisher(CodeCatalystAsyncClient client, ListDevEnvironmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDevEnvironmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDevEnvironmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DevEnvironmentSummary> items() {
        Function<ListDevEnvironmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDevEnvironmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDevEnvironmentsResponseFetcher
    implements AsyncPageFetcher<ListDevEnvironmentsResponse> {
        private ListDevEnvironmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListDevEnvironmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDevEnvironmentsResponse> nextPage(ListDevEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return ListDevEnvironmentsPublisher.this.client.listDevEnvironments(ListDevEnvironmentsPublisher.this.firstRequest);
            }
            return ListDevEnvironmentsPublisher.this.client.listDevEnvironments((ListDevEnvironmentsRequest)((Object)ListDevEnvironmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

