/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecatalyst.model.EventPayload;
import software.amazon.awssdk.services.codecatalyst.model.OperationType;
import software.amazon.awssdk.services.codecatalyst.model.ProjectInformation;
import software.amazon.awssdk.services.codecatalyst.model.UserIdentity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventLogEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventLogEntry> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(EventLogEntry.getter(EventLogEntry::id)).setter(EventLogEntry.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> EVENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventName").getter(EventLogEntry.getter(EventLogEntry::eventName)).setter(EventLogEntry.setter(Builder::eventName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventName").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(EventLogEntry.getter(EventLogEntry::eventType)).setter(EventLogEntry.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<String> EVENT_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventCategory").getter(EventLogEntry.getter(EventLogEntry::eventCategory)).setter(EventLogEntry.setter(Builder::eventCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventCategory").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventSource").getter(EventLogEntry.getter(EventLogEntry::eventSource)).setter(EventLogEntry.setter(Builder::eventSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSource").build()}).build();
    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("eventTime").getter(EventLogEntry.getter(EventLogEntry::eventTime)).setter(EventLogEntry.setter(Builder::eventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationType").getter(EventLogEntry.getter(EventLogEntry::operationTypeAsString)).setter(EventLogEntry.setter(Builder::operationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()}).build();
    private static final SdkField<UserIdentity> USER_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userIdentity").getter(EventLogEntry.getter(EventLogEntry::userIdentity)).setter(EventLogEntry.setter(Builder::userIdentity)).constructor(UserIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIdentity").build()}).build();
    private static final SdkField<ProjectInformation> PROJECT_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("projectInformation").getter(EventLogEntry.getter(EventLogEntry::projectInformation)).setter(EventLogEntry.setter(Builder::projectInformation)).constructor(ProjectInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectInformation").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(EventLogEntry.getter(EventLogEntry::requestId)).setter(EventLogEntry.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<EventPayload> REQUEST_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("requestPayload").getter(EventLogEntry.getter(EventLogEntry::requestPayload)).setter(EventLogEntry.setter(Builder::requestPayload)).constructor(EventPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestPayload").build()}).build();
    private static final SdkField<EventPayload> RESPONSE_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("responsePayload").getter(EventLogEntry.getter(EventLogEntry::responsePayload)).setter(EventLogEntry.setter(Builder::responsePayload)).constructor(EventPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responsePayload").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(EventLogEntry.getter(EventLogEntry::errorCode)).setter(EventLogEntry.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> SOURCE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceIpAddress").getter(EventLogEntry.getter(EventLogEntry::sourceIpAddress)).setter(EventLogEntry.setter(Builder::sourceIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIpAddress").build()}).build();
    private static final SdkField<String> USER_AGENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userAgent").getter(EventLogEntry.getter(EventLogEntry::userAgent)).setter(EventLogEntry.setter(Builder::userAgent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAgent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EVENT_NAME_FIELD, EVENT_TYPE_FIELD, EVENT_CATEGORY_FIELD, EVENT_SOURCE_FIELD, EVENT_TIME_FIELD, OPERATION_TYPE_FIELD, USER_IDENTITY_FIELD, PROJECT_INFORMATION_FIELD, REQUEST_ID_FIELD, REQUEST_PAYLOAD_FIELD, RESPONSE_PAYLOAD_FIELD, ERROR_CODE_FIELD, SOURCE_IP_ADDRESS_FIELD, USER_AGENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventLogEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String eventName;
    private final String eventType;
    private final String eventCategory;
    private final String eventSource;
    private final Instant eventTime;
    private final String operationType;
    private final UserIdentity userIdentity;
    private final ProjectInformation projectInformation;
    private final String requestIdValue;
    private final EventPayload requestPayload;
    private final EventPayload responsePayload;
    private final String errorCode;
    private final String sourceIpAddress;
    private final String userAgent;

    private EventLogEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.eventName = builder.eventName;
        this.eventType = builder.eventType;
        this.eventCategory = builder.eventCategory;
        this.eventSource = builder.eventSource;
        this.eventTime = builder.eventTime;
        this.operationType = builder.operationType;
        this.userIdentity = builder.userIdentity;
        this.projectInformation = builder.projectInformation;
        this.requestIdValue = builder.requestIdValue;
        this.requestPayload = builder.requestPayload;
        this.responsePayload = builder.responsePayload;
        this.errorCode = builder.errorCode;
        this.sourceIpAddress = builder.sourceIpAddress;
        this.userAgent = builder.userAgent;
    }

    public final String id() {
        return this.id;
    }

    public final String eventName() {
        return this.eventName;
    }

    public final String eventType() {
        return this.eventType;
    }

    public final String eventCategory() {
        return this.eventCategory;
    }

    public final String eventSource() {
        return this.eventSource;
    }

    public final Instant eventTime() {
        return this.eventTime;
    }

    public final OperationType operationType() {
        return OperationType.fromValue(this.operationType);
    }

    public final String operationTypeAsString() {
        return this.operationType;
    }

    public final UserIdentity userIdentity() {
        return this.userIdentity;
    }

    public final ProjectInformation projectInformation() {
        return this.projectInformation;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final EventPayload requestPayload() {
        return this.requestPayload;
    }

    public final EventPayload responsePayload() {
        return this.responsePayload;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final String sourceIpAddress() {
        return this.sourceIpAddress;
    }

    public final String userAgent() {
        return this.userAgent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCategory());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestPayload());
        hashCode = 31 * hashCode + Objects.hashCode(this.responsePayload());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAgent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventLogEntry)) {
            return false;
        }
        EventLogEntry other = (EventLogEntry)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.eventName(), other.eventName()) && Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.eventCategory(), other.eventCategory()) && Objects.equals(this.eventSource(), other.eventSource()) && Objects.equals(this.eventTime(), other.eventTime()) && Objects.equals(this.operationTypeAsString(), other.operationTypeAsString()) && Objects.equals(this.userIdentity(), other.userIdentity()) && Objects.equals(this.projectInformation(), other.projectInformation()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.requestPayload(), other.requestPayload()) && Objects.equals(this.responsePayload(), other.responsePayload()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.sourceIpAddress(), other.sourceIpAddress()) && Objects.equals(this.userAgent(), other.userAgent());
    }

    public final String toString() {
        return ToString.builder((String)"EventLogEntry").add("Id", (Object)this.id()).add("EventName", (Object)this.eventName()).add("EventType", (Object)this.eventType()).add("EventCategory", (Object)this.eventCategory()).add("EventSource", (Object)this.eventSource()).add("EventTime", (Object)this.eventTime()).add("OperationType", (Object)this.operationTypeAsString()).add("UserIdentity", (Object)this.userIdentity()).add("ProjectInformation", (Object)this.projectInformation()).add("RequestId", (Object)this.requestId()).add("RequestPayload", (Object)this.requestPayload()).add("ResponsePayload", (Object)this.responsePayload()).add("ErrorCode", (Object)this.errorCode()).add("SourceIpAddress", (Object)this.sourceIpAddress()).add("UserAgent", (Object)this.userAgent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "eventName": {
                return Optional.ofNullable(clazz.cast(this.eventName()));
            }
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "eventCategory": {
                return Optional.ofNullable(clazz.cast(this.eventCategory()));
            }
            case "eventSource": {
                return Optional.ofNullable(clazz.cast(this.eventSource()));
            }
            case "eventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "operationType": {
                return Optional.ofNullable(clazz.cast(this.operationTypeAsString()));
            }
            case "userIdentity": {
                return Optional.ofNullable(clazz.cast(this.userIdentity()));
            }
            case "projectInformation": {
                return Optional.ofNullable(clazz.cast(this.projectInformation()));
            }
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "requestPayload": {
                return Optional.ofNullable(clazz.cast(this.requestPayload()));
            }
            case "responsePayload": {
                return Optional.ofNullable(clazz.cast(this.responsePayload()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "sourceIpAddress": {
                return Optional.ofNullable(clazz.cast(this.sourceIpAddress()));
            }
            case "userAgent": {
                return Optional.ofNullable(clazz.cast(this.userAgent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("eventName", EVENT_NAME_FIELD);
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("eventCategory", EVENT_CATEGORY_FIELD);
        map.put("eventSource", EVENT_SOURCE_FIELD);
        map.put("eventTime", EVENT_TIME_FIELD);
        map.put("operationType", OPERATION_TYPE_FIELD);
        map.put("userIdentity", USER_IDENTITY_FIELD);
        map.put("projectInformation", PROJECT_INFORMATION_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("requestPayload", REQUEST_PAYLOAD_FIELD);
        map.put("responsePayload", RESPONSE_PAYLOAD_FIELD);
        map.put("errorCode", ERROR_CODE_FIELD);
        map.put("sourceIpAddress", SOURCE_IP_ADDRESS_FIELD);
        map.put("userAgent", USER_AGENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventLogEntry, T> g) {
        return obj -> g.apply((EventLogEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String eventName;
        private String eventType;
        private String eventCategory;
        private String eventSource;
        private Instant eventTime;
        private String operationType;
        private UserIdentity userIdentity;
        private ProjectInformation projectInformation;
        private String requestIdValue;
        private EventPayload requestPayload;
        private EventPayload responsePayload;
        private String errorCode;
        private String sourceIpAddress;
        private String userAgent;

        private BuilderImpl() {
        }

        private BuilderImpl(EventLogEntry model) {
            this.id(model.id);
            this.eventName(model.eventName);
            this.eventType(model.eventType);
            this.eventCategory(model.eventCategory);
            this.eventSource(model.eventSource);
            this.eventTime(model.eventTime);
            this.operationType(model.operationType);
            this.userIdentity(model.userIdentity);
            this.projectInformation(model.projectInformation);
            this.requestId(model.requestIdValue);
            this.requestPayload(model.requestPayload);
            this.responsePayload(model.responsePayload);
            this.errorCode(model.errorCode);
            this.sourceIpAddress(model.sourceIpAddress);
            this.userAgent(model.userAgent);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getEventName() {
            return this.eventName;
        }

        public final void setEventName(String eventName) {
            this.eventName = eventName;
        }

        @Override
        public final Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final String getEventCategory() {
            return this.eventCategory;
        }

        public final void setEventCategory(String eventCategory) {
            this.eventCategory = eventCategory;
        }

        @Override
        public final Builder eventCategory(String eventCategory) {
            this.eventCategory = eventCategory;
            return this;
        }

        public final String getEventSource() {
            return this.eventSource;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getOperationType() {
            return this.operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final UserIdentity.Builder getUserIdentity() {
            return this.userIdentity != null ? this.userIdentity.toBuilder() : null;
        }

        public final void setUserIdentity(UserIdentity.BuilderImpl userIdentity) {
            this.userIdentity = userIdentity != null ? userIdentity.build() : null;
        }

        @Override
        public final Builder userIdentity(UserIdentity userIdentity) {
            this.userIdentity = userIdentity;
            return this;
        }

        public final ProjectInformation.Builder getProjectInformation() {
            return this.projectInformation != null ? this.projectInformation.toBuilder() : null;
        }

        public final void setProjectInformation(ProjectInformation.BuilderImpl projectInformation) {
            this.projectInformation = projectInformation != null ? projectInformation.build() : null;
        }

        @Override
        public final Builder projectInformation(ProjectInformation projectInformation) {
            this.projectInformation = projectInformation;
            return this;
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final EventPayload.Builder getRequestPayload() {
            return this.requestPayload != null ? this.requestPayload.toBuilder() : null;
        }

        public final void setRequestPayload(EventPayload.BuilderImpl requestPayload) {
            this.requestPayload = requestPayload != null ? requestPayload.build() : null;
        }

        @Override
        public final Builder requestPayload(EventPayload requestPayload) {
            this.requestPayload = requestPayload;
            return this;
        }

        public final EventPayload.Builder getResponsePayload() {
            return this.responsePayload != null ? this.responsePayload.toBuilder() : null;
        }

        public final void setResponsePayload(EventPayload.BuilderImpl responsePayload) {
            this.responsePayload = responsePayload != null ? responsePayload.build() : null;
        }

        @Override
        public final Builder responsePayload(EventPayload responsePayload) {
            this.responsePayload = responsePayload;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getSourceIpAddress() {
            return this.sourceIpAddress;
        }

        public final void setSourceIpAddress(String sourceIpAddress) {
            this.sourceIpAddress = sourceIpAddress;
        }

        @Override
        public final Builder sourceIpAddress(String sourceIpAddress) {
            this.sourceIpAddress = sourceIpAddress;
            return this;
        }

        public final String getUserAgent() {
            return this.userAgent;
        }

        public final void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @Override
        public final Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public EventLogEntry build() {
            return new EventLogEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventLogEntry> {
        public Builder id(String var1);

        public Builder eventName(String var1);

        public Builder eventType(String var1);

        public Builder eventCategory(String var1);

        public Builder eventSource(String var1);

        public Builder eventTime(Instant var1);

        public Builder operationType(String var1);

        public Builder operationType(OperationType var1);

        public Builder userIdentity(UserIdentity var1);

        default public Builder userIdentity(Consumer<UserIdentity.Builder> userIdentity) {
            return this.userIdentity((UserIdentity)((UserIdentity.Builder)UserIdentity.builder().applyMutation(userIdentity)).build());
        }

        public Builder projectInformation(ProjectInformation var1);

        default public Builder projectInformation(Consumer<ProjectInformation.Builder> projectInformation) {
            return this.projectInformation((ProjectInformation)((ProjectInformation.Builder)ProjectInformation.builder().applyMutation(projectInformation)).build());
        }

        public Builder requestId(String var1);

        public Builder requestPayload(EventPayload var1);

        default public Builder requestPayload(Consumer<EventPayload.Builder> requestPayload) {
            return this.requestPayload((EventPayload)((EventPayload.Builder)EventPayload.builder().applyMutation(requestPayload)).build());
        }

        public Builder responsePayload(EventPayload var1);

        default public Builder responsePayload(Consumer<EventPayload.Builder> responsePayload) {
            return this.responsePayload((EventPayload)((EventPayload.Builder)EventPayload.builder().applyMutation(responsePayload)).build());
        }

        public Builder errorCode(String var1);

        public Builder sourceIpAddress(String var1);

        public Builder userAgent(String var1);
    }
}

