/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecatalyst.model.CodeCatalystRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDevEnvironmentSessionsRequest
extends CodeCatalystRequest
implements ToCopyableBuilder<Builder, ListDevEnvironmentSessionsRequest> {
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceName").getter(ListDevEnvironmentSessionsRequest.getter(ListDevEnvironmentSessionsRequest::spaceName)).setter(ListDevEnvironmentSessionsRequest.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("spaceName").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(ListDevEnvironmentSessionsRequest.getter(ListDevEnvironmentSessionsRequest::projectName)).setter(ListDevEnvironmentSessionsRequest.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()}).build();
    private static final SdkField<String> DEV_ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("devEnvironmentId").getter(ListDevEnvironmentSessionsRequest.getter(ListDevEnvironmentSessionsRequest::devEnvironmentId)).setter(ListDevEnvironmentSessionsRequest.setter(Builder::devEnvironmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("devEnvironmentId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDevEnvironmentSessionsRequest.getter(ListDevEnvironmentSessionsRequest::nextToken)).setter(ListDevEnvironmentSessionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListDevEnvironmentSessionsRequest.getter(ListDevEnvironmentSessionsRequest::maxResults)).setter(ListDevEnvironmentSessionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_NAME_FIELD, PROJECT_NAME_FIELD, DEV_ENVIRONMENT_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDevEnvironmentSessionsRequest.memberNameToFieldInitializer();
    private final String spaceName;
    private final String projectName;
    private final String devEnvironmentId;
    private final String nextToken;
    private final Integer maxResults;

    private ListDevEnvironmentSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.spaceName = builder.spaceName;
        this.projectName = builder.projectName;
        this.devEnvironmentId = builder.devEnvironmentId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String devEnvironmentId() {
        return this.devEnvironmentId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.devEnvironmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevEnvironmentSessionsRequest)) {
            return false;
        }
        ListDevEnvironmentSessionsRequest other = (ListDevEnvironmentSessionsRequest)((Object)obj);
        return Objects.equals(this.spaceName(), other.spaceName()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.devEnvironmentId(), other.devEnvironmentId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListDevEnvironmentSessionsRequest").add("SpaceName", (Object)this.spaceName()).add("ProjectName", (Object)this.projectName()).add("DevEnvironmentId", (Object)this.devEnvironmentId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "devEnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.devEnvironmentId()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spaceName", SPACE_NAME_FIELD);
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("devEnvironmentId", DEV_ENVIRONMENT_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDevEnvironmentSessionsRequest, T> g) {
        return obj -> g.apply((ListDevEnvironmentSessionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCatalystRequest.BuilderImpl
    implements Builder {
        private String spaceName;
        private String projectName;
        private String devEnvironmentId;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevEnvironmentSessionsRequest model) {
            super(model);
            this.spaceName(model.spaceName);
            this.projectName(model.projectName);
            this.devEnvironmentId(model.devEnvironmentId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getDevEnvironmentId() {
            return this.devEnvironmentId;
        }

        public final void setDevEnvironmentId(String devEnvironmentId) {
            this.devEnvironmentId = devEnvironmentId;
        }

        @Override
        public final Builder devEnvironmentId(String devEnvironmentId) {
            this.devEnvironmentId = devEnvironmentId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDevEnvironmentSessionsRequest build() {
            return new ListDevEnvironmentSessionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCatalystRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDevEnvironmentSessionsRequest> {
        public Builder spaceName(String var1);

        public Builder projectName(String var1);

        public Builder devEnvironmentId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

