/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.ProjectVisibilityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProjectVisibilityResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, UpdateProjectVisibilityResponse> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectArn").getter(UpdateProjectVisibilityResponse.getter(UpdateProjectVisibilityResponse::projectArn)).setter(UpdateProjectVisibilityResponse.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()}).build();
    private static final SdkField<String> PUBLIC_PROJECT_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("publicProjectAlias").getter(UpdateProjectVisibilityResponse.getter(UpdateProjectVisibilityResponse::publicProjectAlias)).setter(UpdateProjectVisibilityResponse.setter(Builder::publicProjectAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicProjectAlias").build()}).build();
    private static final SdkField<String> PROJECT_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectVisibility").getter(UpdateProjectVisibilityResponse.getter(UpdateProjectVisibilityResponse::projectVisibilityAsString)).setter(UpdateProjectVisibilityResponse.setter(Builder::projectVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectVisibility").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, PUBLIC_PROJECT_ALIAS_FIELD, PROJECT_VISIBILITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProjectVisibilityResponse.memberNameToFieldInitializer();
    private final String projectArn;
    private final String publicProjectAlias;
    private final String projectVisibility;

    private UpdateProjectVisibilityResponse(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.publicProjectAlias = builder.publicProjectAlias;
        this.projectVisibility = builder.projectVisibility;
    }

    public final String projectArn() {
        return this.projectArn;
    }

    public final String publicProjectAlias() {
        return this.publicProjectAlias;
    }

    public final ProjectVisibilityType projectVisibility() {
        return ProjectVisibilityType.fromValue(this.projectVisibility);
    }

    public final String projectVisibilityAsString() {
        return this.projectVisibility;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicProjectAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectVisibilityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectVisibilityResponse)) {
            return false;
        }
        UpdateProjectVisibilityResponse other = (UpdateProjectVisibilityResponse)((Object)obj);
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.publicProjectAlias(), other.publicProjectAlias()) && Objects.equals(this.projectVisibilityAsString(), other.projectVisibilityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProjectVisibilityResponse").add("ProjectArn", (Object)this.projectArn()).add("PublicProjectAlias", (Object)this.publicProjectAlias()).add("ProjectVisibility", (Object)this.projectVisibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "publicProjectAlias": {
                return Optional.ofNullable(clazz.cast(this.publicProjectAlias()));
            }
            case "projectVisibility": {
                return Optional.ofNullable(clazz.cast(this.projectVisibilityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("projectArn", PROJECT_ARN_FIELD);
        map.put("publicProjectAlias", PUBLIC_PROJECT_ALIAS_FIELD);
        map.put("projectVisibility", PROJECT_VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProjectVisibilityResponse, T> g) {
        return obj -> g.apply((UpdateProjectVisibilityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private String projectArn;
        private String publicProjectAlias;
        private String projectVisibility;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectVisibilityResponse model) {
            super(model);
            this.projectArn(model.projectArn);
            this.publicProjectAlias(model.publicProjectAlias);
            this.projectVisibility(model.projectVisibility);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getPublicProjectAlias() {
            return this.publicProjectAlias;
        }

        public final void setPublicProjectAlias(String publicProjectAlias) {
            this.publicProjectAlias = publicProjectAlias;
        }

        @Override
        public final Builder publicProjectAlias(String publicProjectAlias) {
            this.publicProjectAlias = publicProjectAlias;
            return this;
        }

        public final String getProjectVisibility() {
            return this.projectVisibility;
        }

        public final void setProjectVisibility(String projectVisibility) {
            this.projectVisibility = projectVisibility;
        }

        @Override
        public final Builder projectVisibility(String projectVisibility) {
            this.projectVisibility = projectVisibility;
            return this;
        }

        @Override
        public final Builder projectVisibility(ProjectVisibilityType projectVisibility) {
            this.projectVisibility(projectVisibility == null ? null : projectVisibility.toString());
            return this;
        }

        @Override
        public UpdateProjectVisibilityResponse build() {
            return new UpdateProjectVisibilityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProjectVisibilityResponse> {
        public Builder projectArn(String var1);

        public Builder publicProjectAlias(String var1);

        public Builder projectVisibility(String var1);

        public Builder projectVisibility(ProjectVisibilityType var1);
    }
}

