/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.ComputeType;
import software.amazon.awssdk.services.codebuild.model.EnvironmentType;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariable;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.codebuild.model.GitSubmodulesConfig;
import software.amazon.awssdk.services.codebuild.model.ImagePullCredentialsType;
import software.amazon.awssdk.services.codebuild.model.LogsConfig;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifacts;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifactsListCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectBuildBatchConfig;
import software.amazon.awssdk.services.codebuild.model.ProjectCache;
import software.amazon.awssdk.services.codebuild.model.ProjectSecondarySourceVersionsCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion;
import software.amazon.awssdk.services.codebuild.model.ProjectSourcesCopier;
import software.amazon.awssdk.services.codebuild.model.RegistryCredential;
import software.amazon.awssdk.services.codebuild.model.SourceAuth;
import software.amazon.awssdk.services.codebuild.model.SourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartBuildBatchRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, StartBuildBatchRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::projectName)).setter(StartBuildBatchRequest.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<List<ProjectSource>> SECONDARY_SOURCES_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondarySourcesOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::secondarySourcesOverride)).setter(StartBuildBatchRequest.setter(Builder::secondarySourcesOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourcesOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProjectSourceVersion>> SECONDARY_SOURCES_VERSION_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondarySourcesVersionOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::secondarySourcesVersionOverride)).setter(StartBuildBatchRequest.setter(Builder::secondarySourcesVersionOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourcesVersionOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSourceVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceVersion").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::sourceVersion)).setter(StartBuildBatchRequest.setter(Builder::sourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()}).build();
    private static final SdkField<ProjectArtifacts> ARTIFACTS_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("artifactsOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::artifactsOverride)).setter(StartBuildBatchRequest.setter(Builder::artifactsOverride)).constructor(ProjectArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactsOverride").build()}).build();
    private static final SdkField<List<ProjectArtifacts>> SECONDARY_ARTIFACTS_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondaryArtifactsOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::secondaryArtifactsOverride)).setter(StartBuildBatchRequest.setter(Builder::secondaryArtifactsOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryArtifactsOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EnvironmentVariable>> ENVIRONMENT_VARIABLES_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environmentVariablesOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::environmentVariablesOverride)).setter(StartBuildBatchRequest.setter(Builder::environmentVariablesOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariablesOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentVariable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_TYPE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceTypeOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::sourceTypeOverrideAsString)).setter(StartBuildBatchRequest.setter(Builder::sourceTypeOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceTypeOverride").build()}).build();
    private static final SdkField<String> SOURCE_LOCATION_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceLocationOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::sourceLocationOverride)).setter(StartBuildBatchRequest.setter(Builder::sourceLocationOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceLocationOverride").build()}).build();
    private static final SdkField<SourceAuth> SOURCE_AUTH_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceAuthOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::sourceAuthOverride)).setter(StartBuildBatchRequest.setter(Builder::sourceAuthOverride)).constructor(SourceAuth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAuthOverride").build()}).build();
    private static final SdkField<Integer> GIT_CLONE_DEPTH_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("gitCloneDepthOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::gitCloneDepthOverride)).setter(StartBuildBatchRequest.setter(Builder::gitCloneDepthOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitCloneDepthOverride").build()}).build();
    private static final SdkField<GitSubmodulesConfig> GIT_SUBMODULES_CONFIG_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("gitSubmodulesConfigOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::gitSubmodulesConfigOverride)).setter(StartBuildBatchRequest.setter(Builder::gitSubmodulesConfigOverride)).constructor(GitSubmodulesConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitSubmodulesConfigOverride").build()}).build();
    private static final SdkField<String> BUILDSPEC_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildspecOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::buildspecOverride)).setter(StartBuildBatchRequest.setter(Builder::buildspecOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildspecOverride").build()}).build();
    private static final SdkField<Boolean> INSECURE_SSL_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("insecureSslOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::insecureSslOverride)).setter(StartBuildBatchRequest.setter(Builder::insecureSslOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insecureSslOverride").build()}).build();
    private static final SdkField<Boolean> REPORT_BUILD_BATCH_STATUS_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("reportBuildBatchStatusOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::reportBuildBatchStatusOverride)).setter(StartBuildBatchRequest.setter(Builder::reportBuildBatchStatusOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportBuildBatchStatusOverride").build()}).build();
    private static final SdkField<String> ENVIRONMENT_TYPE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentTypeOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::environmentTypeOverrideAsString)).setter(StartBuildBatchRequest.setter(Builder::environmentTypeOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentTypeOverride").build()}).build();
    private static final SdkField<String> IMAGE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::imageOverride)).setter(StartBuildBatchRequest.setter(Builder::imageOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageOverride").build()}).build();
    private static final SdkField<String> COMPUTE_TYPE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeTypeOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::computeTypeOverrideAsString)).setter(StartBuildBatchRequest.setter(Builder::computeTypeOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeTypeOverride").build()}).build();
    private static final SdkField<String> CERTIFICATE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::certificateOverride)).setter(StartBuildBatchRequest.setter(Builder::certificateOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateOverride").build()}).build();
    private static final SdkField<ProjectCache> CACHE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cacheOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::cacheOverride)).setter(StartBuildBatchRequest.setter(Builder::cacheOverride)).constructor(ProjectCache::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheOverride").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRoleOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::serviceRoleOverride)).setter(StartBuildBatchRequest.setter(Builder::serviceRoleOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRoleOverride").build()}).build();
    private static final SdkField<Boolean> PRIVILEGED_MODE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("privilegedModeOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::privilegedModeOverride)).setter(StartBuildBatchRequest.setter(Builder::privilegedModeOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privilegedModeOverride").build()}).build();
    private static final SdkField<Integer> BUILD_TIMEOUT_IN_MINUTES_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("buildTimeoutInMinutesOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::buildTimeoutInMinutesOverride)).setter(StartBuildBatchRequest.setter(Builder::buildTimeoutInMinutesOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildTimeoutInMinutesOverride").build()}).build();
    private static final SdkField<Integer> QUEUED_TIMEOUT_IN_MINUTES_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("queuedTimeoutInMinutesOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::queuedTimeoutInMinutesOverride)).setter(StartBuildBatchRequest.setter(Builder::queuedTimeoutInMinutesOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedTimeoutInMinutesOverride").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionKeyOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::encryptionKeyOverride)).setter(StartBuildBatchRequest.setter(Builder::encryptionKeyOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKeyOverride").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("idempotencyToken").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::idempotencyToken)).setter(StartBuildBatchRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idempotencyToken").build()}).build();
    private static final SdkField<LogsConfig> LOGS_CONFIG_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logsConfigOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::logsConfigOverride)).setter(StartBuildBatchRequest.setter(Builder::logsConfigOverride)).constructor(LogsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsConfigOverride").build()}).build();
    private static final SdkField<RegistryCredential> REGISTRY_CREDENTIAL_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("registryCredentialOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::registryCredentialOverride)).setter(StartBuildBatchRequest.setter(Builder::registryCredentialOverride)).constructor(RegistryCredential::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryCredentialOverride").build()}).build();
    private static final SdkField<String> IMAGE_PULL_CREDENTIALS_TYPE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imagePullCredentialsTypeOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::imagePullCredentialsTypeOverrideAsString)).setter(StartBuildBatchRequest.setter(Builder::imagePullCredentialsTypeOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePullCredentialsTypeOverride").build()}).build();
    private static final SdkField<ProjectBuildBatchConfig> BUILD_BATCH_CONFIG_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("buildBatchConfigOverride").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::buildBatchConfigOverride)).setter(StartBuildBatchRequest.setter(Builder::buildBatchConfigOverride)).constructor(ProjectBuildBatchConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildBatchConfigOverride").build()}).build();
    private static final SdkField<Boolean> DEBUG_SESSION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("debugSessionEnabled").getter(StartBuildBatchRequest.getter(StartBuildBatchRequest::debugSessionEnabled)).setter(StartBuildBatchRequest.setter(Builder::debugSessionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("debugSessionEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD, SECONDARY_SOURCES_OVERRIDE_FIELD, SECONDARY_SOURCES_VERSION_OVERRIDE_FIELD, SOURCE_VERSION_FIELD, ARTIFACTS_OVERRIDE_FIELD, SECONDARY_ARTIFACTS_OVERRIDE_FIELD, ENVIRONMENT_VARIABLES_OVERRIDE_FIELD, SOURCE_TYPE_OVERRIDE_FIELD, SOURCE_LOCATION_OVERRIDE_FIELD, SOURCE_AUTH_OVERRIDE_FIELD, GIT_CLONE_DEPTH_OVERRIDE_FIELD, GIT_SUBMODULES_CONFIG_OVERRIDE_FIELD, BUILDSPEC_OVERRIDE_FIELD, INSECURE_SSL_OVERRIDE_FIELD, REPORT_BUILD_BATCH_STATUS_OVERRIDE_FIELD, ENVIRONMENT_TYPE_OVERRIDE_FIELD, IMAGE_OVERRIDE_FIELD, COMPUTE_TYPE_OVERRIDE_FIELD, CERTIFICATE_OVERRIDE_FIELD, CACHE_OVERRIDE_FIELD, SERVICE_ROLE_OVERRIDE_FIELD, PRIVILEGED_MODE_OVERRIDE_FIELD, BUILD_TIMEOUT_IN_MINUTES_OVERRIDE_FIELD, QUEUED_TIMEOUT_IN_MINUTES_OVERRIDE_FIELD, ENCRYPTION_KEY_OVERRIDE_FIELD, IDEMPOTENCY_TOKEN_FIELD, LOGS_CONFIG_OVERRIDE_FIELD, REGISTRY_CREDENTIAL_OVERRIDE_FIELD, IMAGE_PULL_CREDENTIALS_TYPE_OVERRIDE_FIELD, BUILD_BATCH_CONFIG_OVERRIDE_FIELD, DEBUG_SESSION_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartBuildBatchRequest.memberNameToFieldInitializer();
    private final String projectName;
    private final List<ProjectSource> secondarySourcesOverride;
    private final List<ProjectSourceVersion> secondarySourcesVersionOverride;
    private final String sourceVersion;
    private final ProjectArtifacts artifactsOverride;
    private final List<ProjectArtifacts> secondaryArtifactsOverride;
    private final List<EnvironmentVariable> environmentVariablesOverride;
    private final String sourceTypeOverride;
    private final String sourceLocationOverride;
    private final SourceAuth sourceAuthOverride;
    private final Integer gitCloneDepthOverride;
    private final GitSubmodulesConfig gitSubmodulesConfigOverride;
    private final String buildspecOverride;
    private final Boolean insecureSslOverride;
    private final Boolean reportBuildBatchStatusOverride;
    private final String environmentTypeOverride;
    private final String imageOverride;
    private final String computeTypeOverride;
    private final String certificateOverride;
    private final ProjectCache cacheOverride;
    private final String serviceRoleOverride;
    private final Boolean privilegedModeOverride;
    private final Integer buildTimeoutInMinutesOverride;
    private final Integer queuedTimeoutInMinutesOverride;
    private final String encryptionKeyOverride;
    private final String idempotencyToken;
    private final LogsConfig logsConfigOverride;
    private final RegistryCredential registryCredentialOverride;
    private final String imagePullCredentialsTypeOverride;
    private final ProjectBuildBatchConfig buildBatchConfigOverride;
    private final Boolean debugSessionEnabled;

    private StartBuildBatchRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.secondarySourcesOverride = builder.secondarySourcesOverride;
        this.secondarySourcesVersionOverride = builder.secondarySourcesVersionOverride;
        this.sourceVersion = builder.sourceVersion;
        this.artifactsOverride = builder.artifactsOverride;
        this.secondaryArtifactsOverride = builder.secondaryArtifactsOverride;
        this.environmentVariablesOverride = builder.environmentVariablesOverride;
        this.sourceTypeOverride = builder.sourceTypeOverride;
        this.sourceLocationOverride = builder.sourceLocationOverride;
        this.sourceAuthOverride = builder.sourceAuthOverride;
        this.gitCloneDepthOverride = builder.gitCloneDepthOverride;
        this.gitSubmodulesConfigOverride = builder.gitSubmodulesConfigOverride;
        this.buildspecOverride = builder.buildspecOverride;
        this.insecureSslOverride = builder.insecureSslOverride;
        this.reportBuildBatchStatusOverride = builder.reportBuildBatchStatusOverride;
        this.environmentTypeOverride = builder.environmentTypeOverride;
        this.imageOverride = builder.imageOverride;
        this.computeTypeOverride = builder.computeTypeOverride;
        this.certificateOverride = builder.certificateOverride;
        this.cacheOverride = builder.cacheOverride;
        this.serviceRoleOverride = builder.serviceRoleOverride;
        this.privilegedModeOverride = builder.privilegedModeOverride;
        this.buildTimeoutInMinutesOverride = builder.buildTimeoutInMinutesOverride;
        this.queuedTimeoutInMinutesOverride = builder.queuedTimeoutInMinutesOverride;
        this.encryptionKeyOverride = builder.encryptionKeyOverride;
        this.idempotencyToken = builder.idempotencyToken;
        this.logsConfigOverride = builder.logsConfigOverride;
        this.registryCredentialOverride = builder.registryCredentialOverride;
        this.imagePullCredentialsTypeOverride = builder.imagePullCredentialsTypeOverride;
        this.buildBatchConfigOverride = builder.buildBatchConfigOverride;
        this.debugSessionEnabled = builder.debugSessionEnabled;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final boolean hasSecondarySourcesOverride() {
        return this.secondarySourcesOverride != null && !(this.secondarySourcesOverride instanceof SdkAutoConstructList);
    }

    public final List<ProjectSource> secondarySourcesOverride() {
        return this.secondarySourcesOverride;
    }

    public final boolean hasSecondarySourcesVersionOverride() {
        return this.secondarySourcesVersionOverride != null && !(this.secondarySourcesVersionOverride instanceof SdkAutoConstructList);
    }

    public final List<ProjectSourceVersion> secondarySourcesVersionOverride() {
        return this.secondarySourcesVersionOverride;
    }

    public final String sourceVersion() {
        return this.sourceVersion;
    }

    public final ProjectArtifacts artifactsOverride() {
        return this.artifactsOverride;
    }

    public final boolean hasSecondaryArtifactsOverride() {
        return this.secondaryArtifactsOverride != null && !(this.secondaryArtifactsOverride instanceof SdkAutoConstructList);
    }

    public final List<ProjectArtifacts> secondaryArtifactsOverride() {
        return this.secondaryArtifactsOverride;
    }

    public final boolean hasEnvironmentVariablesOverride() {
        return this.environmentVariablesOverride != null && !(this.environmentVariablesOverride instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentVariable> environmentVariablesOverride() {
        return this.environmentVariablesOverride;
    }

    public final SourceType sourceTypeOverride() {
        return SourceType.fromValue(this.sourceTypeOverride);
    }

    public final String sourceTypeOverrideAsString() {
        return this.sourceTypeOverride;
    }

    public final String sourceLocationOverride() {
        return this.sourceLocationOverride;
    }

    public final SourceAuth sourceAuthOverride() {
        return this.sourceAuthOverride;
    }

    public final Integer gitCloneDepthOverride() {
        return this.gitCloneDepthOverride;
    }

    public final GitSubmodulesConfig gitSubmodulesConfigOverride() {
        return this.gitSubmodulesConfigOverride;
    }

    public final String buildspecOverride() {
        return this.buildspecOverride;
    }

    public final Boolean insecureSslOverride() {
        return this.insecureSslOverride;
    }

    public final Boolean reportBuildBatchStatusOverride() {
        return this.reportBuildBatchStatusOverride;
    }

    public final EnvironmentType environmentTypeOverride() {
        return EnvironmentType.fromValue(this.environmentTypeOverride);
    }

    public final String environmentTypeOverrideAsString() {
        return this.environmentTypeOverride;
    }

    public final String imageOverride() {
        return this.imageOverride;
    }

    public final ComputeType computeTypeOverride() {
        return ComputeType.fromValue(this.computeTypeOverride);
    }

    public final String computeTypeOverrideAsString() {
        return this.computeTypeOverride;
    }

    public final String certificateOverride() {
        return this.certificateOverride;
    }

    public final ProjectCache cacheOverride() {
        return this.cacheOverride;
    }

    public final String serviceRoleOverride() {
        return this.serviceRoleOverride;
    }

    public final Boolean privilegedModeOverride() {
        return this.privilegedModeOverride;
    }

    public final Integer buildTimeoutInMinutesOverride() {
        return this.buildTimeoutInMinutesOverride;
    }

    public final Integer queuedTimeoutInMinutesOverride() {
        return this.queuedTimeoutInMinutesOverride;
    }

    public final String encryptionKeyOverride() {
        return this.encryptionKeyOverride;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    public final LogsConfig logsConfigOverride() {
        return this.logsConfigOverride;
    }

    public final RegistryCredential registryCredentialOverride() {
        return this.registryCredentialOverride;
    }

    public final ImagePullCredentialsType imagePullCredentialsTypeOverride() {
        return ImagePullCredentialsType.fromValue(this.imagePullCredentialsTypeOverride);
    }

    public final String imagePullCredentialsTypeOverrideAsString() {
        return this.imagePullCredentialsTypeOverride;
    }

    public final ProjectBuildBatchConfig buildBatchConfigOverride() {
        return this.buildBatchConfigOverride;
    }

    public final Boolean debugSessionEnabled() {
        return this.debugSessionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondarySourcesOverride() ? this.secondarySourcesOverride() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondarySourcesVersionOverride() ? this.secondarySourcesVersionOverride() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactsOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondaryArtifactsOverride() ? this.secondaryArtifactsOverride() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariablesOverride() ? this.environmentVariablesOverride() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAuthOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitCloneDepthOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitSubmodulesConfigOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildspecOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.insecureSslOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportBuildBatchStatusOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.privilegedModeOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildTimeoutInMinutesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedTimeoutInMinutesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.logsConfigOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryCredentialOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePullCredentialsTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildBatchConfigOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.debugSessionEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBuildBatchRequest)) {
            return false;
        }
        StartBuildBatchRequest other = (StartBuildBatchRequest)((Object)obj);
        return Objects.equals(this.projectName(), other.projectName()) && this.hasSecondarySourcesOverride() == other.hasSecondarySourcesOverride() && Objects.equals(this.secondarySourcesOverride(), other.secondarySourcesOverride()) && this.hasSecondarySourcesVersionOverride() == other.hasSecondarySourcesVersionOverride() && Objects.equals(this.secondarySourcesVersionOverride(), other.secondarySourcesVersionOverride()) && Objects.equals(this.sourceVersion(), other.sourceVersion()) && Objects.equals(this.artifactsOverride(), other.artifactsOverride()) && this.hasSecondaryArtifactsOverride() == other.hasSecondaryArtifactsOverride() && Objects.equals(this.secondaryArtifactsOverride(), other.secondaryArtifactsOverride()) && this.hasEnvironmentVariablesOverride() == other.hasEnvironmentVariablesOverride() && Objects.equals(this.environmentVariablesOverride(), other.environmentVariablesOverride()) && Objects.equals(this.sourceTypeOverrideAsString(), other.sourceTypeOverrideAsString()) && Objects.equals(this.sourceLocationOverride(), other.sourceLocationOverride()) && Objects.equals(this.sourceAuthOverride(), other.sourceAuthOverride()) && Objects.equals(this.gitCloneDepthOverride(), other.gitCloneDepthOverride()) && Objects.equals(this.gitSubmodulesConfigOverride(), other.gitSubmodulesConfigOverride()) && Objects.equals(this.buildspecOverride(), other.buildspecOverride()) && Objects.equals(this.insecureSslOverride(), other.insecureSslOverride()) && Objects.equals(this.reportBuildBatchStatusOverride(), other.reportBuildBatchStatusOverride()) && Objects.equals(this.environmentTypeOverrideAsString(), other.environmentTypeOverrideAsString()) && Objects.equals(this.imageOverride(), other.imageOverride()) && Objects.equals(this.computeTypeOverrideAsString(), other.computeTypeOverrideAsString()) && Objects.equals(this.certificateOverride(), other.certificateOverride()) && Objects.equals(this.cacheOverride(), other.cacheOverride()) && Objects.equals(this.serviceRoleOverride(), other.serviceRoleOverride()) && Objects.equals(this.privilegedModeOverride(), other.privilegedModeOverride()) && Objects.equals(this.buildTimeoutInMinutesOverride(), other.buildTimeoutInMinutesOverride()) && Objects.equals(this.queuedTimeoutInMinutesOverride(), other.queuedTimeoutInMinutesOverride()) && Objects.equals(this.encryptionKeyOverride(), other.encryptionKeyOverride()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && Objects.equals(this.logsConfigOverride(), other.logsConfigOverride()) && Objects.equals(this.registryCredentialOverride(), other.registryCredentialOverride()) && Objects.equals(this.imagePullCredentialsTypeOverrideAsString(), other.imagePullCredentialsTypeOverrideAsString()) && Objects.equals(this.buildBatchConfigOverride(), other.buildBatchConfigOverride()) && Objects.equals(this.debugSessionEnabled(), other.debugSessionEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"StartBuildBatchRequest").add("ProjectName", (Object)this.projectName()).add("SecondarySourcesOverride", this.hasSecondarySourcesOverride() ? this.secondarySourcesOverride() : null).add("SecondarySourcesVersionOverride", this.hasSecondarySourcesVersionOverride() ? this.secondarySourcesVersionOverride() : null).add("SourceVersion", (Object)this.sourceVersion()).add("ArtifactsOverride", (Object)this.artifactsOverride()).add("SecondaryArtifactsOverride", this.hasSecondaryArtifactsOverride() ? this.secondaryArtifactsOverride() : null).add("EnvironmentVariablesOverride", this.hasEnvironmentVariablesOverride() ? this.environmentVariablesOverride() : null).add("SourceTypeOverride", (Object)this.sourceTypeOverrideAsString()).add("SourceLocationOverride", (Object)this.sourceLocationOverride()).add("SourceAuthOverride", (Object)this.sourceAuthOverride()).add("GitCloneDepthOverride", (Object)this.gitCloneDepthOverride()).add("GitSubmodulesConfigOverride", (Object)this.gitSubmodulesConfigOverride()).add("BuildspecOverride", (Object)this.buildspecOverride()).add("InsecureSslOverride", (Object)this.insecureSslOverride()).add("ReportBuildBatchStatusOverride", (Object)this.reportBuildBatchStatusOverride()).add("EnvironmentTypeOverride", (Object)this.environmentTypeOverrideAsString()).add("ImageOverride", (Object)this.imageOverride()).add("ComputeTypeOverride", (Object)this.computeTypeOverrideAsString()).add("CertificateOverride", (Object)this.certificateOverride()).add("CacheOverride", (Object)this.cacheOverride()).add("ServiceRoleOverride", (Object)this.serviceRoleOverride()).add("PrivilegedModeOverride", (Object)this.privilegedModeOverride()).add("BuildTimeoutInMinutesOverride", (Object)this.buildTimeoutInMinutesOverride()).add("QueuedTimeoutInMinutesOverride", (Object)this.queuedTimeoutInMinutesOverride()).add("EncryptionKeyOverride", (Object)this.encryptionKeyOverride()).add("IdempotencyToken", (Object)this.idempotencyToken()).add("LogsConfigOverride", (Object)this.logsConfigOverride()).add("RegistryCredentialOverride", (Object)this.registryCredentialOverride()).add("ImagePullCredentialsTypeOverride", (Object)this.imagePullCredentialsTypeOverrideAsString()).add("BuildBatchConfigOverride", (Object)this.buildBatchConfigOverride()).add("DebugSessionEnabled", (Object)this.debugSessionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "secondarySourcesOverride": {
                return Optional.ofNullable(clazz.cast(this.secondarySourcesOverride()));
            }
            case "secondarySourcesVersionOverride": {
                return Optional.ofNullable(clazz.cast(this.secondarySourcesVersionOverride()));
            }
            case "sourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "artifactsOverride": {
                return Optional.ofNullable(clazz.cast(this.artifactsOverride()));
            }
            case "secondaryArtifactsOverride": {
                return Optional.ofNullable(clazz.cast(this.secondaryArtifactsOverride()));
            }
            case "environmentVariablesOverride": {
                return Optional.ofNullable(clazz.cast(this.environmentVariablesOverride()));
            }
            case "sourceTypeOverride": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeOverrideAsString()));
            }
            case "sourceLocationOverride": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationOverride()));
            }
            case "sourceAuthOverride": {
                return Optional.ofNullable(clazz.cast(this.sourceAuthOverride()));
            }
            case "gitCloneDepthOverride": {
                return Optional.ofNullable(clazz.cast(this.gitCloneDepthOverride()));
            }
            case "gitSubmodulesConfigOverride": {
                return Optional.ofNullable(clazz.cast(this.gitSubmodulesConfigOverride()));
            }
            case "buildspecOverride": {
                return Optional.ofNullable(clazz.cast(this.buildspecOverride()));
            }
            case "insecureSslOverride": {
                return Optional.ofNullable(clazz.cast(this.insecureSslOverride()));
            }
            case "reportBuildBatchStatusOverride": {
                return Optional.ofNullable(clazz.cast(this.reportBuildBatchStatusOverride()));
            }
            case "environmentTypeOverride": {
                return Optional.ofNullable(clazz.cast(this.environmentTypeOverrideAsString()));
            }
            case "imageOverride": {
                return Optional.ofNullable(clazz.cast(this.imageOverride()));
            }
            case "computeTypeOverride": {
                return Optional.ofNullable(clazz.cast(this.computeTypeOverrideAsString()));
            }
            case "certificateOverride": {
                return Optional.ofNullable(clazz.cast(this.certificateOverride()));
            }
            case "cacheOverride": {
                return Optional.ofNullable(clazz.cast(this.cacheOverride()));
            }
            case "serviceRoleOverride": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleOverride()));
            }
            case "privilegedModeOverride": {
                return Optional.ofNullable(clazz.cast(this.privilegedModeOverride()));
            }
            case "buildTimeoutInMinutesOverride": {
                return Optional.ofNullable(clazz.cast(this.buildTimeoutInMinutesOverride()));
            }
            case "queuedTimeoutInMinutesOverride": {
                return Optional.ofNullable(clazz.cast(this.queuedTimeoutInMinutesOverride()));
            }
            case "encryptionKeyOverride": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyOverride()));
            }
            case "idempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
            case "logsConfigOverride": {
                return Optional.ofNullable(clazz.cast(this.logsConfigOverride()));
            }
            case "registryCredentialOverride": {
                return Optional.ofNullable(clazz.cast(this.registryCredentialOverride()));
            }
            case "imagePullCredentialsTypeOverride": {
                return Optional.ofNullable(clazz.cast(this.imagePullCredentialsTypeOverrideAsString()));
            }
            case "buildBatchConfigOverride": {
                return Optional.ofNullable(clazz.cast(this.buildBatchConfigOverride()));
            }
            case "debugSessionEnabled": {
                return Optional.ofNullable(clazz.cast(this.debugSessionEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("secondarySourcesOverride", SECONDARY_SOURCES_OVERRIDE_FIELD);
        map.put("secondarySourcesVersionOverride", SECONDARY_SOURCES_VERSION_OVERRIDE_FIELD);
        map.put("sourceVersion", SOURCE_VERSION_FIELD);
        map.put("artifactsOverride", ARTIFACTS_OVERRIDE_FIELD);
        map.put("secondaryArtifactsOverride", SECONDARY_ARTIFACTS_OVERRIDE_FIELD);
        map.put("environmentVariablesOverride", ENVIRONMENT_VARIABLES_OVERRIDE_FIELD);
        map.put("sourceTypeOverride", SOURCE_TYPE_OVERRIDE_FIELD);
        map.put("sourceLocationOverride", SOURCE_LOCATION_OVERRIDE_FIELD);
        map.put("sourceAuthOverride", SOURCE_AUTH_OVERRIDE_FIELD);
        map.put("gitCloneDepthOverride", GIT_CLONE_DEPTH_OVERRIDE_FIELD);
        map.put("gitSubmodulesConfigOverride", GIT_SUBMODULES_CONFIG_OVERRIDE_FIELD);
        map.put("buildspecOverride", BUILDSPEC_OVERRIDE_FIELD);
        map.put("insecureSslOverride", INSECURE_SSL_OVERRIDE_FIELD);
        map.put("reportBuildBatchStatusOverride", REPORT_BUILD_BATCH_STATUS_OVERRIDE_FIELD);
        map.put("environmentTypeOverride", ENVIRONMENT_TYPE_OVERRIDE_FIELD);
        map.put("imageOverride", IMAGE_OVERRIDE_FIELD);
        map.put("computeTypeOverride", COMPUTE_TYPE_OVERRIDE_FIELD);
        map.put("certificateOverride", CERTIFICATE_OVERRIDE_FIELD);
        map.put("cacheOverride", CACHE_OVERRIDE_FIELD);
        map.put("serviceRoleOverride", SERVICE_ROLE_OVERRIDE_FIELD);
        map.put("privilegedModeOverride", PRIVILEGED_MODE_OVERRIDE_FIELD);
        map.put("buildTimeoutInMinutesOverride", BUILD_TIMEOUT_IN_MINUTES_OVERRIDE_FIELD);
        map.put("queuedTimeoutInMinutesOverride", QUEUED_TIMEOUT_IN_MINUTES_OVERRIDE_FIELD);
        map.put("encryptionKeyOverride", ENCRYPTION_KEY_OVERRIDE_FIELD);
        map.put("idempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        map.put("logsConfigOverride", LOGS_CONFIG_OVERRIDE_FIELD);
        map.put("registryCredentialOverride", REGISTRY_CREDENTIAL_OVERRIDE_FIELD);
        map.put("imagePullCredentialsTypeOverride", IMAGE_PULL_CREDENTIALS_TYPE_OVERRIDE_FIELD);
        map.put("buildBatchConfigOverride", BUILD_BATCH_CONFIG_OVERRIDE_FIELD);
        map.put("debugSessionEnabled", DEBUG_SESSION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartBuildBatchRequest, T> g) {
        return obj -> g.apply((StartBuildBatchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String projectName;
        private List<ProjectSource> secondarySourcesOverride = DefaultSdkAutoConstructList.getInstance();
        private List<ProjectSourceVersion> secondarySourcesVersionOverride = DefaultSdkAutoConstructList.getInstance();
        private String sourceVersion;
        private ProjectArtifacts artifactsOverride;
        private List<ProjectArtifacts> secondaryArtifactsOverride = DefaultSdkAutoConstructList.getInstance();
        private List<EnvironmentVariable> environmentVariablesOverride = DefaultSdkAutoConstructList.getInstance();
        private String sourceTypeOverride;
        private String sourceLocationOverride;
        private SourceAuth sourceAuthOverride;
        private Integer gitCloneDepthOverride;
        private GitSubmodulesConfig gitSubmodulesConfigOverride;
        private String buildspecOverride;
        private Boolean insecureSslOverride;
        private Boolean reportBuildBatchStatusOverride;
        private String environmentTypeOverride;
        private String imageOverride;
        private String computeTypeOverride;
        private String certificateOverride;
        private ProjectCache cacheOverride;
        private String serviceRoleOverride;
        private Boolean privilegedModeOverride;
        private Integer buildTimeoutInMinutesOverride;
        private Integer queuedTimeoutInMinutesOverride;
        private String encryptionKeyOverride;
        private String idempotencyToken;
        private LogsConfig logsConfigOverride;
        private RegistryCredential registryCredentialOverride;
        private String imagePullCredentialsTypeOverride;
        private ProjectBuildBatchConfig buildBatchConfigOverride;
        private Boolean debugSessionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBuildBatchRequest model) {
            super(model);
            this.projectName(model.projectName);
            this.secondarySourcesOverride(model.secondarySourcesOverride);
            this.secondarySourcesVersionOverride(model.secondarySourcesVersionOverride);
            this.sourceVersion(model.sourceVersion);
            this.artifactsOverride(model.artifactsOverride);
            this.secondaryArtifactsOverride(model.secondaryArtifactsOverride);
            this.environmentVariablesOverride(model.environmentVariablesOverride);
            this.sourceTypeOverride(model.sourceTypeOverride);
            this.sourceLocationOverride(model.sourceLocationOverride);
            this.sourceAuthOverride(model.sourceAuthOverride);
            this.gitCloneDepthOverride(model.gitCloneDepthOverride);
            this.gitSubmodulesConfigOverride(model.gitSubmodulesConfigOverride);
            this.buildspecOverride(model.buildspecOverride);
            this.insecureSslOverride(model.insecureSslOverride);
            this.reportBuildBatchStatusOverride(model.reportBuildBatchStatusOverride);
            this.environmentTypeOverride(model.environmentTypeOverride);
            this.imageOverride(model.imageOverride);
            this.computeTypeOverride(model.computeTypeOverride);
            this.certificateOverride(model.certificateOverride);
            this.cacheOverride(model.cacheOverride);
            this.serviceRoleOverride(model.serviceRoleOverride);
            this.privilegedModeOverride(model.privilegedModeOverride);
            this.buildTimeoutInMinutesOverride(model.buildTimeoutInMinutesOverride);
            this.queuedTimeoutInMinutesOverride(model.queuedTimeoutInMinutesOverride);
            this.encryptionKeyOverride(model.encryptionKeyOverride);
            this.idempotencyToken(model.idempotencyToken);
            this.logsConfigOverride(model.logsConfigOverride);
            this.registryCredentialOverride(model.registryCredentialOverride);
            this.imagePullCredentialsTypeOverride(model.imagePullCredentialsTypeOverride);
            this.buildBatchConfigOverride(model.buildBatchConfigOverride);
            this.debugSessionEnabled(model.debugSessionEnabled);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final List<ProjectSource.Builder> getSecondarySourcesOverride() {
            List<ProjectSource.Builder> result = ProjectSourcesCopier.copyToBuilder(this.secondarySourcesOverride);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySourcesOverride(Collection<ProjectSource.BuilderImpl> secondarySourcesOverride) {
            this.secondarySourcesOverride = ProjectSourcesCopier.copyFromBuilder(secondarySourcesOverride);
        }

        @Override
        public final Builder secondarySourcesOverride(Collection<ProjectSource> secondarySourcesOverride) {
            this.secondarySourcesOverride = ProjectSourcesCopier.copy(secondarySourcesOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesOverride(ProjectSource ... secondarySourcesOverride) {
            this.secondarySourcesOverride(Arrays.asList(secondarySourcesOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesOverride(Consumer<ProjectSource.Builder> ... secondarySourcesOverride) {
            this.secondarySourcesOverride(Stream.of(secondarySourcesOverride).map(c -> (ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProjectSourceVersion.Builder> getSecondarySourcesVersionOverride() {
            List<ProjectSourceVersion.Builder> result = ProjectSecondarySourceVersionsCopier.copyToBuilder(this.secondarySourcesVersionOverride);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySourcesVersionOverride(Collection<ProjectSourceVersion.BuilderImpl> secondarySourcesVersionOverride) {
            this.secondarySourcesVersionOverride = ProjectSecondarySourceVersionsCopier.copyFromBuilder(secondarySourcesVersionOverride);
        }

        @Override
        public final Builder secondarySourcesVersionOverride(Collection<ProjectSourceVersion> secondarySourcesVersionOverride) {
            this.secondarySourcesVersionOverride = ProjectSecondarySourceVersionsCopier.copy(secondarySourcesVersionOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesVersionOverride(ProjectSourceVersion ... secondarySourcesVersionOverride) {
            this.secondarySourcesVersionOverride(Arrays.asList(secondarySourcesVersionOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesVersionOverride(Consumer<ProjectSourceVersion.Builder> ... secondarySourcesVersionOverride) {
            this.secondarySourcesVersionOverride(Stream.of(secondarySourcesVersionOverride).map(c -> (ProjectSourceVersion)((ProjectSourceVersion.Builder)ProjectSourceVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final ProjectArtifacts.Builder getArtifactsOverride() {
            return this.artifactsOverride != null ? this.artifactsOverride.toBuilder() : null;
        }

        public final void setArtifactsOverride(ProjectArtifacts.BuilderImpl artifactsOverride) {
            this.artifactsOverride = artifactsOverride != null ? artifactsOverride.build() : null;
        }

        @Override
        public final Builder artifactsOverride(ProjectArtifacts artifactsOverride) {
            this.artifactsOverride = artifactsOverride;
            return this;
        }

        public final List<ProjectArtifacts.Builder> getSecondaryArtifactsOverride() {
            List<ProjectArtifacts.Builder> result = ProjectArtifactsListCopier.copyToBuilder(this.secondaryArtifactsOverride);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondaryArtifactsOverride(Collection<ProjectArtifacts.BuilderImpl> secondaryArtifactsOverride) {
            this.secondaryArtifactsOverride = ProjectArtifactsListCopier.copyFromBuilder(secondaryArtifactsOverride);
        }

        @Override
        public final Builder secondaryArtifactsOverride(Collection<ProjectArtifacts> secondaryArtifactsOverride) {
            this.secondaryArtifactsOverride = ProjectArtifactsListCopier.copy(secondaryArtifactsOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifactsOverride(ProjectArtifacts ... secondaryArtifactsOverride) {
            this.secondaryArtifactsOverride(Arrays.asList(secondaryArtifactsOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifactsOverride(Consumer<ProjectArtifacts.Builder> ... secondaryArtifactsOverride) {
            this.secondaryArtifactsOverride(Stream.of(secondaryArtifactsOverride).map(c -> (ProjectArtifacts)((ProjectArtifacts.Builder)ProjectArtifacts.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EnvironmentVariable.Builder> getEnvironmentVariablesOverride() {
            List<EnvironmentVariable.Builder> result = EnvironmentVariablesCopier.copyToBuilder(this.environmentVariablesOverride);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentVariablesOverride(Collection<EnvironmentVariable.BuilderImpl> environmentVariablesOverride) {
            this.environmentVariablesOverride = EnvironmentVariablesCopier.copyFromBuilder(environmentVariablesOverride);
        }

        @Override
        public final Builder environmentVariablesOverride(Collection<EnvironmentVariable> environmentVariablesOverride) {
            this.environmentVariablesOverride = EnvironmentVariablesCopier.copy(environmentVariablesOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariablesOverride(EnvironmentVariable ... environmentVariablesOverride) {
            this.environmentVariablesOverride(Arrays.asList(environmentVariablesOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariablesOverride(Consumer<EnvironmentVariable.Builder> ... environmentVariablesOverride) {
            this.environmentVariablesOverride(Stream.of(environmentVariablesOverride).map(c -> (EnvironmentVariable)((EnvironmentVariable.Builder)EnvironmentVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceTypeOverride() {
            return this.sourceTypeOverride;
        }

        public final void setSourceTypeOverride(String sourceTypeOverride) {
            this.sourceTypeOverride = sourceTypeOverride;
        }

        @Override
        public final Builder sourceTypeOverride(String sourceTypeOverride) {
            this.sourceTypeOverride = sourceTypeOverride;
            return this;
        }

        @Override
        public final Builder sourceTypeOverride(SourceType sourceTypeOverride) {
            this.sourceTypeOverride(sourceTypeOverride == null ? null : sourceTypeOverride.toString());
            return this;
        }

        public final String getSourceLocationOverride() {
            return this.sourceLocationOverride;
        }

        public final void setSourceLocationOverride(String sourceLocationOverride) {
            this.sourceLocationOverride = sourceLocationOverride;
        }

        @Override
        public final Builder sourceLocationOverride(String sourceLocationOverride) {
            this.sourceLocationOverride = sourceLocationOverride;
            return this;
        }

        public final SourceAuth.Builder getSourceAuthOverride() {
            return this.sourceAuthOverride != null ? this.sourceAuthOverride.toBuilder() : null;
        }

        public final void setSourceAuthOverride(SourceAuth.BuilderImpl sourceAuthOverride) {
            this.sourceAuthOverride = sourceAuthOverride != null ? sourceAuthOverride.build() : null;
        }

        @Override
        public final Builder sourceAuthOverride(SourceAuth sourceAuthOverride) {
            this.sourceAuthOverride = sourceAuthOverride;
            return this;
        }

        public final Integer getGitCloneDepthOverride() {
            return this.gitCloneDepthOverride;
        }

        public final void setGitCloneDepthOverride(Integer gitCloneDepthOverride) {
            this.gitCloneDepthOverride = gitCloneDepthOverride;
        }

        @Override
        public final Builder gitCloneDepthOverride(Integer gitCloneDepthOverride) {
            this.gitCloneDepthOverride = gitCloneDepthOverride;
            return this;
        }

        public final GitSubmodulesConfig.Builder getGitSubmodulesConfigOverride() {
            return this.gitSubmodulesConfigOverride != null ? this.gitSubmodulesConfigOverride.toBuilder() : null;
        }

        public final void setGitSubmodulesConfigOverride(GitSubmodulesConfig.BuilderImpl gitSubmodulesConfigOverride) {
            this.gitSubmodulesConfigOverride = gitSubmodulesConfigOverride != null ? gitSubmodulesConfigOverride.build() : null;
        }

        @Override
        public final Builder gitSubmodulesConfigOverride(GitSubmodulesConfig gitSubmodulesConfigOverride) {
            this.gitSubmodulesConfigOverride = gitSubmodulesConfigOverride;
            return this;
        }

        public final String getBuildspecOverride() {
            return this.buildspecOverride;
        }

        public final void setBuildspecOverride(String buildspecOverride) {
            this.buildspecOverride = buildspecOverride;
        }

        @Override
        public final Builder buildspecOverride(String buildspecOverride) {
            this.buildspecOverride = buildspecOverride;
            return this;
        }

        public final Boolean getInsecureSslOverride() {
            return this.insecureSslOverride;
        }

        public final void setInsecureSslOverride(Boolean insecureSslOverride) {
            this.insecureSslOverride = insecureSslOverride;
        }

        @Override
        public final Builder insecureSslOverride(Boolean insecureSslOverride) {
            this.insecureSslOverride = insecureSslOverride;
            return this;
        }

        public final Boolean getReportBuildBatchStatusOverride() {
            return this.reportBuildBatchStatusOverride;
        }

        public final void setReportBuildBatchStatusOverride(Boolean reportBuildBatchStatusOverride) {
            this.reportBuildBatchStatusOverride = reportBuildBatchStatusOverride;
        }

        @Override
        public final Builder reportBuildBatchStatusOverride(Boolean reportBuildBatchStatusOverride) {
            this.reportBuildBatchStatusOverride = reportBuildBatchStatusOverride;
            return this;
        }

        public final String getEnvironmentTypeOverride() {
            return this.environmentTypeOverride;
        }

        public final void setEnvironmentTypeOverride(String environmentTypeOverride) {
            this.environmentTypeOverride = environmentTypeOverride;
        }

        @Override
        public final Builder environmentTypeOverride(String environmentTypeOverride) {
            this.environmentTypeOverride = environmentTypeOverride;
            return this;
        }

        @Override
        public final Builder environmentTypeOverride(EnvironmentType environmentTypeOverride) {
            this.environmentTypeOverride(environmentTypeOverride == null ? null : environmentTypeOverride.toString());
            return this;
        }

        public final String getImageOverride() {
            return this.imageOverride;
        }

        public final void setImageOverride(String imageOverride) {
            this.imageOverride = imageOverride;
        }

        @Override
        public final Builder imageOverride(String imageOverride) {
            this.imageOverride = imageOverride;
            return this;
        }

        public final String getComputeTypeOverride() {
            return this.computeTypeOverride;
        }

        public final void setComputeTypeOverride(String computeTypeOverride) {
            this.computeTypeOverride = computeTypeOverride;
        }

        @Override
        public final Builder computeTypeOverride(String computeTypeOverride) {
            this.computeTypeOverride = computeTypeOverride;
            return this;
        }

        @Override
        public final Builder computeTypeOverride(ComputeType computeTypeOverride) {
            this.computeTypeOverride(computeTypeOverride == null ? null : computeTypeOverride.toString());
            return this;
        }

        public final String getCertificateOverride() {
            return this.certificateOverride;
        }

        public final void setCertificateOverride(String certificateOverride) {
            this.certificateOverride = certificateOverride;
        }

        @Override
        public final Builder certificateOverride(String certificateOverride) {
            this.certificateOverride = certificateOverride;
            return this;
        }

        public final ProjectCache.Builder getCacheOverride() {
            return this.cacheOverride != null ? this.cacheOverride.toBuilder() : null;
        }

        public final void setCacheOverride(ProjectCache.BuilderImpl cacheOverride) {
            this.cacheOverride = cacheOverride != null ? cacheOverride.build() : null;
        }

        @Override
        public final Builder cacheOverride(ProjectCache cacheOverride) {
            this.cacheOverride = cacheOverride;
            return this;
        }

        public final String getServiceRoleOverride() {
            return this.serviceRoleOverride;
        }

        public final void setServiceRoleOverride(String serviceRoleOverride) {
            this.serviceRoleOverride = serviceRoleOverride;
        }

        @Override
        public final Builder serviceRoleOverride(String serviceRoleOverride) {
            this.serviceRoleOverride = serviceRoleOverride;
            return this;
        }

        public final Boolean getPrivilegedModeOverride() {
            return this.privilegedModeOverride;
        }

        public final void setPrivilegedModeOverride(Boolean privilegedModeOverride) {
            this.privilegedModeOverride = privilegedModeOverride;
        }

        @Override
        public final Builder privilegedModeOverride(Boolean privilegedModeOverride) {
            this.privilegedModeOverride = privilegedModeOverride;
            return this;
        }

        public final Integer getBuildTimeoutInMinutesOverride() {
            return this.buildTimeoutInMinutesOverride;
        }

        public final void setBuildTimeoutInMinutesOverride(Integer buildTimeoutInMinutesOverride) {
            this.buildTimeoutInMinutesOverride = buildTimeoutInMinutesOverride;
        }

        @Override
        public final Builder buildTimeoutInMinutesOverride(Integer buildTimeoutInMinutesOverride) {
            this.buildTimeoutInMinutesOverride = buildTimeoutInMinutesOverride;
            return this;
        }

        public final Integer getQueuedTimeoutInMinutesOverride() {
            return this.queuedTimeoutInMinutesOverride;
        }

        public final void setQueuedTimeoutInMinutesOverride(Integer queuedTimeoutInMinutesOverride) {
            this.queuedTimeoutInMinutesOverride = queuedTimeoutInMinutesOverride;
        }

        @Override
        public final Builder queuedTimeoutInMinutesOverride(Integer queuedTimeoutInMinutesOverride) {
            this.queuedTimeoutInMinutesOverride = queuedTimeoutInMinutesOverride;
            return this;
        }

        public final String getEncryptionKeyOverride() {
            return this.encryptionKeyOverride;
        }

        public final void setEncryptionKeyOverride(String encryptionKeyOverride) {
            this.encryptionKeyOverride = encryptionKeyOverride;
        }

        @Override
        public final Builder encryptionKeyOverride(String encryptionKeyOverride) {
            this.encryptionKeyOverride = encryptionKeyOverride;
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final LogsConfig.Builder getLogsConfigOverride() {
            return this.logsConfigOverride != null ? this.logsConfigOverride.toBuilder() : null;
        }

        public final void setLogsConfigOverride(LogsConfig.BuilderImpl logsConfigOverride) {
            this.logsConfigOverride = logsConfigOverride != null ? logsConfigOverride.build() : null;
        }

        @Override
        public final Builder logsConfigOverride(LogsConfig logsConfigOverride) {
            this.logsConfigOverride = logsConfigOverride;
            return this;
        }

        public final RegistryCredential.Builder getRegistryCredentialOverride() {
            return this.registryCredentialOverride != null ? this.registryCredentialOverride.toBuilder() : null;
        }

        public final void setRegistryCredentialOverride(RegistryCredential.BuilderImpl registryCredentialOverride) {
            this.registryCredentialOverride = registryCredentialOverride != null ? registryCredentialOverride.build() : null;
        }

        @Override
        public final Builder registryCredentialOverride(RegistryCredential registryCredentialOverride) {
            this.registryCredentialOverride = registryCredentialOverride;
            return this;
        }

        public final String getImagePullCredentialsTypeOverride() {
            return this.imagePullCredentialsTypeOverride;
        }

        public final void setImagePullCredentialsTypeOverride(String imagePullCredentialsTypeOverride) {
            this.imagePullCredentialsTypeOverride = imagePullCredentialsTypeOverride;
        }

        @Override
        public final Builder imagePullCredentialsTypeOverride(String imagePullCredentialsTypeOverride) {
            this.imagePullCredentialsTypeOverride = imagePullCredentialsTypeOverride;
            return this;
        }

        @Override
        public final Builder imagePullCredentialsTypeOverride(ImagePullCredentialsType imagePullCredentialsTypeOverride) {
            this.imagePullCredentialsTypeOverride(imagePullCredentialsTypeOverride == null ? null : imagePullCredentialsTypeOverride.toString());
            return this;
        }

        public final ProjectBuildBatchConfig.Builder getBuildBatchConfigOverride() {
            return this.buildBatchConfigOverride != null ? this.buildBatchConfigOverride.toBuilder() : null;
        }

        public final void setBuildBatchConfigOverride(ProjectBuildBatchConfig.BuilderImpl buildBatchConfigOverride) {
            this.buildBatchConfigOverride = buildBatchConfigOverride != null ? buildBatchConfigOverride.build() : null;
        }

        @Override
        public final Builder buildBatchConfigOverride(ProjectBuildBatchConfig buildBatchConfigOverride) {
            this.buildBatchConfigOverride = buildBatchConfigOverride;
            return this;
        }

        public final Boolean getDebugSessionEnabled() {
            return this.debugSessionEnabled;
        }

        public final void setDebugSessionEnabled(Boolean debugSessionEnabled) {
            this.debugSessionEnabled = debugSessionEnabled;
        }

        @Override
        public final Builder debugSessionEnabled(Boolean debugSessionEnabled) {
            this.debugSessionEnabled = debugSessionEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartBuildBatchRequest build() {
            return new StartBuildBatchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeBuildRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartBuildBatchRequest> {
        public Builder projectName(String var1);

        public Builder secondarySourcesOverride(Collection<ProjectSource> var1);

        public Builder secondarySourcesOverride(ProjectSource ... var1);

        public Builder secondarySourcesOverride(Consumer<ProjectSource.Builder> ... var1);

        public Builder secondarySourcesVersionOverride(Collection<ProjectSourceVersion> var1);

        public Builder secondarySourcesVersionOverride(ProjectSourceVersion ... var1);

        public Builder secondarySourcesVersionOverride(Consumer<ProjectSourceVersion.Builder> ... var1);

        public Builder sourceVersion(String var1);

        public Builder artifactsOverride(ProjectArtifacts var1);

        default public Builder artifactsOverride(Consumer<ProjectArtifacts.Builder> artifactsOverride) {
            return this.artifactsOverride((ProjectArtifacts)((ProjectArtifacts.Builder)ProjectArtifacts.builder().applyMutation(artifactsOverride)).build());
        }

        public Builder secondaryArtifactsOverride(Collection<ProjectArtifacts> var1);

        public Builder secondaryArtifactsOverride(ProjectArtifacts ... var1);

        public Builder secondaryArtifactsOverride(Consumer<ProjectArtifacts.Builder> ... var1);

        public Builder environmentVariablesOverride(Collection<EnvironmentVariable> var1);

        public Builder environmentVariablesOverride(EnvironmentVariable ... var1);

        public Builder environmentVariablesOverride(Consumer<EnvironmentVariable.Builder> ... var1);

        public Builder sourceTypeOverride(String var1);

        public Builder sourceTypeOverride(SourceType var1);

        public Builder sourceLocationOverride(String var1);

        public Builder sourceAuthOverride(SourceAuth var1);

        default public Builder sourceAuthOverride(Consumer<SourceAuth.Builder> sourceAuthOverride) {
            return this.sourceAuthOverride((SourceAuth)((SourceAuth.Builder)SourceAuth.builder().applyMutation(sourceAuthOverride)).build());
        }

        public Builder gitCloneDepthOverride(Integer var1);

        public Builder gitSubmodulesConfigOverride(GitSubmodulesConfig var1);

        default public Builder gitSubmodulesConfigOverride(Consumer<GitSubmodulesConfig.Builder> gitSubmodulesConfigOverride) {
            return this.gitSubmodulesConfigOverride((GitSubmodulesConfig)((GitSubmodulesConfig.Builder)GitSubmodulesConfig.builder().applyMutation(gitSubmodulesConfigOverride)).build());
        }

        public Builder buildspecOverride(String var1);

        public Builder insecureSslOverride(Boolean var1);

        public Builder reportBuildBatchStatusOverride(Boolean var1);

        public Builder environmentTypeOverride(String var1);

        public Builder environmentTypeOverride(EnvironmentType var1);

        public Builder imageOverride(String var1);

        public Builder computeTypeOverride(String var1);

        public Builder computeTypeOverride(ComputeType var1);

        public Builder certificateOverride(String var1);

        public Builder cacheOverride(ProjectCache var1);

        default public Builder cacheOverride(Consumer<ProjectCache.Builder> cacheOverride) {
            return this.cacheOverride((ProjectCache)((ProjectCache.Builder)ProjectCache.builder().applyMutation(cacheOverride)).build());
        }

        public Builder serviceRoleOverride(String var1);

        public Builder privilegedModeOverride(Boolean var1);

        public Builder buildTimeoutInMinutesOverride(Integer var1);

        public Builder queuedTimeoutInMinutesOverride(Integer var1);

        public Builder encryptionKeyOverride(String var1);

        public Builder idempotencyToken(String var1);

        public Builder logsConfigOverride(LogsConfig var1);

        default public Builder logsConfigOverride(Consumer<LogsConfig.Builder> logsConfigOverride) {
            return this.logsConfigOverride((LogsConfig)((LogsConfig.Builder)LogsConfig.builder().applyMutation(logsConfigOverride)).build());
        }

        public Builder registryCredentialOverride(RegistryCredential var1);

        default public Builder registryCredentialOverride(Consumer<RegistryCredential.Builder> registryCredentialOverride) {
            return this.registryCredentialOverride((RegistryCredential)((RegistryCredential.Builder)RegistryCredential.builder().applyMutation(registryCredentialOverride)).build());
        }

        public Builder imagePullCredentialsTypeOverride(String var1);

        public Builder imagePullCredentialsTypeOverride(ImagePullCredentialsType var1);

        public Builder buildBatchConfigOverride(ProjectBuildBatchConfig var1);

        default public Builder buildBatchConfigOverride(Consumer<ProjectBuildBatchConfig.Builder> buildBatchConfigOverride) {
            return this.buildBatchConfigOverride((ProjectBuildBatchConfig)((ProjectBuildBatchConfig.Builder)ProjectBuildBatchConfig.builder().applyMutation(buildBatchConfigOverride)).build());
        }

        public Builder debugSessionEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

