/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.PullRequestBuildApproverRole;
import software.amazon.awssdk.services.codebuild.model.PullRequestBuildApproverRolesCopier;
import software.amazon.awssdk.services.codebuild.model.PullRequestBuildCommentApproval;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PullRequestBuildPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PullRequestBuildPolicy> {
    private static final SdkField<String> REQUIRES_COMMENT_APPROVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requiresCommentApproval").getter(PullRequestBuildPolicy.getter(PullRequestBuildPolicy::requiresCommentApprovalAsString)).setter(PullRequestBuildPolicy.setter(Builder::requiresCommentApproval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiresCommentApproval").build()}).build();
    private static final SdkField<List<String>> APPROVER_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("approverRoles").getter(PullRequestBuildPolicy.getter(PullRequestBuildPolicy::approverRolesAsStrings)).setter(PullRequestBuildPolicy.setter(Builder::approverRolesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approverRoles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUIRES_COMMENT_APPROVAL_FIELD, APPROVER_ROLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PullRequestBuildPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String requiresCommentApproval;
    private final List<String> approverRoles;

    private PullRequestBuildPolicy(BuilderImpl builder) {
        this.requiresCommentApproval = builder.requiresCommentApproval;
        this.approverRoles = builder.approverRoles;
    }

    public final PullRequestBuildCommentApproval requiresCommentApproval() {
        return PullRequestBuildCommentApproval.fromValue(this.requiresCommentApproval);
    }

    public final String requiresCommentApprovalAsString() {
        return this.requiresCommentApproval;
    }

    public final List<PullRequestBuildApproverRole> approverRoles() {
        return PullRequestBuildApproverRolesCopier.copyStringToEnum(this.approverRoles);
    }

    public final boolean hasApproverRoles() {
        return this.approverRoles != null && !(this.approverRoles instanceof SdkAutoConstructList);
    }

    public final List<String> approverRolesAsStrings() {
        return this.approverRoles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.requiresCommentApprovalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApproverRoles() ? this.approverRolesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PullRequestBuildPolicy)) {
            return false;
        }
        PullRequestBuildPolicy other = (PullRequestBuildPolicy)obj;
        return Objects.equals(this.requiresCommentApprovalAsString(), other.requiresCommentApprovalAsString()) && this.hasApproverRoles() == other.hasApproverRoles() && Objects.equals(this.approverRolesAsStrings(), other.approverRolesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"PullRequestBuildPolicy").add("RequiresCommentApproval", (Object)this.requiresCommentApprovalAsString()).add("ApproverRoles", this.hasApproverRoles() ? this.approverRolesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requiresCommentApproval": {
                return Optional.ofNullable(clazz.cast(this.requiresCommentApprovalAsString()));
            }
            case "approverRoles": {
                return Optional.ofNullable(clazz.cast(this.approverRolesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("requiresCommentApproval", REQUIRES_COMMENT_APPROVAL_FIELD);
        map.put("approverRoles", APPROVER_ROLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PullRequestBuildPolicy, T> g) {
        return obj -> g.apply((PullRequestBuildPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String requiresCommentApproval;
        private List<String> approverRoles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PullRequestBuildPolicy model) {
            this.requiresCommentApproval(model.requiresCommentApproval);
            this.approverRolesWithStrings(model.approverRoles);
        }

        public final String getRequiresCommentApproval() {
            return this.requiresCommentApproval;
        }

        public final void setRequiresCommentApproval(String requiresCommentApproval) {
            this.requiresCommentApproval = requiresCommentApproval;
        }

        @Override
        public final Builder requiresCommentApproval(String requiresCommentApproval) {
            this.requiresCommentApproval = requiresCommentApproval;
            return this;
        }

        @Override
        public final Builder requiresCommentApproval(PullRequestBuildCommentApproval requiresCommentApproval) {
            this.requiresCommentApproval(requiresCommentApproval == null ? null : requiresCommentApproval.toString());
            return this;
        }

        public final Collection<String> getApproverRoles() {
            if (this.approverRoles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.approverRoles;
        }

        public final void setApproverRoles(Collection<String> approverRoles) {
            this.approverRoles = PullRequestBuildApproverRolesCopier.copy(approverRoles);
        }

        @Override
        public final Builder approverRolesWithStrings(Collection<String> approverRoles) {
            this.approverRoles = PullRequestBuildApproverRolesCopier.copy(approverRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approverRolesWithStrings(String ... approverRoles) {
            this.approverRolesWithStrings(Arrays.asList(approverRoles));
            return this;
        }

        @Override
        public final Builder approverRoles(Collection<PullRequestBuildApproverRole> approverRoles) {
            this.approverRoles = PullRequestBuildApproverRolesCopier.copyEnumToString(approverRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approverRoles(PullRequestBuildApproverRole ... approverRoles) {
            this.approverRoles(Arrays.asList(approverRoles));
            return this;
        }

        public PullRequestBuildPolicy build() {
            return new PullRequestBuildPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PullRequestBuildPolicy> {
        public Builder requiresCommentApproval(String var1);

        public Builder requiresCommentApproval(PullRequestBuildCommentApproval var1);

        public Builder approverRolesWithStrings(Collection<String> var1);

        public Builder approverRolesWithStrings(String ... var1);

        public Builder approverRoles(Collection<PullRequestBuildApproverRole> var1);

        public Builder approverRoles(PullRequestBuildApproverRole ... var1);
    }
}

