/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.Sandbox;
import software.amazon.awssdk.services.codebuild.model.SandboxIdsCopier;
import software.amazon.awssdk.services.codebuild.model.SandboxesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetSandboxesResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, BatchGetSandboxesResponse> {
    private static final SdkField<List<Sandbox>> SANDBOXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sandboxes").getter(BatchGetSandboxesResponse.getter(BatchGetSandboxesResponse::sandboxes)).setter(BatchGetSandboxesResponse.setter(Builder::sandboxes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sandboxes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Sandbox::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SANDBOXES_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sandboxesNotFound").getter(BatchGetSandboxesResponse.getter(BatchGetSandboxesResponse::sandboxesNotFound)).setter(BatchGetSandboxesResponse.setter(Builder::sandboxesNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sandboxesNotFound").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SANDBOXES_FIELD, SANDBOXES_NOT_FOUND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetSandboxesResponse.memberNameToFieldInitializer();
    private final List<Sandbox> sandboxes;
    private final List<String> sandboxesNotFound;

    private BatchGetSandboxesResponse(BuilderImpl builder) {
        super(builder);
        this.sandboxes = builder.sandboxes;
        this.sandboxesNotFound = builder.sandboxesNotFound;
    }

    public final boolean hasSandboxes() {
        return this.sandboxes != null && !(this.sandboxes instanceof SdkAutoConstructList);
    }

    public final List<Sandbox> sandboxes() {
        return this.sandboxes;
    }

    public final boolean hasSandboxesNotFound() {
        return this.sandboxesNotFound != null && !(this.sandboxesNotFound instanceof SdkAutoConstructList);
    }

    public final List<String> sandboxesNotFound() {
        return this.sandboxesNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSandboxes() ? this.sandboxes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSandboxesNotFound() ? this.sandboxesNotFound() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetSandboxesResponse)) {
            return false;
        }
        BatchGetSandboxesResponse other = (BatchGetSandboxesResponse)((Object)obj);
        return this.hasSandboxes() == other.hasSandboxes() && Objects.equals(this.sandboxes(), other.sandboxes()) && this.hasSandboxesNotFound() == other.hasSandboxesNotFound() && Objects.equals(this.sandboxesNotFound(), other.sandboxesNotFound());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetSandboxesResponse").add("Sandboxes", this.hasSandboxes() ? this.sandboxes() : null).add("SandboxesNotFound", this.hasSandboxesNotFound() ? this.sandboxesNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sandboxes": {
                return Optional.ofNullable(clazz.cast(this.sandboxes()));
            }
            case "sandboxesNotFound": {
                return Optional.ofNullable(clazz.cast(this.sandboxesNotFound()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sandboxes", SANDBOXES_FIELD);
        map.put("sandboxesNotFound", SANDBOXES_NOT_FOUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetSandboxesResponse, T> g) {
        return obj -> g.apply((BatchGetSandboxesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private List<Sandbox> sandboxes = DefaultSdkAutoConstructList.getInstance();
        private List<String> sandboxesNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetSandboxesResponse model) {
            super(model);
            this.sandboxes(model.sandboxes);
            this.sandboxesNotFound(model.sandboxesNotFound);
        }

        public final List<Sandbox.Builder> getSandboxes() {
            List<Sandbox.Builder> result = SandboxesCopier.copyToBuilder(this.sandboxes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSandboxes(Collection<Sandbox.BuilderImpl> sandboxes) {
            this.sandboxes = SandboxesCopier.copyFromBuilder(sandboxes);
        }

        @Override
        public final Builder sandboxes(Collection<Sandbox> sandboxes) {
            this.sandboxes = SandboxesCopier.copy(sandboxes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sandboxes(Sandbox ... sandboxes) {
            this.sandboxes(Arrays.asList(sandboxes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sandboxes(Consumer<Sandbox.Builder> ... sandboxes) {
            this.sandboxes(Stream.of(sandboxes).map(c -> (Sandbox)((Sandbox.Builder)Sandbox.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSandboxesNotFound() {
            if (this.sandboxesNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sandboxesNotFound;
        }

        public final void setSandboxesNotFound(Collection<String> sandboxesNotFound) {
            this.sandboxesNotFound = SandboxIdsCopier.copy(sandboxesNotFound);
        }

        @Override
        public final Builder sandboxesNotFound(Collection<String> sandboxesNotFound) {
            this.sandboxesNotFound = SandboxIdsCopier.copy(sandboxesNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sandboxesNotFound(String ... sandboxesNotFound) {
            this.sandboxesNotFound(Arrays.asList(sandboxesNotFound));
            return this;
        }

        @Override
        public BatchGetSandboxesResponse build() {
            return new BatchGetSandboxesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetSandboxesResponse> {
        public Builder sandboxes(Collection<Sandbox> var1);

        public Builder sandboxes(Sandbox ... var1);

        public Builder sandboxes(Consumer<Sandbox.Builder> ... var1);

        public Builder sandboxesNotFound(Collection<String> var1);

        public Builder sandboxesNotFound(String ... var1);
    }
}

