/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WebhookBuildType {
    BUILD("BUILD"),
    BUILD_BATCH("BUILD_BATCH"),
    RUNNER_BUILDKITE_BUILD("RUNNER_BUILDKITE_BUILD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WebhookBuildType> VALUE_MAP;
    private final String value;

    private WebhookBuildType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WebhookBuildType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WebhookBuildType> knownValues() {
        EnumSet<WebhookBuildType> knownValues = EnumSet.allOf(WebhookBuildType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WebhookBuildType.class, WebhookBuildType::toString);
    }
}

