/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.FleetProxyRule;
import software.amazon.awssdk.services.codebuild.model.FleetProxyRuleBehavior;
import software.amazon.awssdk.services.codebuild.model.FleetProxyRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProxyConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProxyConfiguration> {
    private static final SdkField<String> DEFAULT_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultBehavior").getter(ProxyConfiguration.getter(ProxyConfiguration::defaultBehaviorAsString)).setter(ProxyConfiguration.setter(Builder::defaultBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultBehavior").build()}).build();
    private static final SdkField<List<FleetProxyRule>> ORDERED_PROXY_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("orderedProxyRules").getter(ProxyConfiguration.getter(ProxyConfiguration::orderedProxyRules)).setter(ProxyConfiguration.setter(Builder::orderedProxyRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderedProxyRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetProxyRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_BEHAVIOR_FIELD, ORDERED_PROXY_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProxyConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String defaultBehavior;
    private final List<FleetProxyRule> orderedProxyRules;

    private ProxyConfiguration(BuilderImpl builder) {
        this.defaultBehavior = builder.defaultBehavior;
        this.orderedProxyRules = builder.orderedProxyRules;
    }

    public final FleetProxyRuleBehavior defaultBehavior() {
        return FleetProxyRuleBehavior.fromValue(this.defaultBehavior);
    }

    public final String defaultBehaviorAsString() {
        return this.defaultBehavior;
    }

    public final boolean hasOrderedProxyRules() {
        return this.orderedProxyRules != null && !(this.orderedProxyRules instanceof SdkAutoConstructList);
    }

    public final List<FleetProxyRule> orderedProxyRules() {
        return this.orderedProxyRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrderedProxyRules() ? this.orderedProxyRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxyConfiguration)) {
            return false;
        }
        ProxyConfiguration other = (ProxyConfiguration)obj;
        return Objects.equals(this.defaultBehaviorAsString(), other.defaultBehaviorAsString()) && this.hasOrderedProxyRules() == other.hasOrderedProxyRules() && Objects.equals(this.orderedProxyRules(), other.orderedProxyRules());
    }

    public final String toString() {
        return ToString.builder((String)"ProxyConfiguration").add("DefaultBehavior", (Object)this.defaultBehaviorAsString()).add("OrderedProxyRules", this.hasOrderedProxyRules() ? this.orderedProxyRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "defaultBehavior": {
                return Optional.ofNullable(clazz.cast(this.defaultBehaviorAsString()));
            }
            case "orderedProxyRules": {
                return Optional.ofNullable(clazz.cast(this.orderedProxyRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("defaultBehavior", DEFAULT_BEHAVIOR_FIELD);
        map.put("orderedProxyRules", ORDERED_PROXY_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProxyConfiguration, T> g) {
        return obj -> g.apply((ProxyConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultBehavior;
        private List<FleetProxyRule> orderedProxyRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProxyConfiguration model) {
            this.defaultBehavior(model.defaultBehavior);
            this.orderedProxyRules(model.orderedProxyRules);
        }

        public final String getDefaultBehavior() {
            return this.defaultBehavior;
        }

        public final void setDefaultBehavior(String defaultBehavior) {
            this.defaultBehavior = defaultBehavior;
        }

        @Override
        public final Builder defaultBehavior(String defaultBehavior) {
            this.defaultBehavior = defaultBehavior;
            return this;
        }

        @Override
        public final Builder defaultBehavior(FleetProxyRuleBehavior defaultBehavior) {
            this.defaultBehavior(defaultBehavior == null ? null : defaultBehavior.toString());
            return this;
        }

        public final List<FleetProxyRule.Builder> getOrderedProxyRules() {
            List<FleetProxyRule.Builder> result = FleetProxyRulesCopier.copyToBuilder(this.orderedProxyRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrderedProxyRules(Collection<FleetProxyRule.BuilderImpl> orderedProxyRules) {
            this.orderedProxyRules = FleetProxyRulesCopier.copyFromBuilder(orderedProxyRules);
        }

        @Override
        public final Builder orderedProxyRules(Collection<FleetProxyRule> orderedProxyRules) {
            this.orderedProxyRules = FleetProxyRulesCopier.copy(orderedProxyRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedProxyRules(FleetProxyRule ... orderedProxyRules) {
            this.orderedProxyRules(Arrays.asList(orderedProxyRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedProxyRules(Consumer<FleetProxyRule.Builder> ... orderedProxyRules) {
            this.orderedProxyRules(Stream.of(orderedProxyRules).map(c -> (FleetProxyRule)((FleetProxyRule.Builder)FleetProxyRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ProxyConfiguration build() {
            return new ProxyConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProxyConfiguration> {
        public Builder defaultBehavior(String var1);

        public Builder defaultBehavior(FleetProxyRuleBehavior var1);

        public Builder orderedProxyRules(Collection<FleetProxyRule> var1);

        public Builder orderedProxyRules(FleetProxyRule ... var1);

        public Builder orderedProxyRules(Consumer<FleetProxyRule.Builder> ... var1);
    }
}

