/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.CodeCoverageReportSummary;
import software.amazon.awssdk.services.codebuild.model.ReportExportConfig;
import software.amazon.awssdk.services.codebuild.model.ReportStatusType;
import software.amazon.awssdk.services.codebuild.model.ReportType;
import software.amazon.awssdk.services.codebuild.model.TestReportSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Report
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Report> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Report.getter(Report::arn)).setter(Report.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Report.getter(Report::typeAsString)).setter(Report.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Report.getter(Report::name)).setter(Report.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REPORT_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportGroupArn").getter(Report.getter(Report::reportGroupArn)).setter(Report.setter(Builder::reportGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportGroupArn").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(Report.getter(Report::executionId)).setter(Report.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Report.getter(Report::statusAsString)).setter(Report.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("created").getter(Report.getter(Report::created)).setter(Report.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<Instant> EXPIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expired").getter(Report.getter(Report::expired)).setter(Report.setter(Builder::expired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expired").build()}).build();
    private static final SdkField<ReportExportConfig> EXPORT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("exportConfig").getter(Report.getter(Report::exportConfig)).setter(Report.setter(Builder::exportConfig)).constructor(ReportExportConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportConfig").build()}).build();
    private static final SdkField<Boolean> TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("truncated").getter(Report.getter(Report::truncated)).setter(Report.setter(Builder::truncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("truncated").build()}).build();
    private static final SdkField<TestReportSummary> TEST_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("testSummary").getter(Report.getter(Report::testSummary)).setter(Report.setter(Builder::testSummary)).constructor(TestReportSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSummary").build()}).build();
    private static final SdkField<CodeCoverageReportSummary> CODE_COVERAGE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("codeCoverageSummary").getter(Report.getter(Report::codeCoverageSummary)).setter(Report.setter(Builder::codeCoverageSummary)).constructor(CodeCoverageReportSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeCoverageSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TYPE_FIELD, NAME_FIELD, REPORT_GROUP_ARN_FIELD, EXECUTION_ID_FIELD, STATUS_FIELD, CREATED_FIELD, EXPIRED_FIELD, EXPORT_CONFIG_FIELD, TRUNCATED_FIELD, TEST_SUMMARY_FIELD, CODE_COVERAGE_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Report.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String type;
    private final String name;
    private final String reportGroupArn;
    private final String executionId;
    private final String status;
    private final Instant created;
    private final Instant expired;
    private final ReportExportConfig exportConfig;
    private final Boolean truncated;
    private final TestReportSummary testSummary;
    private final CodeCoverageReportSummary codeCoverageSummary;

    private Report(BuilderImpl builder) {
        this.arn = builder.arn;
        this.type = builder.type;
        this.name = builder.name;
        this.reportGroupArn = builder.reportGroupArn;
        this.executionId = builder.executionId;
        this.status = builder.status;
        this.created = builder.created;
        this.expired = builder.expired;
        this.exportConfig = builder.exportConfig;
        this.truncated = builder.truncated;
        this.testSummary = builder.testSummary;
        this.codeCoverageSummary = builder.codeCoverageSummary;
    }

    public final String arn() {
        return this.arn;
    }

    public final ReportType type() {
        return ReportType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String name() {
        return this.name;
    }

    public final String reportGroupArn() {
        return this.reportGroupArn;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final ReportStatusType status() {
        return ReportStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant created() {
        return this.created;
    }

    public final Instant expired() {
        return this.expired;
    }

    public final ReportExportConfig exportConfig() {
        return this.exportConfig;
    }

    public final Boolean truncated() {
        return this.truncated;
    }

    public final TestReportSummary testSummary() {
        return this.testSummary;
    }

    public final CodeCoverageReportSummary codeCoverageSummary() {
        return this.codeCoverageSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.expired());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.truncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeCoverageSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Report)) {
            return false;
        }
        Report other = (Report)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.reportGroupArn(), other.reportGroupArn()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.expired(), other.expired()) && Objects.equals(this.exportConfig(), other.exportConfig()) && Objects.equals(this.truncated(), other.truncated()) && Objects.equals(this.testSummary(), other.testSummary()) && Objects.equals(this.codeCoverageSummary(), other.codeCoverageSummary());
    }

    public final String toString() {
        return ToString.builder((String)"Report").add("Arn", (Object)this.arn()).add("Type", (Object)this.typeAsString()).add("Name", (Object)this.name()).add("ReportGroupArn", (Object)this.reportGroupArn()).add("ExecutionId", (Object)this.executionId()).add("Status", (Object)this.statusAsString()).add("Created", (Object)this.created()).add("Expired", (Object)this.expired()).add("ExportConfig", (Object)this.exportConfig()).add("Truncated", (Object)this.truncated()).add("TestSummary", (Object)this.testSummary()).add("CodeCoverageSummary", (Object)this.codeCoverageSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "reportGroupArn": {
                return Optional.ofNullable(clazz.cast(this.reportGroupArn()));
            }
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "expired": {
                return Optional.ofNullable(clazz.cast(this.expired()));
            }
            case "exportConfig": {
                return Optional.ofNullable(clazz.cast(this.exportConfig()));
            }
            case "truncated": {
                return Optional.ofNullable(clazz.cast(this.truncated()));
            }
            case "testSummary": {
                return Optional.ofNullable(clazz.cast(this.testSummary()));
            }
            case "codeCoverageSummary": {
                return Optional.ofNullable(clazz.cast(this.codeCoverageSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("reportGroupArn", REPORT_GROUP_ARN_FIELD);
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("created", CREATED_FIELD);
        map.put("expired", EXPIRED_FIELD);
        map.put("exportConfig", EXPORT_CONFIG_FIELD);
        map.put("truncated", TRUNCATED_FIELD);
        map.put("testSummary", TEST_SUMMARY_FIELD);
        map.put("codeCoverageSummary", CODE_COVERAGE_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Report, T> g) {
        return obj -> g.apply((Report)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String type;
        private String name;
        private String reportGroupArn;
        private String executionId;
        private String status;
        private Instant created;
        private Instant expired;
        private ReportExportConfig exportConfig;
        private Boolean truncated;
        private TestReportSummary testSummary;
        private CodeCoverageReportSummary codeCoverageSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(Report model) {
            this.arn(model.arn);
            this.type(model.type);
            this.name(model.name);
            this.reportGroupArn(model.reportGroupArn);
            this.executionId(model.executionId);
            this.status(model.status);
            this.created(model.created);
            this.expired(model.expired);
            this.exportConfig(model.exportConfig);
            this.truncated(model.truncated);
            this.testSummary(model.testSummary);
            this.codeCoverageSummary(model.codeCoverageSummary);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ReportType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getReportGroupArn() {
            return this.reportGroupArn;
        }

        public final void setReportGroupArn(String reportGroupArn) {
            this.reportGroupArn = reportGroupArn;
        }

        @Override
        public final Builder reportGroupArn(String reportGroupArn) {
            this.reportGroupArn = reportGroupArn;
            return this;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReportStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getExpired() {
            return this.expired;
        }

        public final void setExpired(Instant expired) {
            this.expired = expired;
        }

        @Override
        public final Builder expired(Instant expired) {
            this.expired = expired;
            return this;
        }

        public final ReportExportConfig.Builder getExportConfig() {
            return this.exportConfig != null ? this.exportConfig.toBuilder() : null;
        }

        public final void setExportConfig(ReportExportConfig.BuilderImpl exportConfig) {
            this.exportConfig = exportConfig != null ? exportConfig.build() : null;
        }

        @Override
        public final Builder exportConfig(ReportExportConfig exportConfig) {
            this.exportConfig = exportConfig;
            return this;
        }

        public final Boolean getTruncated() {
            return this.truncated;
        }

        public final void setTruncated(Boolean truncated) {
            this.truncated = truncated;
        }

        @Override
        public final Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public final TestReportSummary.Builder getTestSummary() {
            return this.testSummary != null ? this.testSummary.toBuilder() : null;
        }

        public final void setTestSummary(TestReportSummary.BuilderImpl testSummary) {
            this.testSummary = testSummary != null ? testSummary.build() : null;
        }

        @Override
        public final Builder testSummary(TestReportSummary testSummary) {
            this.testSummary = testSummary;
            return this;
        }

        public final CodeCoverageReportSummary.Builder getCodeCoverageSummary() {
            return this.codeCoverageSummary != null ? this.codeCoverageSummary.toBuilder() : null;
        }

        public final void setCodeCoverageSummary(CodeCoverageReportSummary.BuilderImpl codeCoverageSummary) {
            this.codeCoverageSummary = codeCoverageSummary != null ? codeCoverageSummary.build() : null;
        }

        @Override
        public final Builder codeCoverageSummary(CodeCoverageReportSummary codeCoverageSummary) {
            this.codeCoverageSummary = codeCoverageSummary;
            return this;
        }

        public Report build() {
            return new Report(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Report> {
        public Builder arn(String var1);

        public Builder type(String var1);

        public Builder type(ReportType var1);

        public Builder name(String var1);

        public Builder reportGroupArn(String var1);

        public Builder executionId(String var1);

        public Builder status(String var1);

        public Builder status(ReportStatusType var1);

        public Builder created(Instant var1);

        public Builder expired(Instant var1);

        public Builder exportConfig(ReportExportConfig var1);

        default public Builder exportConfig(Consumer<ReportExportConfig.Builder> exportConfig) {
            return this.exportConfig((ReportExportConfig)((ReportExportConfig.Builder)ReportExportConfig.builder().applyMutation(exportConfig)).build());
        }

        public Builder truncated(Boolean var1);

        public Builder testSummary(TestReportSummary var1);

        default public Builder testSummary(Consumer<TestReportSummary.Builder> testSummary) {
            return this.testSummary((TestReportSummary)((TestReportSummary.Builder)TestReportSummary.builder().applyMutation(testSummary)).build());
        }

        public Builder codeCoverageSummary(CodeCoverageReportSummary var1);

        default public Builder codeCoverageSummary(Consumer<CodeCoverageReportSummary.Builder> codeCoverageSummary) {
            return this.codeCoverageSummary((CodeCoverageReportSummary)((CodeCoverageReportSummary.Builder)CodeCoverageReportSummary.builder().applyMutation(codeCoverageSummary)).build());
        }
    }
}

