/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MachineType {
    GENERAL("GENERAL"),
    NVME("NVME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MachineType> VALUE_MAP;
    private final String value;

    private MachineType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MachineType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MachineType> knownValues() {
        EnumSet<MachineType> knownValues = EnumSet.allOf(MachineType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MachineType.class, MachineType::toString);
    }
}

