/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BuildBatchPhaseType {
    SUBMITTED("SUBMITTED"),
    DOWNLOAD_BATCHSPEC("DOWNLOAD_BATCHSPEC"),
    IN_PROGRESS("IN_PROGRESS"),
    COMBINE_ARTIFACTS("COMBINE_ARTIFACTS"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    STOPPED("STOPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BuildBatchPhaseType> VALUE_MAP;
    private final String value;

    private BuildBatchPhaseType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BuildBatchPhaseType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BuildBatchPhaseType> knownValues() {
        EnumSet<BuildBatchPhaseType> knownValues = EnumSet.allOf(BuildBatchPhaseType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BuildBatchPhaseType.class, BuildBatchPhaseType::toString);
    }
}

