/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.EnvironmentPlatform;
import software.amazon.awssdk.services.codebuild.model.EnvironmentPlatformsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCuratedEnvironmentImagesResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, ListCuratedEnvironmentImagesResponse> {
    private static final SdkField<List<EnvironmentPlatform>> PLATFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("platforms").getter(ListCuratedEnvironmentImagesResponse.getter(ListCuratedEnvironmentImagesResponse::platforms)).setter(ListCuratedEnvironmentImagesResponse.setter(Builder::platforms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platforms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentPlatform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCuratedEnvironmentImagesResponse.memberNameToFieldInitializer();
    private final List<EnvironmentPlatform> platforms;

    private ListCuratedEnvironmentImagesResponse(BuilderImpl builder) {
        super(builder);
        this.platforms = builder.platforms;
    }

    public final boolean hasPlatforms() {
        return this.platforms != null && !(this.platforms instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentPlatform> platforms() {
        return this.platforms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatforms() ? this.platforms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCuratedEnvironmentImagesResponse)) {
            return false;
        }
        ListCuratedEnvironmentImagesResponse other = (ListCuratedEnvironmentImagesResponse)((Object)obj);
        return this.hasPlatforms() == other.hasPlatforms() && Objects.equals(this.platforms(), other.platforms());
    }

    public final String toString() {
        return ToString.builder((String)"ListCuratedEnvironmentImagesResponse").add("Platforms", this.hasPlatforms() ? this.platforms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "platforms": {
                return Optional.ofNullable(clazz.cast(this.platforms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<EnvironmentPlatform>>> map = new HashMap<String, SdkField<List<EnvironmentPlatform>>>();
        map.put("platforms", PLATFORMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCuratedEnvironmentImagesResponse, T> g) {
        return obj -> g.apply((ListCuratedEnvironmentImagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private List<EnvironmentPlatform> platforms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCuratedEnvironmentImagesResponse model) {
            super(model);
            this.platforms(model.platforms);
        }

        public final List<EnvironmentPlatform.Builder> getPlatforms() {
            List<EnvironmentPlatform.Builder> result = EnvironmentPlatformsCopier.copyToBuilder(this.platforms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlatforms(Collection<EnvironmentPlatform.BuilderImpl> platforms) {
            this.platforms = EnvironmentPlatformsCopier.copyFromBuilder(platforms);
        }

        @Override
        public final Builder platforms(Collection<EnvironmentPlatform> platforms) {
            this.platforms = EnvironmentPlatformsCopier.copy(platforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(EnvironmentPlatform ... platforms) {
            this.platforms(Arrays.asList(platforms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(Consumer<EnvironmentPlatform.Builder> ... platforms) {
            this.platforms(Stream.of(platforms).map(c -> (EnvironmentPlatform)((EnvironmentPlatform.Builder)EnvironmentPlatform.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCuratedEnvironmentImagesResponse build() {
            return new ListCuratedEnvironmentImagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCuratedEnvironmentImagesResponse> {
        public Builder platforms(Collection<EnvironmentPlatform> var1);

        public Builder platforms(EnvironmentPlatform ... var1);

        public Builder platforms(Consumer<EnvironmentPlatform.Builder> ... var1);
    }
}

