/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactAsyncClient;
import software.amazon.awssdk.services.codeartifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsRequest;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageVersionSummary;

public class ListPackageVersionsPublisher
implements SdkPublisher<ListPackageVersionsResponse> {
    private final CodeartifactAsyncClient client;
    private final ListPackageVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPackageVersionsPublisher(CodeartifactAsyncClient client, ListPackageVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPackageVersionsPublisher(CodeartifactAsyncClient client, ListPackageVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPackageVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPackageVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PackageVersionSummary> versions() {
        Function<ListPackageVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.versions() != null) {
                return response.versions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPackageVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPackageVersionsResponseFetcher
    implements AsyncPageFetcher<ListPackageVersionsResponse> {
        private ListPackageVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPackageVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPackageVersionsResponse> nextPage(ListPackageVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListPackageVersionsPublisher.this.client.listPackageVersions(ListPackageVersionsPublisher.this.firstRequest);
            }
            return ListPackageVersionsPublisher.this.client.listPackageVersions((ListPackageVersionsRequest)((Object)ListPackageVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

