/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactAsyncClient;
import software.amazon.awssdk.services.codeartifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeartifact.model.AssetSummary;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsRequest;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsResponse;

public class ListPackageVersionAssetsPublisher
implements SdkPublisher<ListPackageVersionAssetsResponse> {
    private final CodeartifactAsyncClient client;
    private final ListPackageVersionAssetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPackageVersionAssetsPublisher(CodeartifactAsyncClient client, ListPackageVersionAssetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPackageVersionAssetsPublisher(CodeartifactAsyncClient client, ListPackageVersionAssetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPackageVersionAssetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPackageVersionAssetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssetSummary> assets() {
        Function<ListPackageVersionAssetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assets() != null) {
                return response.assets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPackageVersionAssetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPackageVersionAssetsResponseFetcher
    implements AsyncPageFetcher<ListPackageVersionAssetsResponse> {
        private ListPackageVersionAssetsResponseFetcher() {
        }

        public boolean hasNextPage(ListPackageVersionAssetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPackageVersionAssetsResponse> nextPage(ListPackageVersionAssetsResponse previousPage) {
            if (previousPage == null) {
                return ListPackageVersionAssetsPublisher.this.client.listPackageVersionAssets(ListPackageVersionAssetsPublisher.this.firstRequest);
            }
            return ListPackageVersionAssetsPublisher.this.client.listPackageVersionAssets((ListPackageVersionAssetsRequest)((Object)ListPackageVersionAssetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

